/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import java.io.Serializable;
import java.util.ArrayList;
import org.eclnt.jsfserver.elements.util.IValueByToString;
import org.eclnt.jsfserver.util.ArrayListWithChangeIndex;
import org.eclnt.jsfserver.util.IListWithChangeIndex;
import org.eclnt.jsfserver.util.IListWithChangeIndexListener;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;

public class SmartText
implements Serializable,
IValueByToString {
    public static final int F_REGULAR = 0;
    public static final int F_BOLD = 10;
    public static final int F_UNDERLINED = 20;
    public static final int F_SUBSCRIPT = 30;
    public static final int F_SUPERSCRIPT = 40;
    public static final int F_HIGHLIGHTED = 50;
    public static final int F_ADDCOLOR_RED = 1;
    public static final int F_ADDCOLOR_GREEN = 2;
    public static final int F_ADDCOLOR_BLUE = 3;
    int m_changeIndex = 0;
    int m_changeIndexLastGet = -1;
    String m_smartTextCSVLastGet = null;
    String m_text;
    ArrayListWithChangeIndex<SmartTextFormatInfo> m_formatInfos = new ArrayListWithChangeIndex();

    public SmartText(String csvText) {
        this.m_formatInfos.setListWithChangeIndexListener(new IListWithChangeIndexListener(){

            @Override
            public void listItemWasRemoved(IListWithChangeIndex list, Object concreteItem) {
                SmartText.this.updateChangeIndex();
            }

            @Override
            public void listItemWasAdded(IListWithChangeIndex list, Object concreteItem) {
                SmartText.this.updateChangeIndex();
            }

            @Override
            public void listChanged(IListWithChangeIndex list) {
                SmartText.this.updateChangeIndex();
            }
        });
        this.setSmartTextCSV(csvText);
    }

    public String getText() {
        if (this.m_text != null) {
            return this.m_text;
        }
        return "";
    }

    public void addTextFormatInfo(int beginOffset, int endOffset, int format) {
        this.updateChangeIndex();
        this.m_formatInfos.add(new SmartTextFormatInfo(beginOffset, endOffset, format));
    }

    public void clearFormatInfos() {
        this.updateChangeIndex();
        this.m_formatInfos.clear();
    }

    public void setSmartTextCSV(String csvText) {
        if (csvText == null || csvText.length() == 0) {
            this.m_text = null;
            this.m_formatInfos.clear();
        } else {
            try {
                String[] values = ValueManager.decodeCSV(csvText);
                this.m_text = values[0];
                this.m_formatInfos.clear();
                for (int i = 1; i < values.length; i += 3) {
                    int beginOffset = ValueManager.decodeInt(values[i], 0);
                    int endOffset = ValueManager.decodeInt(values[i + 1], 0);
                    int format = ValueManager.decodeInt(values[i + 2], 0);
                    this.addTextFormatInfo(beginOffset, endOffset, format);
                }
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_ERR, "", t);
            }
        }
        this.m_smartTextCSVLastGet = csvText;
        this.m_changeIndexLastGet = this.m_changeIndex;
    }

    public String getSmartTextCSV() {
        if (this.m_changeIndex == this.m_changeIndexLastGet) {
            return this.m_smartTextCSVLastGet;
        }
        if (this.m_text == null) {
            return null;
        }
        ArrayList<String> values = new ArrayList<String>();
        values.add(this.getText());
        for (SmartTextFormatInfo stfi : this.m_formatInfos) {
            values.add("" + stfi.i_beginOffset);
            values.add("" + stfi.i_endOffset);
            values.add("" + stfi.i_format);
        }
        this.m_smartTextCSVLastGet = ValueManager.encodeCSV(values);
        this.m_changeIndexLastGet = this.m_changeIndex;
        return this.m_smartTextCSVLastGet;
    }

    public String toString() {
        return this.getSmartTextCSV();
    }

    public String toHTMLString() {
        if (this.m_text == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<html>");
        for (SmartTextFormatInfo stfi : this.m_formatInfos) {
            if (stfi.isBold()) {
                sb.append("<b>");
            }
            if (stfi.isSubscript()) {
                sb.append("<sub>");
            }
            if (stfi.isSuperscript()) {
                sb.append("<sup>");
            }
            if (stfi.isUnderlined()) {
                sb.append("<u>");
            }
            if (stfi.isUnderlined()) {
                sb.append("<span style=\"background-color:#FFFFC0\">");
            }
            sb.append(this.m_text.substring(stfi.i_beginOffset, stfi.i_endOffset));
            if (stfi.isBold()) {
                sb.append("</b>");
            }
            if (stfi.isSubscript()) {
                sb.append("</sub>");
            }
            if (stfi.isSuperscript()) {
                sb.append("</sup>");
            }
            if (stfi.isUnderlined()) {
                sb.append("</u>");
            }
            if (!stfi.isUnderlined()) continue;
            sb.append("</span>");
        }
        sb.append("</html>");
        return sb.toString();
    }

    private void updateChangeIndex() {
        ++this.m_changeIndex;
    }

    public static class SmartTextFormatInfo {
        int i_beginOffset;
        int i_endOffset;
        int i_format;

        public SmartTextFormatInfo(int beginOffset, int endOffset, int format) {
            this.i_beginOffset = beginOffset;
            this.i_endOffset = endOffset;
            this.i_format = format;
        }

        public boolean isBold() {
            return this.i_format >= 10 && this.i_format <= 13;
        }

        public boolean isUnderlined() {
            return this.i_format >= 20 && this.i_format <= 23;
        }

        public boolean isSubscript() {
            return this.i_format >= 30 && this.i_format <= 33;
        }

        public boolean isSuperscript() {
            return this.i_format >= 30 && this.i_format <= 33;
        }

        public boolean isHighlighted() {
            return this.i_format >= 50 && this.i_format <= 53;
        }

        public int getColorAddon() {
            return this.i_format % 10;
        }
    }
}

