/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class StackedValueKeeper
implements Serializable {
    public static Map<Thread, StackedValueKeeper> s_instances = new Hashtable<Thread, StackedValueKeeper>();
    private static final Object s_syncherGetInstance = new Object();
    private static final Object s_syncherGetIdForName = new Object();
    private static boolean s_syncherGetIdForName_active = false;
    private static final Object s_syncherGetUniqueNameForId = new Object();
    private static boolean s_syncherGetUniqueNameForId_active = false;
    private static final int MAX_NUMBER_OF_TOKENS = 50;
    static int s_currentDictionaryCounter = 1;
    static Map<String, Integer> s_dictionary = new Hashtable<String, Integer>();
    static List<String> s_dictionaryTokens = new ArrayList<String>();
    int[] m_nameIds = new int[50];
    List<String> m_names = new ArrayList<String>();
    Object[] m_values = new Object[50];
    boolean m_isRegisteredForClear = false;
    boolean m_isInRenderPhase = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer getIdForName(String name) {
        Integer result;
        if (s_syncherGetIdForName_active) {
            Object object = s_syncherGetIdForName;
            synchronized (object) {
                StackedValueKeeper.performNothing();
                s_syncherGetIdForName_active = false;
            }
        }
        if ((result = s_dictionary.get(name)) == null) {
            Object object = s_syncherGetIdForName;
            synchronized (object) {
                s_syncherGetIdForName_active = true;
                result = s_dictionary.get(name);
                if (result == null) {
                    result = new Integer(s_currentDictionaryCounter++);
                    s_dictionary.put(name, result);
                }
                s_syncherGetIdForName_active = false;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUniqueNameForId(Integer id, String name) {
        String result;
        int idInt;
        if (s_syncherGetUniqueNameForId_active) {
            Object object = s_syncherGetUniqueNameForId;
            synchronized (object) {
                StackedValueKeeper.performNothing();
                s_syncherGetUniqueNameForId_active = false;
            }
        }
        if ((idInt = id.intValue()) < s_dictionaryTokens.size() && (result = s_dictionaryTokens.get(idInt)) != null) {
            return result;
        }
        Object object = s_syncherGetUniqueNameForId;
        synchronized (object) {
            s_syncherGetUniqueNameForId_active = true;
            while (s_dictionaryTokens.size() <= idInt) {
                s_dictionaryTokens.add(null);
            }
            String result2 = s_dictionaryTokens.get(idInt);
            if (result2 == null) {
                result2 = new String(name.toCharArray());
                s_dictionaryTokens.set(idInt, result2);
            }
            s_syncherGetUniqueNameForId_active = false;
            return result2;
        }
    }

    public static String getUniqueNameForName(String name) {
        if (name == null) {
            return null;
        }
        Integer i = StackedValueKeeper.getIdForName(name);
        return StackedValueKeeper.getUniqueNameForId(i, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StackedValueKeeper getInstance() {
        Thread currentThread = Thread.currentThread();
        StackedValueKeeper instance = s_instances.get(currentThread);
        if (instance == null) {
            Object object = s_syncherGetInstance;
            synchronized (object) {
                instance = s_instances.get(currentThread);
                if (instance == null) {
                    instance = new StackedValueKeeper();
                    s_instances.put(currentThread, instance);
                }
            }
        }
        return instance;
    }

    public PickResult pickValueById(int[] nameIds, String[] names) {
        PickResult result = new PickResult();
        result.i_level = -1;
        if (!this.m_isInRenderPhase) {
            return result;
        }
        int i = 0;
        while (i < nameIds.length && nameIds[i] == this.m_nameIds[i]) {
            result.i_level = i++;
        }
        if (result.i_level >= 0) {
            result.i_value = this.m_values[result.i_level];
        }
        return result;
    }

    public void renderingBegins() {
        this.m_isInRenderPhase = true;
        this.clearStack();
    }

    public void renderingEnds() {
        this.m_isInRenderPhase = false;
        this.clearStack();
        s_instances.remove(Thread.currentThread());
    }

    public void clearStack() {
        this.m_names.clear();
        this.m_values = new Object[50];
        this.m_nameIds = new int[50];
    }

    public void addValue(Object value, int nameId, int level) {
        if (!this.m_isInRenderPhase) {
            return;
        }
        this.m_nameIds[level] = nameId;
        this.m_values[level] = value;
        for (int i = level + 1; i < 50; ++i) {
            if (this.m_nameIds[i] == 0) {
                return;
            }
            this.m_nameIds[i] = 0;
        }
    }

    private static void performNothing() {
    }

    public class PickResult {
        Object i_value;
        int i_level;

        public Object getValue() {
            return this.i_value;
        }

        public int getLevel() {
            return this.i_level;
        }
    }
}

