/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import com.veracode.annotation.FilePathCleanser;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.servlet.ServletContext;
import org.eclnt.jsfserver.session.UsageWithoutSessionContext;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.valuemgmt.ValueManager;

public class WebResourceReader {
    static ServletContext s_servletContext;
    static Map<String, Boolean> s_fileExisitsInfo;

    public static void intialize(ServletContext servletContext) {
        s_servletContext = servletContext;
    }

    public static String readUTF8FileIntoString(String resourcePath) {
        try {
            byte[] content = WebResourceReader.readFileIntoByteArray(resourcePath);
            return new String(content, "UTF-8");
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }

    public static String readUTF8FileIntoString(String resourcePath, ServletContext servletContext, boolean withError) {
        try {
            byte[] content = WebResourceReader.readFileIntoByteArray(resourcePath, servletContext);
            return new String(content, "UTF-8");
        }
        catch (Throwable t) {
            if (withError) {
                throw new Error(t);
            }
            return null;
        }
    }

    public static String readUTF8FileIntoString(String resourcePath, boolean withError) {
        try {
            String result = WebResourceReader.readUTF8FileIntoString(resourcePath);
            return result;
        }
        catch (Throwable t) {
            if (withError) {
                throw new Error(t);
            }
            return null;
        }
    }

    public static byte[] readFileIntoByteArray(String resourcePath) {
        return WebResourceReader.readFileIntoByteArray(resourcePath, s_servletContext);
    }

    public static boolean checkIfFileExists(String resourcePath) {
        Boolean bufferedValue = s_fileExisitsInfo.get(resourcePath);
        if (bufferedValue != null) {
            return bufferedValue;
        }
        InputStream is = null;
        try {
            is = WebResourceReader.readFileIntoInputStream(resourcePath, true);
            is.close();
            s_fileExisitsInfo.put(resourcePath, true);
            return true;
        }
        catch (Throwable t) {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            s_fileExisitsInfo.put(resourcePath, false);
            return false;
        }
    }

    public static InputStream readFileIntoInputStream(String resourcePath, boolean withError) {
        return WebResourceReader.readFileIntoInputStream(resourcePath, s_servletContext, withError);
    }

    public static InputStream readFileIntoInputStream(String resourcePath, ServletContext servletContext, boolean withError) {
        try {
            resourcePath = ValueManager.encodeIntoValidWebResourcePath(resourcePath, false);
            if (UsageWithoutSessionContext.isUsedWithoutSessionContext() && UsageWithoutSessionContext.findWebcontentDirectory() != null) {
                String webContentDir = UsageWithoutSessionContext.findWebcontentDirectory();
                String fileName = webContentDir + "/" + resourcePath;
                fileName = ValueManager.encodeIntoValidFileName(fileName, false);
                return FileManager.readFileInputStream(fileName, true);
            }
            InputStream is = WebResourceReader.openServletContextResourceAsStream(servletContext, resourcePath);
            if (is == null) {
                throw new Exception("WebResource is not available: " + resourcePath);
            }
            return is;
        }
        catch (Throwable t) {
            if (withError) {
                throw new Error("Problem reading input stream for: " + resourcePath, t);
            }
            return null;
        }
    }

    public static byte[] readFileIntoByteArray(String resourcePath, ServletContext servletContext) {
        if (UsageWithoutSessionContext.isUsedWithoutSessionContext() && UsageWithoutSessionContext.findWebcontentDirectory() != null) {
            String webContentDir = UsageWithoutSessionContext.findWebcontentDirectory();
            String fileName = webContentDir + "/" + resourcePath;
            fileName = ValueManager.encodeIntoValidFileName(fileName, false);
            return FileManager.readFile(fileName, true);
        }
        resourcePath = ValueManager.encodeIntoValidWebResourcePath(resourcePath, false);
        byte[] result = null;
        byte[] temp = new byte[1000];
        int index = 0;
        Vector<byte[]> resultVector = new Vector<byte[]>();
        try {
            InputStream is = WebResourceReader.openServletContextResourceAsStream(servletContext, resourcePath);
            if (is == null) {
                throw new Exception("WebResource is not available: " + resourcePath);
            }
            DataInputStream dis = new DataInputStream(is);
            index = 0;
            while (true) {
                byte b;
                temp[index] = b = dis.readByte();
                if (++index < 1000) continue;
                resultVector.addElement(temp);
                temp = new byte[1000];
                index = 0;
            }
        }
        catch (Throwable t) {
            if (!(t instanceof EOFException)) {
                throw new Error(t.toString());
            }
            if (index > 0 || resultVector.size() > 0) {
                result = new byte[index + resultVector.size() * 1000];
                for (int i = 0; i < resultVector.size(); ++i) {
                    byte[] tempCopy = (byte[])resultVector.get(i);
                    for (int j = 0; j < 1000; ++j) {
                        result[i * 1000 + j] = tempCopy[j];
                    }
                }
                for (int j = 0; j < index; ++j) {
                    result[resultVector.size() * 1000 + j] = temp[j];
                }
            }
            return result;
        }
    }

    public static String getRealPath(String path) {
        if (UsageWithoutSessionContext.isUsedWithoutSessionContext() && UsageWithoutSessionContext.findWebcontentDirectory() != null) {
            String webContentDir = UsageWithoutSessionContext.findWebcontentDirectory();
            String fileName = webContentDir + "/" + path;
            fileName = ValueManager.encodeIntoValidFileName(fileName, false);
            return fileName;
        }
        try {
            return s_servletContext.getRealPath(path);
        }
        catch (Throwable t) {
            throw new Error("Problem to read path from servlet context: " + path, t);
        }
    }

    public static List<String> getFilesInPathDirectoryByPattern(String path, String pattern, String extension) {
        return WebResourceReader.getFilesInPathDirectoryByPattern(s_servletContext, path, pattern, extension);
    }

    public static List<String> getFilesInPathDirectoryByPattern(ServletContext servletContext, String path, String pattern, String extension) {
        path = ValueManager.encodeIntoValidWebResourcePath(path, true);
        ArrayList<String> result = new ArrayList<String>();
        Set<String> fileNames = WebResourceReader.getFilesInPathDirectory(servletContext, path, extension);
        for (String fileName : fileNames) {
            if (!fileName.startsWith(pattern + ".")) continue;
            result.add(fileName);
        }
        return result;
    }

    public static Set<String> getFilesInPathDirectory(String path, String extension) {
        return WebResourceReader.getFilesInPathDirectory(s_servletContext, path, extension);
    }

    public static Set<String> getFilesInPathDirectory(String path) {
        return WebResourceReader.getFilesInPathDirectory(s_servletContext, path, null);
    }

    public static Set<String> getFilesInPathDirectory(ServletContext servletContext, String path, String extension) {
        try {
            HashSet<String> result = new HashSet<String>();
            if (UsageWithoutSessionContext.isUsedWithoutSessionContext() && UsageWithoutSessionContext.findWebcontentDirectory() != null) {
                String webContentDir = UsageWithoutSessionContext.findWebcontentDirectory();
                String dirName = webContentDir + "/" + path;
                dirName = ValueManager.encodeIntoValidFileName(dirName, true);
                List<String> names = FileManager.getFilesOfDirectoryByPattern(dirName, extension);
                for (String name : names) {
                    result.add(new File(name).getName());
                }
                return result;
            }
            Set paths = servletContext.getResourcePaths(path = ValueManager.encodeIntoValidWebResourcePath(path, true));
            if (paths != null) {
                for (String filePath : paths) {
                    if (filePath.endsWith("/")) continue;
                    int lastSlashIndex = filePath.lastIndexOf(47);
                    filePath = filePath.substring(lastSlashIndex + 1);
                    if (extension != null && !filePath.endsWith(extension)) continue;
                    result.add(filePath);
                }
            }
            return result;
        }
        catch (Throwable t) {
            return new HashSet<String>();
        }
    }

    public static List<String> getDirectoriesInPathDirectory(String path) {
        try {
            if (UsageWithoutSessionContext.isUsedWithoutSessionContext() && UsageWithoutSessionContext.findWebcontentDirectory() != null) {
                String webContentDir = UsageWithoutSessionContext.findWebcontentDirectory();
                String dirName = webContentDir + "/" + path;
                dirName = ValueManager.encodeIntoValidFileName(dirName, true);
                List<File> dirs = FileManager.getDirectoriesOfDirectory(dirName);
                ArrayList<String> result = new ArrayList<String>();
                for (File dir : dirs) {
                    result.add(dir.getName());
                }
                return result;
            }
            path = ValueManager.encodeIntoValidWebResourcePath(path, true);
            Set paths = s_servletContext.getResourcePaths(path);
            ArrayList<String> result = new ArrayList<String>();
            for (String filePath : paths) {
                if (!filePath.endsWith("/")) continue;
                filePath = filePath.substring(0, filePath.length() - 1);
                int lastSlashIndex = filePath.lastIndexOf(47);
                filePath = filePath.substring(lastSlashIndex + 1);
                result.add(filePath);
            }
            return result;
        }
        catch (Throwable t) {
            return new ArrayList<String>();
        }
    }

    @FilePathCleanser(userComment="This methid is both used for internal (for reading configuration files) purposes and is used for external reading (response to http-request). - The internal reading is done in order to load e.g. configuration files, and cannot be influenced from outside. - The external reading is use to access resources that are stored in the web content. Any external reading is restricte by extensions that are defined in class ResourceSecurity.")
    private static InputStream openServletContextResourceAsStream(ServletContext servletContext, String resourcePath) {
        InputStream is = servletContext.getResourceAsStream(ValueManager.approveFileName(resourcePath));
        return is;
    }

    static {
        s_fileExisitsInfo = new Hashtable<String, Boolean>();
    }
}

