/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.tool;

import org.eclnt.util.file.FileManager;
import org.eclnt.util.valuemgmt.ValueManager;

public class CheckCreationOfArtifacts {
    private static final String GROUP = "org.eclnt";
    private static final String[] JARARTIFACTS = new String[]{"eclntccaddons", "eclntccaddons_jakarta", "eclntccee", "eclntccee_jakarta", "eclntccee_spring", "eclntccee_spring_jakarta", "eclntdataapp", "eclntdataapp_jakarta", "eclntclientfx", "eclntjsfserver", "eclntjsfserverRISC", "eclntjsfserverRISC_jakarta", "eclntjsfserver_jsfimpl", "eclntpbc", "eclntpbc_jakarta", "eclntsjrxml", "eclntsource", "eclntutil", "eclntwebappaddons", "eclntwebappaddonsRISC", "eclntwebapparchetype", "eclntwebapparchetype_jakarta", "eclntwebapparchetype_spring", "eclntwebapparchetype_springboot", "eclntwebapparchetype_springboot_jakarta", "eclntwebapparchetype_spring_jakarta", "eclntxcsamllogout", "eclntdataapp", "eclnthotswap", "ccdabase", "ccdaclog", "ccdabase", "ccdabase_jakarta", "ccdaclog", "ccdaclog_jakarta"};
    private static final String[] WARARTIFACTS = new String[]{"eclnteditor", "eclnteditor_jakarta", "eclnteditor_springboot", "eclnteditor_springboot_jakarta"};
    private static final String[] JAREXTENSIONS = new String[]{".jar", ".pom", ".jar.md5", ".jar.sha1", ".pom.md5", ".pom.sha1"};
    private static final String[] WAREXTENSIONS = new String[]{".war", ".pom"};

    public static void main(String[] args) {
        String directory = "C:/bmu_jtc/git/eclnt_jsfserver/ztemp/mavenrepository";
        String version = "20240116_INT1";
        if (args.length >= 1) {
            directory = args[0];
        }
        if (args.length >= 2) {
            version = args[1];
        }
        boolean result = CheckCreationOfArtifacts.checkAllArtifacts(directory, version);
        System.out.println();
        if (!result) {
            System.out.println("**********: -----------------------------------------------------");
            System.out.println("**********: Check Failed! " + version);
            System.out.println("**********: -----------------------------------------------------");
            throw new Error("Check for creation of artifacts failed");
        }
        System.out.println("**********: -----------------------------------------------------");
        System.out.println("**********: Check OK. " + version);
        System.out.println("**********: -----------------------------------------------------");
    }

    private static boolean checkAllArtifacts(String directory, String version) {
        boolean stepResult;
        boolean result = true;
        for (String artifact : JARARTIFACTS) {
            stepResult = CheckCreationOfArtifacts.checkArtifact(directory, artifact, version, JAREXTENSIONS);
            if (stepResult) continue;
            result = false;
        }
        for (String artifact : WARARTIFACTS) {
            stepResult = CheckCreationOfArtifacts.checkArtifact(directory, artifact, version, WAREXTENSIONS);
            if (stepResult) continue;
            result = false;
        }
        return result;
    }

    private static boolean checkArtifact(String directory, String artifact, String version, String[] extensions) {
        System.out.println("**********: " + artifact);
        boolean result = true;
        String fullName = directory + "/" + GROUP.replace(".", "/") + "/" + artifact + "/" + version + "/" + artifact + "-" + version;
        fullName = ValueManager.encodeIntoValidFileName(fullName, false);
        for (String extension : extensions) {
            String fullNameWithExtension = fullName + extension;
            if (FileManager.checkIfFileExists(fullNameWithExtension)) {
                System.out.println("OK        : " + fullNameWithExtension);
                continue;
            }
            System.out.println("MISSING   : " + fullNameWithExtension);
            result = false;
        }
        return result;
    }
}

