/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.file;

import com.veracode.annotation.FilePathCleanser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclnt.util.file.FileManagerSecurityError;
import org.eclnt.util.log.IObserver;
import org.eclnt.util.log.ULog;
import org.eclnt.util.valuemgmt.ValueManager;

public class FileManager {
    static Set<String> s_allowedRootsRead = new HashSet<String>();
    static Set<String> s_allowedRootsWrite = new HashSet<String>();

    public static synchronized void addAllowedRootDirectoryReadWrite(String rootDirectoryName) {
        FileManager.addAllowesRootDirectory(rootDirectoryName, true, true);
    }

    public static synchronized void addAllowedRootDirectoryRead(String rootDirectoryName) {
        FileManager.addAllowesRootDirectory(rootDirectoryName, true, false);
    }

    @FilePathCleanser(userComment="This method is one which is adding directory names to the white list of allowed directories. The name of the directory is explicitly checked against occurance of \"..\".")
    private static void addAllowesRootDirectory(String rootDirectoryName, boolean read, boolean write) {
        if (rootDirectoryName == null) {
            return;
        }
        try {
            if (rootDirectoryName == null) {
                return;
            }
            File f = new File(ValueManager.approveFileName(rootDirectoryName));
            String fileName = f.getCanonicalPath();
            fileName = ValueManager.encodeIntoValidFileName(fileName, true);
            ULog.logINF("FileManager: adding allowed directory " + fileName + ", read: " + read + ", write: " + write);
            if (read) {
                s_allowedRootsRead.add(fileName);
            }
            if (write) {
                s_allowedRootsWrite.add(fileName);
            }
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }

    private static void checkFileAccessRead(File file) {
        FileManager.checkFileAccessRead(file.getAbsolutePath());
    }

    private static void checkFileAccessWrite(File file) {
        FileManager.checkFileAccessWrite(file.getAbsolutePath());
    }

    private static void checkFileAccessRead(String fileName) {
        FileManager.checkFileAccess(fileName, false);
    }

    private static void checkFileAccessWrite(String fileName) {
        FileManager.checkFileAccess(fileName, true);
    }

    @FilePathCleanser(userComment="This method does not read/write the file - but approves if the (absolute) file name to be part of a white list of directories in which file access is allowed and if the file name containes any \"..\" navigation")
    private static void checkFileAccess(String fileName, boolean write) {
        if (fileName == null) {
            return;
        }
        if (s_allowedRootsRead.size() == 0 && s_allowedRootsWrite.size() == 0) {
            return;
        }
        Set<String> roots = s_allowedRootsWrite;
        if (!write) {
            roots = s_allowedRootsRead;
        }
        try {
            File f = new File(ValueManager.approveFileName(fileName));
            String compareFileName = f.getCanonicalPath();
            compareFileName = ValueManager.encodeIntoValidFileName(compareFileName, true);
            for (String root : roots) {
                if (!compareFileName.startsWith(root)) continue;
                return;
            }
            throw new FileManagerSecurityError(fileName);
        }
        catch (Throwable t) {
            throw new Error("Problem when checking file access for: " + fileName, t);
        }
    }

    public static List<String> getFilesOfDirectoryByPattern(String directoryName, String[] extensions) {
        FileManager.checkFileAccessRead(directoryName);
        ArrayList<String> result = new ArrayList<String>();
        List<File> files = FileManager.getFilesOfDirectory(directoryName);
        for (File file : files) {
            String fileAbsoluteName = file.getAbsolutePath();
            boolean match = false;
            if (extensions != null) {
                String fileSimpleName = file.getName();
                for (String extension : extensions) {
                    if (extension == null || !fileSimpleName.endsWith(extension)) continue;
                    match = true;
                    break;
                }
            } else {
                match = true;
            }
            if (!match) continue;
            result.add(fileAbsoluteName);
        }
        return result;
    }

    public static List<String> getFilesOfDirectoryByPattern(String directoryName, String extension) {
        FileManager.checkFileAccessRead(directoryName);
        ArrayList<String> result = new ArrayList<String>();
        List<File> files = FileManager.getFilesOfDirectory(directoryName);
        for (File file : files) {
            String fileAbsoluteName = file.getAbsolutePath();
            String fileSimpleName = file.getName();
            if (extension != null && !fileSimpleName.endsWith(extension)) continue;
            result.add(fileAbsoluteName);
        }
        Collections.sort(result);
        return result;
    }

    public static List<String> getFilesOfDirectoryByPattern(String directoryName, String pattern, String extension) {
        FileManager.checkFileAccessRead(directoryName);
        ArrayList<String> result = new ArrayList<String>();
        List<File> files = FileManager.getFilesOfDirectory(directoryName);
        for (File file : files) {
            String fileAbsoluteName = file.getAbsolutePath();
            String fileSimpleName = file.getName();
            if (extension != null && !fileSimpleName.endsWith(extension) || !fileSimpleName.startsWith(pattern + ".")) continue;
            result.add(fileAbsoluteName);
        }
        Collections.sort(result);
        return result;
    }

    @FilePathCleanser(userComment="Internal utility function. The directoryName is checked against a white list of allowed directories and is checked to not contain any \"..\" navigation.")
    public static List<File> getFilesOfDirectory(String directoryName) {
        FileManager.checkFileAccessRead(directoryName);
        directoryName = directoryName.replace('\\', '/');
        try {
            File directory = new File(ValueManager.approveFileName(directoryName));
            File[] subFiles = directory.listFiles();
            ArrayList<File> result = new ArrayList<File>();
            for (int i = 0; i < subFiles.length; ++i) {
                if (subFiles[i].isDirectory()) continue;
                result.add(subFiles[i]);
            }
            Collections.sort(result);
            return result;
        }
        catch (Exception exc) {
            return new ArrayList<File>();
        }
    }

    @FilePathCleanser(userComment="Internal utility function. The directoryName is checked against a white list of allowed directories and is checked to not contain any \"..\" navigation.")
    public static List<File> getDirectoriesOfDirectory(String directoryName) {
        FileManager.checkFileAccessRead(directoryName);
        directoryName = directoryName.replace('\\', '/');
        try {
            File directory = new File(ValueManager.approveFileName(directoryName));
            File[] subFiles = directory.listFiles();
            ArrayList<File> result = new ArrayList<File>();
            for (int i = 0; i < subFiles.length; ++i) {
                if (!subFiles[i].isDirectory()) continue;
                result.add(subFiles[i]);
            }
            Collections.sort(result);
            return result;
        }
        catch (Exception exc) {
            return new ArrayList<File>();
        }
    }

    public static void ensureDirectoryForFileExists(String fileName) {
        fileName = ValueManager.encodeIntoValidFileName(fileName, false);
        FileManager.checkFileAccessWrite(fileName);
        try {
            int currentIndex = 0;
            while (true) {
                if ((currentIndex = fileName.indexOf(47, currentIndex + 1)) < 0) {
                    return;
                }
                String dirName = fileName.substring(0, currentIndex);
                if (FileManager.checkIfFileExists(dirName, true)) continue;
                FileManager.createDirectory(dirName);
            }
        }
        catch (Throwable t) {
            ULog.logERR("Could not create directory for file: " + fileName, t);
            return;
        }
    }

    public static void ensureDirectoryExists(String dirName) {
        dirName = ValueManager.encodeIntoValidFileName(dirName, true);
        FileManager.ensureDirectoryForFileExists(dirName + "test.test");
    }

    public static boolean checkIfFileExists(String fileName) {
        return FileManager.checkIfFileExists(fileName, false);
    }

    @FilePathCleanser(userComment="File name that is passed is checked against white list of allowed directories and is checked for not containing \"..\"-navigation.")
    public static boolean checkIfFileExists(String fileName, boolean internalCall) {
        if (!internalCall) {
            FileManager.checkFileAccessRead(fileName);
        }
        fileName = fileName.replace('\\', '/');
        try {
            File file = new File(ValueManager.approveFileName(fileName));
            return file.exists();
        }
        catch (Exception exc) {
            return false;
        }
    }

    public static void deleteDirectory(String dirName) {
        if (dirName == null) {
            return;
        }
        FileManager.checkFileAccessWrite(dirName);
        FileManager.deleteDirectoryContent(dirName);
        FileManager.deleteFile(dirName);
    }

    public static void deleteDirectoryContent(String dirName) {
        if (dirName == null) {
            return;
        }
        FileManager.checkFileAccessWrite(dirName);
        ULog.logINF("Removing directory: " + dirName);
        FileManager.deleteDirectoryContent(dirName, true);
    }

    public static void deleteDirectoryContent(String dirName, boolean deleteSubDirectories) {
        if (dirName == null) {
            return;
        }
        FileManager.checkFileAccessWrite(dirName);
        try {
            dirName = dirName.replace('\\', '/');
            List<File> files = FileManager.getFilesOfDirectory(dirName);
            for (File file : files) {
                FileManager.deleteFile(file.getAbsolutePath());
            }
            if (deleteSubDirectories) {
                List<File> dirs = FileManager.getDirectoriesOfDirectory(dirName);
                for (File dir : dirs) {
                    try {
                        FileManager.deleteDirectoryContent(dir.getAbsolutePath());
                        FileManager.deleteFile(dir.getAbsolutePath());
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        catch (Throwable exc) {
            ULog.logINF("Problems removing directory: " + dirName + "\n" + exc.toString());
        }
    }

    @FilePathCleanser(userComment="File name that is passed is checked against white list of allowed directories and is checked for not containing \"..\"-navigation.")
    public static void deleteFile(String fileName) {
        if (fileName == null) {
            return;
        }
        FileManager.checkFileAccessWrite(fileName);
        fileName = fileName.replace('\\', '/');
        try {
            ULog.logINF("Removing file: " + fileName);
            File file = new File(ValueManager.approveFileName(fileName));
            file.delete();
        }
        catch (Exception exc) {
            ULog.logINF("Problems removing file: " + fileName);
        }
    }

    public static String readUTF8File(String fileName, boolean withError) {
        FileManager.checkFileAccessRead(fileName);
        return FileManager.readTextFile(fileName, ValueManager.CHARSET_UTF8.displayName(), withError);
    }

    public static String readTextFile(String fileName, String encoding, boolean withError) {
        FileManager.checkFileAccessRead(fileName);
        try {
            byte[] content = FileManager.readFile(fileName, withError);
            if (encoding != null) {
                return new String(content, encoding);
            }
            return new String(content);
        }
        catch (Throwable t) {
            if (withError) {
                throw new Error("Could not read " + fileName, t);
            }
            return new String();
        }
    }

    public static byte[] readLastBytesOfFile(File file, int numberOfBytes, boolean withError) {
        FileManager.checkFileAccessRead(file);
        try {
            int n = (int)file.length();
            if (n <= numberOfBytes) {
                FileInputStream is = new FileInputStream(file);
                byte[] bytes = new byte[n];
                ((InputStream)is).read(bytes, 0, n);
                ((InputStream)is).close();
                return bytes;
            }
            FileInputStream is = new FileInputStream(file);
            byte[] bytes = new byte[numberOfBytes];
            ((InputStream)is).skip(n - numberOfBytes);
            ((InputStream)is).read(bytes, 0, numberOfBytes);
            ((InputStream)is).close();
            return bytes;
        }
        catch (Throwable t) {
            if (withError) {
                throw new Error("Could not read last " + numberOfBytes + " bytes of file: " + file.getAbsolutePath(), t);
            }
            return new byte[0];
        }
    }

    @FilePathCleanser(userComment="File name that is passed is checked against white list of allowed directories and is checked for not containing \"..\"-navigation.")
    public static byte[] readFile(String fileName, boolean withError) {
        FileManager.checkFileAccessRead(fileName);
        fileName = ValueManager.encodeIntoValidFileName(fileName, false);
        try {
            File file = new File(ValueManager.approveFileName(fileName));
            int n = (int)file.length();
            FileInputStream is = new FileInputStream(ValueManager.approveFileName(fileName));
            byte[] bytes = new byte[n];
            ((InputStream)is).read(bytes, 0, n);
            ((InputStream)is).close();
            return bytes;
        }
        catch (Throwable t) {
            if (withError) {
                throw new Error("Could not read " + fileName, t);
            }
            return new byte[0];
        }
    }

    @FilePathCleanser(userComment="File name that is passed is checked against white list of allowed directories and is checked for not containing \"..\"-navigation.")
    public static InputStream readFileInputStream(String fileName, boolean withError) {
        FileManager.checkFileAccessRead(fileName);
        fileName = ValueManager.encodeIntoValidFileName(fileName, false);
        try {
            File file = new File(ValueManager.approveFileName(fileName));
            int n = (int)file.length();
            FileInputStream is = new FileInputStream(ValueManager.approveFileName(fileName));
            return is;
        }
        catch (Throwable t) {
            if (withError) {
                throw new Error("Could not read " + fileName, t);
            }
            return null;
        }
    }

    @FilePathCleanser(userComment="File name that is passed is checked against white list of allowed directories and is checked for not containing \"..\"-navigation.")
    public static void ensureFileIsWriteable(String fileName, boolean withError) {
        block2: {
            FileManager.checkFileAccessWrite(fileName);
            try {
                File f = new File(ValueManager.approveFileName(fileName));
                FileManager.ensureFileIsWriteable(f, withError);
            }
            catch (Throwable t) {
                if (!withError) break block2;
                throw new Error("Problem when ensuring that file is writeable: " + fileName, t);
            }
        }
    }

    private static void ensureFileIsWriteable(File file, boolean withError) {
        block2: {
            try {
                file.setWritable(true, true);
            }
            catch (Throwable t) {
                if (!withError) break block2;
                throw new Error("Problem when ensuring that file is writeable: " + file.getAbsolutePath(), t);
            }
        }
    }

    public static void writeUTF8File(String fileName, String content, boolean withError) {
        FileManager.checkFileAccessWrite(fileName);
        FileManager.writeTextFile(fileName, content, ValueManager.CHARSET_UTF8.displayName(), withError);
    }

    public static void writeTextFile(String fileName, String content, String encoding, boolean withError) {
        block2: {
            FileManager.checkFileAccessWrite(fileName);
            try {
                byte[] bytes = encoding != null ? content.getBytes(encoding) : content.getBytes();
                FileManager.writeFile(fileName, bytes, withError);
            }
            catch (Throwable t) {
                if (!withError) break block2;
                throw new Error("Could not write " + fileName, t);
            }
        }
    }

    @FilePathCleanser(userComment="File name that is passed is checked against white list of allowed directories and is checked for not containing \"..\"-navigation.")
    public static void writeFile(String fileName, byte[] bytes, boolean withError) {
        block3: {
            FileManager.checkFileAccessWrite(fileName);
            if (bytes == null) {
                return;
            }
            fileName = fileName.replace('\\', '/');
            try {
                FileOutputStream fos = new FileOutputStream(ValueManager.approveFileName(fileName));
                fos.write(bytes);
                fos.close();
                FileManager.ensureFileIsWriteable(fileName, false);
            }
            catch (Throwable t) {
                if (!withError) break block3;
                throw new Error("Could not write byte array into file " + fileName, t);
            }
        }
    }

    public static boolean mkdir(String directory) {
        FileManager.checkFileAccessWrite(directory);
        directory = ValueManager.encodeIntoValidFileName(directory, true);
        try {
            String parentDirectory;
            File f;
            directory = directory.substring(0, directory.length() - 1);
            int lastSlash = directory.lastIndexOf(47);
            if (lastSlash > 0 && !(f = new File(parentDirectory = directory.substring(0, lastSlash))).exists()) {
                FileManager.mkdir(parentDirectory);
            }
            FileManager.createDirectory(directory);
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    @FilePathCleanser(userComment="File name that is passed is checked against white list of allowed directories and is checked for not containing \"..\"-navigation.")
    public static boolean createDirectory(String directory) {
        try {
            FileManager.checkFileAccessWrite(directory);
            directory = ValueManager.encodeIntoValidFileName(directory, true);
            File f = new File(ValueManager.approveFileName(directory));
            FileManager.ensureFileIsWriteable(f, true);
            return f.mkdir();
        }
        catch (Exception exc) {
            throw new Error("Could not create directory " + directory + ".");
        }
    }

    @FilePathCleanser(userComment="File name that is passed is checked against white list of allowed directories and is checked for not containing \"..\"-navigation.")
    public static File createFileInstance(String fileName) {
        fileName = ValueManager.encodeIntoValidFileName(fileName, false);
        FileManager.checkFileAccessWrite(fileName);
        return new File(fileName);
    }

    public static void copyFile(String fromFile, String toFile, boolean withError) {
        FileManager.copyFile(fromFile, toFile, 1024, withError);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copyFile(String fromFile, String toFile, int bufferSize, boolean withError) {
        OutputStream os;
        block21: {
            FileManager.checkFileAccessRead(fromFile);
            FileManager.checkFileAccessWrite(toFile);
            FileInputStream is = null;
            os = null;
            try {
                int length;
                is = new FileInputStream(fromFile);
                os = new FileOutputStream(toFile);
                byte[] buffer2332 = new byte[bufferSize];
                while ((length = ((InputStream)is).read(buffer2332)) > 0) {
                    os.write(buffer2332, 0, length);
                }
                if (is == null) break block21;
            }
            catch (Throwable t) {
                try {
                    if (withError) throw new Error("Problem copying file: " + fromFile + ", to: " + toFile, t);
                    return;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (is != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (Throwable throwable) {}
                    }
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
            try {
                ((InputStream)is).close();
            }
            catch (Throwable buffer2332) {
                // empty catch block
            }
        }
        if (os == null) return;
        try {
            os.close();
            return;
        }
        catch (Throwable buffer2332) {
            return;
        }
    }

    public static void copyDirectory(String fromDirectory, String toDirectory, String[] ignoreNames, boolean withError) {
        FileManager.checkFileAccessRead(fromDirectory);
        FileManager.checkFileAccessWrite(toDirectory);
        FileManager.copyDirectory(fromDirectory, toDirectory, ignoreNames, withError, null);
    }

    public static void copyDirectory(String fromDirectory, String toDirectory, String[] ignoreNames, boolean withError, IObserver observer) {
        FileManager.copyDirectoryExecute(fromDirectory, toDirectory, ignoreNames, withError, false, observer);
    }

    public static void updateDirectory(String fromDirectory, String toDirectory, String[] ignoreNames, boolean withError, IObserver observer) {
        FileManager.copyDirectoryExecute(fromDirectory, toDirectory, ignoreNames, true, withError, observer);
    }

    private static void copyDirectoryExecute(String fromDirectory, String toDirectory, String[] ignoreNames, boolean onlyIfNewer, boolean withError, IObserver observer) {
        String diff;
        FileManager.checkFileAccessRead(fromDirectory);
        FileManager.checkFileAccessWrite(toDirectory);
        String fromAbs = new File(fromDirectory).getAbsolutePath();
        String toAbs = new File(toDirectory).getAbsolutePath();
        if (observer != null) {
            observer.addMessage("Directory: " + fromAbs + " to " + toAbs);
        }
        if (fromAbs.equals(toAbs)) {
            return;
        }
        if (toAbs.contains(fromAbs) && ((diff = toAbs.replace(fromAbs, "")).contains("/") || diff.contains("\\"))) {
            if (withError) {
                throw new Error("The to-directory is a sub-directory of the from-directory. Recursive copy is not possible.");
            }
            return;
        }
        if (ignoreNames == null) {
            ignoreNames = new String[]{};
        }
        ULog.logINF("Directory: " + fromDirectory + " to directory: " + toDirectory);
        fromDirectory = fromDirectory.replace('\\', '/');
        toDirectory = toDirectory.replace('\\', '/');
        List<File> files = FileManager.getFilesOfDirectory(fromDirectory);
        for (int i = 0; i < files.size(); ++i) {
            File fromFile = files.get(i);
            if (FileManager.checkIfFileCanBeIgnored(fromFile, ignoreNames) != ENUM_IgnoreCopy.TAKE) continue;
            String toFileName = toDirectory + "/" + files.get(i).getName();
            try {
                File toFile = new File(toFileName);
                if (toFile.length() == fromFile.length() && toFile.lastModified() == fromFile.lastModified() || onlyIfNewer && toFile.lastModified() > fromFile.lastModified()) {
                    continue;
                }
            }
            catch (Throwable toFile) {
                // empty catch block
            }
            try {
                byte[] content = FileManager.readFile(files.get(i).getAbsolutePath(), true);
                FileManager.ensureDirectoryForFileExists(toFileName);
                FileManager.writeFile(toFileName, content, true);
                File toFile = new File(toFileName);
                toFile.setLastModified(fromFile.lastModified());
                ULog.logINF("Copied file: " + files.get(i).getAbsolutePath() + " to " + toFile.getAbsolutePath());
                if (observer == null) continue;
                observer.addMessage("Copied file: " + files.get(i).getAbsolutePath() + " to " + toFile.getAbsolutePath());
                continue;
            }
            catch (Throwable t) {
                if (withError) {
                    throw new Error(t);
                }
                ULog.logWAR("Problems occurred when copying file: " + toFileName, t);
                if (observer == null) continue;
                observer.addMessage("Problems occurred when copying file: " + toFileName);
            }
        }
        List<File> dirs = FileManager.getDirectoriesOfDirectory(fromDirectory);
        block9: for (int i = 0; i < dirs.size(); ++i) {
            File dir = dirs.get(i);
            switch (FileManager.checkIfFileCanBeIgnored(dir, ignoreNames)) {
                case IGNORE_COMPLETE: {
                    continue block9;
                }
                case TAKE: {
                    FileManager.mkdir(toDirectory + "/" + dir.getName());
                }
                default: {
                    FileManager.copyDirectoryExecute(dir.getAbsolutePath(), toDirectory + "/" + dir.getName(), ignoreNames, onlyIfNewer, withError, observer);
                }
            }
        }
    }

    private static ENUM_IgnoreCopy checkIfFileCanBeIgnored(File file, String[] ignoreNames) {
        String fromFileName;
        if (ignoreNames == null || ignoreNames.length == 0) {
            return ENUM_IgnoreCopy.TAKE;
        }
        ENUM_IgnoreCopy canBeIgnored = ENUM_IgnoreCopy.TAKE;
        boolean excludeIgnoreOccurred = true;
        for (String ignoreName : ignoreNames) {
            if (ignoreName == null) continue;
            if (ignoreName.startsWith("!")) {
                excludeIgnoreOccurred = true;
                continue;
            }
            fromFileName = null;
            fromFileName = ignoreName.indexOf(47) >= 0 ? ValueManager.encodeIntoValidFileName(file.getAbsolutePath(), false) : ValueManager.encodeIntoValidFileName(file.getName(), false);
            if (!fromFileName.contains(ignoreName)) continue;
            canBeIgnored = ENUM_IgnoreCopy.IGNORE_COMPLETE;
        }
        if (canBeIgnored == ENUM_IgnoreCopy.TAKE) {
            return canBeIgnored;
        }
        if (!excludeIgnoreOccurred) {
            return canBeIgnored;
        }
        if (file.isDirectory()) {
            return ENUM_IgnoreCopy.TAKE_PARTIAL;
        }
        for (String ignoreName : ignoreNames) {
            if (!ignoreName.startsWith("!")) continue;
            ignoreName = ignoreName.substring(1);
            fromFileName = null;
            fromFileName = ignoreName.indexOf(47) >= 0 ? ValueManager.encodeIntoValidFileName(file.getAbsolutePath(), false) : ValueManager.encodeIntoValidFileName(file.getName(), false);
            if (!fromFileName.contains(ignoreName)) continue;
            return ENUM_IgnoreCopy.TAKE;
        }
        return canBeIgnored;
    }

    public static void appendUTF8ToFile(String fileName, String text, boolean withError) {
        FileManager.checkFileAccessWrite(fileName);
        if (text == null || text.length() == 0) {
            return;
        }
        try {
            byte[] data = text.getBytes(ValueManager.CHARSET_UTF8);
            FileManager.appendToFile(fileName, data, withError);
        }
        catch (Throwable t) {
            if (withError) {
                throw new Error("Problem appending UTF8 content to: " + fileName, t);
            }
            ULog.logERR("Error when appending string to file");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FilePathCleanser(userComment="File name that is passed is checked against white list of allowed directories and is checked for not containing \"..\"-navigation.")
    public static void appendToFile(String fileName, byte[] data, boolean withError) {
        FileManager.checkFileAccessWrite(fileName);
        if (data == null || data.length == 0) {
            return;
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(ValueManager.approveFileName(fileName), true);
            fos.write(data);
        }
        catch (Exception e) {
            if (withError) {
                throw new Error("Problem appending byte content to: " + fileName, e);
            }
            ULog.logINF("Error when appending data to file: " + fileName);
        }
        finally {
            try {
                fos.close();
            }
            catch (Exception exception) {}
        }
    }

    public static FileOutputStream openFileOutputStream(String fileName, boolean withError) {
        FileManager.checkFileAccess(fileName, true);
        try {
            FileOutputStream fos = new FileOutputStream(ValueManager.approveFileName(fileName), true);
            return fos;
        }
        catch (Exception e) {
            if (withError) {
                throw new Error("Problem openeing file output stream: " + fileName, e);
            }
            return null;
        }
    }

    public static void closeFileOutputStream(FileOutputStream fos) {
        try {
            fos.close();
        }
        catch (Throwable t) {
            ULog.logINF("Error when closing file output stream");
        }
    }

    public static File getTempFileDirectory() {
        File f = null;
        try {
            f = File.createTempFile("dummy", "dummy");
            File file = f.getParentFile();
            return file;
        }
        catch (Throwable t) {
            throw new Error(t);
        }
        finally {
            try {
                FileManager.deleteFile(f.getAbsolutePath());
            }
            catch (Throwable throwable) {}
        }
    }

    public static void replaceInUTF8File(File file, List<String[]> fromTos, boolean withError) {
        try {
            String content = FileManager.readUTF8File(file.getAbsolutePath(), true);
            for (String[] fromTo : fromTos) {
                content = content.replace(fromTo[0], fromTo[1]);
            }
            FileManager.writeUTF8File(file.getAbsolutePath(), content, true);
        }
        catch (Throwable t) {
            if (withError) {
                throw new Error("Problem occurred when replacing texts in file: " + file.getAbsolutePath(), t);
            }
            return;
        }
    }

    private static enum ENUM_IgnoreCopy {
        IGNORE_COMPLETE,
        TAKE_PARTIAL,
        TAKE;

    }
}

