/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.log;

import java.util.Date;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import org.eclnt.util.log.CLogConstants;
import org.eclnt.util.log.CLogFormatter;
import org.eclnt.util.log.CLogLogger;
import org.eclnt.util.log.ULog;

public class CLog
implements CLogConstants {
    public static CLogLogger L;
    private static long s_stamp;
    private static int s_logCounter;
    static Handler s_consoleHandler;

    public static String stamp() {
        long millis;
        if (s_stamp == -1L) {
            s_stamp = new Date().getTime();
            millis = 0L;
        } else {
            long newStamp = new Date().getTime();
            millis = newStamp - s_stamp;
            s_stamp = newStamp;
        }
        String result = "....." + millis;
        result = result.substring(result.length() - 5);
        result = "[" + result + "] - ";
        return result;
    }

    public static void updateLogLevel(Level newLevel) {
        try {
            L.log(LL_WAR, "LOGGING: the log level is changed by API");
            L.log(LL_WAR, "LOGGING: the new log level is " + newLevel.getName() + " // " + newLevel.getLocalizedName());
            L.log(LL_DBG, "LOGGING: the following stack trace does not indicate an error - but only indicates the program calling this API");
            Exception exception = new Exception("THIS IS JUST AN EXCEPTION TO IDENTIFY THE CALLER OF THE LOGLEVEL-API");
            L.log(LL_DBG, "LOGGING: THIS IS JUST AN EXCEPTION TO IDENTIFY THE CALLER OF THE LOGLEVEL-API", exception);
            L.setLevel(newLevel);
            for (Handler handler : L.getHandlers()) {
                handler.setLevel(newLevel);
            }
        }
        catch (Throwable t) {
            L.log(LL_ERR, "problem when updating log level", t);
        }
    }

    public static void addConsoleHandler() {
        try {
            if (s_consoleHandler == null || !CLog.checkIfConsleHandlerIsContained()) {
                if (s_consoleHandler == null) {
                    s_consoleHandler = new StdOutConsoleHandler();
                }
                s_consoleHandler.setFormatter(new CLogFormatter());
                if (L.getLevel() != null) {
                    s_consoleHandler.setLevel(L.getLevel());
                }
                L.addHandler(s_consoleHandler);
            }
        }
        catch (Throwable t) {
            L.log(LL_WAR, "Logging to the console is not possible: " + t);
        }
    }

    private static boolean checkIfConsleHandlerIsContained() {
        if (L.getHandlers() == null) {
            return false;
        }
        for (Handler handler : L.getHandlers()) {
            if (handler != s_consoleHandler) continue;
            return true;
        }
        return false;
    }

    public static void removeConsoleHandler() {
        try {
            if (s_consoleHandler != null) {
                L.removeHandler(s_consoleHandler);
                s_consoleHandler = null;
            }
        }
        catch (Throwable t) {
            L.log(LL_WAR, "Removin of console handler is not possible: " + t);
        }
    }

    public static boolean getLogToConsole() {
        return s_consoleHandler != null;
    }

    static {
        s_stamp = -1L;
        s_logCounter = 0;
        try {
            ++s_logCounter;
            try {
                L = new CLogLogger("org.eclnt.serverlog.I" + s_logCounter, null);
                LogManager.getLogManager().addLogger(L);
            }
            catch (Throwable t) {
                System.err.println("CC ERROR: Problems when starting logger");
                t.printStackTrace();
            }
            try {
                LogManager.getLogManager().addLogger(L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                L.setUseParentHandlers(false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ULog.initializeLogger(L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        s_consoleHandler = null;
    }

    public static class StdOutConsoleHandler
    extends ConsoleHandler {
    }
}

