/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.logdt;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.log.CLog;
import org.eclnt.util.logdt.DTLogUtil;
import org.eclnt.util.logdt.ENUMLogCategory;
import org.eclnt.util.logdt.IDTLog;
import org.eclnt.util.logdt.IDTLogConstants;
import org.eclnt.util.valuemgmt.ValueManager;

public class DTLog
implements IDTLog,
IDTLogConstants {
    List<String> m_buffer = new ArrayList<String>();

    @Override
    public synchronized void log(ENUMLogCategory logCategory, String expression, String detail, Throwable t) {
        try {
            if (logCategory == null) {
                throw new Error("logCategory must not be null");
            }
            Date now = new Date();
            String ds = DTLogUtil.convertToDateStringMessage(now);
            String requestId = "";
            try {
                requestId = HttpSessionAccess.getCurrentRequestId();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (expression == null) {
                expression = "";
            }
            if (detail == null) {
                detail = t == null ? "" : t.toString();
            }
            String sts = "";
            if (t != null) {
                sts = ValueManager.getStackstraceString(t);
            }
            String csv = ValueManager.encodeCSVOneLine(new String[]{"1", ds, requestId, logCategory.getAbbreviation(), expression, detail, sts});
            this.m_buffer.add(csv);
        }
        catch (Throwable ttt) {
            CLog.L.log(CLog.LL_INF, "Could not process design time log", ttt);
        }
    }

    @Override
    public void requestStarted() {
        try {
            this.writeBuffer();
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Could not process design time log", t);
        }
    }

    @Override
    public void requestEnded() {
        try {
            this.log(ENUMLogCategory.REQUESTPROCESSED, null, null, null);
            this.writeBuffer();
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Could not process design time log", t);
        }
    }

    private synchronized void writeBuffer() {
        if (this.m_buffer.size() != 0) {
            StringBuffer sb = new StringBuffer();
            for (String s : this.m_buffer) {
                sb.append(s + "\r\n");
            }
            String fileName = HttpSessionAccess.getServletTempDirectory() + "/" + "log_devlog" + "/" + "log_devlog" + "." + "txt";
            fileName = ValueManager.encodeIntoValidFileName(fileName, false);
            FileManager.ensureDirectoryForFileExists(fileName);
            FileManager.appendUTF8ToFile(fileName, sb.toString(), true);
            this.splitFileIfRequired(fileName);
            this.m_buffer.clear();
        }
    }

    private void cleanUpFilesIfRequired(String fileName) {
        int index = fileName.lastIndexOf("/");
        String dirName = fileName.substring(0, index);
        String fileLastNameNoExtension = fileName.substring(index + 1, fileName.length() - 3);
        List<File> fs = FileManager.getFilesOfDirectory(dirName);
        for (int i = fs.size() - 1; i >= 0; --i) {
            File f = fs.get(i);
            if (f.getName().startsWith(fileLastNameNoExtension)) continue;
            fs.remove(i);
        }
        if (fs.size() > 10) {
            Collections.sort(fs, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    long s1 = o1.lastModified();
                    long s2 = o2.lastModified();
                    return (int)(s1 - s2);
                }
            });
            int maxi = fs.size() - 10;
            for (int i = 0; i < maxi; ++i) {
                FileManager.deleteFile(fs.get(i).getAbsolutePath());
            }
        }
    }

    private void splitFileIfRequired(String fileName) {
        File f = new File(fileName);
        if (f.length() > 500000L) {
            String ds = DTLogUtil.convertToDateStringFile(new Date());
            String newFileName = fileName.substring(0, fileName.length() - 3) + ds + ".txt";
            boolean success = f.renameTo(new File(newFileName));
            if (success) {
                FileManager.writeUTF8File(fileName, "", true);
            } else {
                CLog.L.log(CLog.LL_WAR, "Could not rename to: " + newFileName);
            }
            this.cleanUpFilesIfRequired(fileName);
        }
    }
}

