/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.valuemgmt;

import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public class Scale {
    static boolean s_initialized = false;
    static boolean s_sizeRecalculate = true;
    static float s_sizeFactor = 1.0f;
    static boolean s_fontRecalculate = true;
    static float s_fontFactor = 1.0f;

    public static void setSizeFactor(float value) {
        s_sizeFactor = value;
        s_sizeRecalculate = value != 1.0f;
    }

    public static void setFontFactor(float value) {
        s_fontFactor = value;
        s_fontRecalculate = value != 1.0f;
    }

    public static void initializeLoolAndFeel() {
        HashSet alreadyUpdates = new HashSet();
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Font newValue;
            Font fontValue;
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (value instanceof FontUIResource) {
                fontValue = (Font)value;
                newValue = Scale.calculateScaledFont(fontValue);
                UIManager.put(key, newValue);
            }
            if (!(value instanceof Font)) continue;
            fontValue = (Font)value;
            newValue = Scale.calculateScaledFont(fontValue);
            UIManager.put(key, newValue);
        }
    }

    public static int calculateScaledSize(int size) {
        if (!s_sizeRecalculate) {
            return size;
        }
        if (size <= 0) {
            return size;
        }
        return Math.round(s_sizeFactor * (float)size);
    }

    public static int calculateSize(int pixelSize) {
        if (!s_sizeRecalculate) {
            return pixelSize;
        }
        return Math.round((float)pixelSize / s_sizeFactor);
    }

    public static Font calculateScaledFont(Font font) {
        if (font == null) {
            return null;
        }
        if (!s_fontRecalculate) {
            return font;
        }
        int size = font.getSize();
        int newSize = Math.round((float)size * s_fontFactor);
        HashMap<TextAttribute, Integer> fontMap = new HashMap<TextAttribute, Integer>();
        fontMap.put(TextAttribute.SIZE, new Integer(newSize));
        return font.deriveFont(fontMap);
    }

    public static float getSizeFactor() {
        return s_sizeFactor;
    }
}

