/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.workplace;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.event.ActionEvent;
import org.eclnt.editor.annotations.CCGenClass;
import org.eclnt.jsfserver.configuration.CCConfigurationObjectLoader;
import org.eclnt.jsfserver.elements.events.BaseActionEventFlush;
import org.eclnt.jsfserver.elements.events.BaseActionEventSelect;
import org.eclnt.jsfserver.elements.impl.FIXGRIDItem;
import org.eclnt.jsfserver.elements.impl.FIXGRIDListBinding;
import org.eclnt.jsfserver.elements.impl.FIXGRIDTreeItem;
import org.eclnt.jsfserver.i18n.I18N;
import org.eclnt.jsfserver.util.StyleManager;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;
import org.eclnt.workplace.IWorkpageDispatcher;
import org.eclnt.workplace.IWorkplaceFunctionSearchExtension;
import org.eclnt.workplace.WorkpageDispatchedPageBean;
import org.eclnt.workplace.WorkpageStartInfo;
import org.eclnt.workplace.WorkpageStarterFactory;
import org.eclnt.workplace.WorkplaceFunctionTree;
import org.eclnt.workplace.WorkplaceFunctionsManager;
import org.eclnt.workplace.WorkplaceUtil;

@CCGenClass(expressionBase="#{wp.WPFunctionSearch}")
public class WorkplaceFunctionSearchUI
extends WorkpageDispatchedPageBean
implements Serializable {
    protected String m_searchText;
    protected FIXGRIDListBinding<GridItem> m_grid = new FIXGRIDListBinding();
    protected boolean m_singleClickExecute = false;
    protected String m_lastSearchText = "inittini";
    String m_rowHeight = "40";
    boolean m_renderSecondLine = true;
    boolean m_renderStart = true;
    String m_searchFieldTooltip = I18N.getString("WP_functionSearchField");
    String m_searchFieldRequestFocusHotKey = "ctrl-shift-83";
    String m_searchFieldRequestFocus = "creation";

    public WorkplaceFunctionSearchUI(IWorkpageDispatcher workpageDispatcher) {
        super(workpageDispatcher);
    }

    @Override
    public String getPageName() {
        return "/eclntjsfserver/includes/wp_functionsearch.jsp";
    }

    @Override
    public String getRootExpressionUsedInPage() {
        return "#{WorkplaceFunctionSearch}";
    }

    public String getSearchFieldRequestFocus() {
        return this.m_searchFieldRequestFocus;
    }

    public void setSearchFieldRequestFocus(String searchFieldRequestFocus) {
        this.m_searchFieldRequestFocus = searchFieldRequestFocus;
    }

    public String getSearchFieldTooltip() {
        return this.m_searchFieldTooltip;
    }

    public void setSearchFieldTooltip(String searchFieldTooltip) {
        this.m_searchFieldTooltip = searchFieldTooltip;
    }

    public String getSearchFieldRequestFocusHotKey() {
        return this.m_searchFieldRequestFocusHotKey;
    }

    public void setSearchFieldRequestFocusHotKey(String searchFieldRequestFocusHotKey) {
        this.m_searchFieldRequestFocusHotKey = searchFieldRequestFocusHotKey;
    }

    public FIXGRIDListBinding<GridItem> getGrid() {
        return this.m_grid;
    }

    public String getSearchText() {
        return this.m_searchText;
    }

    public void setSearchText(String value) {
        this.m_searchText = value;
    }

    public boolean getSingleClickExecute() {
        return this.m_singleClickExecute;
    }

    public void setSingleClickExecute(boolean singleClickExecute) {
        this.m_singleClickExecute = singleClickExecute;
    }

    public boolean getRenderStart() {
        return this.m_renderStart;
    }

    public void setRenderStart(boolean renderStart) {
        this.m_renderStart = renderStart;
    }

    public boolean getEnabledStart() {
        return this.m_grid.getSelectedItem() != null;
    }

    public void onStartAction(ActionEvent event) {
        if (this.m_grid.getItems().size() == 1) {
            this.m_grid.getItems().get(0).onRowExecute();
        } else {
            GridItem gi = (GridItem)this.m_grid.getSelectedItem();
            if (gi != null) {
                gi.onRowExecute();
            }
        }
    }

    public String getRowHeight() {
        return this.m_rowHeight;
    }

    public void setRowHeight(String rowHeight) {
        this.m_rowHeight = rowHeight;
    }

    public boolean getRenderSecondLine() {
        return this.m_renderSecondLine;
    }

    public void setRenderSecondLine(boolean renderSecondLine) {
        this.m_renderSecondLine = renderSecondLine;
    }

    public void onSearchAction(ActionEvent event) {
        if (event instanceof BaseActionEventFlush) {
            this.executeSearch();
        } else if (event instanceof BaseActionEventSelect) {
            try {
                GridItem selectedItem = (GridItem)this.m_grid.getSelectedItem();
                if (selectedItem != null) {
                    this.startItem(selectedItem);
                }
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_ERR, "Error when searching for functions in workplace functions manager");
            }
        }
    }

    public void executeSearch() {
        try {
            if (!ValueManager.checkIfStringsAreEqual(this.m_lastSearchText, this.m_searchText) || this.m_grid.getItems().size() == 0) {
                this.m_lastSearchText = this.m_searchText;
                List<Hit> hits = this.search(this.m_searchText);
                this.transferHitsIntoGrid(hits);
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Error when searching for functions in workplace functions manager");
        }
    }

    private List<Hit> search(String searchText) {
        if (SystemXml.getWorkplaceFunctionSearchExtension() == null) {
            List<Hit> functionTreeHits = this.searchInFunctionTrees(searchText, false);
            return functionTreeHits;
        }
        List<Hit> functionTreeHits = this.searchInFunctionTrees(searchText, true);
        return this.searchViaExtension(searchText, functionTreeHits);
    }

    private List<Hit> searchViaExtension(String searchText, List<Hit> functionTreeHits) {
        try {
            IWorkplaceFunctionSearchExtension ext = (IWorkplaceFunctionSearchExtension)CCConfigurationObjectLoader.instance().loadInstance(SystemXml.getWorkplaceFunctionSearchExtension(), true);
            return ext.searchWorkplaceFunctions(searchText, functionTreeHits);
        }
        catch (Throwable t) {
            throw new Error("Problem occurred when searching items via extension. Class name: " + SystemXml.getWorkplaceFunctionSearchExtension(), t);
        }
    }

    private List<Hit> searchInFunctionTrees(String searchText, boolean onlySearchForFirstToken) {
        if (searchText != null) {
            searchText = searchText.trim();
        }
        if (onlySearchForFirstToken && searchText != null && searchText.contains(" ")) {
            int index = searchText.indexOf(32);
            searchText = searchText.substring(0, index);
        }
        WorkplaceFunctionsManager wfm = ((IWorkpageDispatcher)this.getOwningDispatcher().getTopOwner()).getWorkpageContainer().getFunctionsManager();
        List<WorkplaceFunctionsManager.FunctionTree> functionTrees = wfm.getTrees();
        ArrayList<Hit> hits = new ArrayList<Hit>();
        for (WorkplaceFunctionsManager.FunctionTree tree : functionTrees) {
            this.addHits(tree, hits);
        }
        return hits;
    }

    private void transferHitsIntoGrid(List<Hit> hits) {
        this.m_grid.getItems().clear();
        this.sortCodeHitsToTop(hits);
        for (Hit hit : hits) {
            GridItem gi = new GridItem(hit.getHierarchyText(), hit.getWpsi(), hit.i_hitByCode);
            this.m_grid.getItems().add(gi);
        }
        this.selectFirstItem();
    }

    private void selectFirstItem() {
        if (this.m_grid.getItems().size() == 0) {
            return;
        }
        if (this.m_grid.getItems().size() == 1 || this.m_grid.getItems().get((int)0).i_hitByCode) {
            this.m_grid.selectItem(0);
        }
    }

    private void sortCodeHitsToTop(List<Hit> hits) {
        boolean didExchange;
        do {
            didExchange = false;
            for (int i = 0; i < hits.size() - 1; ++i) {
                Hit h1 = hits.get(i);
                Hit h2 = hits.get(i + 1);
                if (!h2.i_hitByCode || h1.i_hitByCode) continue;
                hits.set(i, h2);
                hits.set(i + 1, h1);
                didExchange = true;
            }
        } while (didExchange);
    }

    private void addHits(WorkplaceFunctionsManager.FunctionTree tree, List<Hit> hits) {
        List<FIXGRIDTreeItem> ftis = tree.getFtree().getRootNode().getChildNodes();
        for (FIXGRIDTreeItem fti : ftis) {
            String rootText = "";
            try {
                rootText = tree.getRootNode().getText();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.addHits((WorkplaceFunctionTree.FunctionNode)fti, hits, rootText, false);
        }
    }

    private void addHits(WorkplaceFunctionTree.FunctionNode node, List<Hit> hits, String hierarchyText, boolean isHit) {
        String nodeText = node.getText();
        boolean isHitByCode = false;
        if (ValueManager.checkIfStringContainsTokenizedSearchString(nodeText, this.m_searchText)) {
            isHit = true;
        }
        if (!isHit && node.getWorkpageStartInfo() != null) {
            String comment;
            String code = node.getWorkpageStartInfo().getCode();
            if (code != null && ValueManager.toLowerCaseText(code).equals(ValueManager.toLowerCaseText(this.m_searchText))) {
                isHit = true;
                isHitByCode = true;
            }
            if ((comment = node.getWorkpageStartInfo().getComment()) != null && ValueManager.checkIfStringContainsTokenizedSearchString(nodeText + comment, this.m_searchText)) {
                isHit = true;
            }
        }
        if (isHit && node.getStatusInt() == 2) {
            Hit hit = new Hit();
            hit.setHierarchyText(hierarchyText);
            hit.setWpsi(node.getWorkpageStartInfo());
            hit.setHitByCode(isHitByCode);
            hits.add(hit);
            return;
        }
        List<FIXGRIDTreeItem> subNodes = node.getChildNodes();
        for (FIXGRIDTreeItem subNode : subNodes) {
            String newHierarchyText = hierarchyText;
            if (newHierarchyText.length() > 0) {
                newHierarchyText = newHierarchyText + " > ";
            }
            newHierarchyText = newHierarchyText + nodeText;
            this.addHits((WorkplaceFunctionTree.FunctionNode)subNode, hits, newHierarchyText, isHit);
        }
    }

    private void startItem(GridItem gridItem) {
        WorkpageStarterFactory.getWorkpageStarter().startWorkpage((IWorkpageDispatcher)this.getOwningDispatcher().getTopOwner(), this.getWorkpageContainer(), gridItem.i_wpsi);
    }

    public class GridItem
    extends FIXGRIDItem
    implements Serializable {
        String i_hierarchyText;
        WorkpageStartInfo i_wpsi;
        boolean i_hitByCode = false;
        String i_dragSend = null;

        public GridItem(String hierarchyText, WorkpageStartInfo wpsi, boolean hitByCode) {
            this.i_hierarchyText = hierarchyText;
            this.i_wpsi = wpsi;
            this.i_hitByCode = hitByCode;
            this.i_dragSend = WorkplaceUtil.encodePageInfo(this.i_wpsi);
        }

        public String getHierarchyText() {
            return this.i_hierarchyText;
        }

        public String getText() {
            String result = this.i_wpsi.getText();
            if (this.i_wpsi.getCode() != null) {
                result = result + " (" + this.i_wpsi.getCode() + ")";
            }
            return result;
        }

        public String getBackground() {
            if (this.i_hitByCode) {
                return StyleManager.getStyleValue("ccWpSearchHitBackground");
            }
            return null;
        }

        @Override
        public void onRowExecute() {
            WorkplaceFunctionSearchUI.this.startItem(this);
        }

        public String getDragSend() {
            return this.i_dragSend;
        }

        public String getTooltip() {
            return this.i_wpsi.getComment();
        }
    }

    public static class Hit {
        WorkpageStartInfo i_wpsi;
        String i_hierarchyText;
        boolean i_hitByCode;

        public WorkpageStartInfo getWpsi() {
            return this.i_wpsi;
        }

        public void setWpsi(WorkpageStartInfo wpsi) {
            this.i_wpsi = wpsi;
        }

        public String getHierarchyText() {
            return this.i_hierarchyText;
        }

        public void setHierarchyText(String text) {
            this.i_hierarchyText = text;
        }

        public boolean getHitByCode() {
            return this.i_hitByCode;
        }

        public void setHitByCode(boolean hitByCode) {
            this.i_hitByCode = hitByCode;
        }
    }
}

