/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.workplace.wfinbox;

import java.io.Serializable;
import javax.faces.event.ActionEvent;
import org.eclnt.jsfserver.pagebean.PageBean;
import org.eclnt.jsfserver.util.useraccess.UserAccessMgr;
import org.eclnt.util.log.CLog;
import org.eclnt.workplace.wfinbox.WFDummyManager;
import org.eclnt.workplace.wfinbox.WFManagerFactory;
import org.eclnt.workplace.wfinbox.WorkItemDetail;
import org.eclnt.workplace.wfinbox.WorkItemTrace;

public class WFItemTraceUI
extends PageBean
implements Serializable {
    WorkItemDetail m_wid;
    protected String m_newComment;
    protected String m_traceText;
    IListener m_listener;

    public WFItemTraceUI() {
        this.m_wid = WFDummyManager.createDummyWorkItemDetail();
        this.construct();
    }

    public WFItemTraceUI(WorkItemDetail wid, IListener listener) {
        this.m_wid = wid;
        this.m_listener = listener;
        this.construct();
    }

    private void construct() {
        StringBuffer sb = new StringBuffer();
        for (WorkItemTrace trace : this.m_wid.getTraces()) {
            if (sb.length() != 0) {
                sb.append("<br><hr>");
            }
            sb.append("<font color='#A0A0A0'>User: " + trace.getUserId() + "</font><br>");
            sb.append(trace.getComment());
        }
        this.m_traceText = sb.toString();
    }

    @Override
    public String getPageName() {
        return "/eclntjsfserver/includes/wfitemtrace.jsp";
    }

    @Override
    public String getRootExpressionUsedInPage() {
        return "#{WFItemTraceUI}";
    }

    public String getNewComment() {
        return this.m_newComment;
    }

    public void setNewComment(String value) {
        this.m_newComment = value;
    }

    public String getTraceText() {
        return this.m_traceText;
    }

    public void onAddComment(ActionEvent event) {
        try {
            String userId = UserAccessMgr.getCurrentUser();
            WFManagerFactory.getInstance().addComment(this.m_wid, userId, this.m_newComment);
            if (this.m_listener != null) {
                this.m_listener.reactOnCommentAdded(this.m_newComment);
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "", t);
        }
    }

    public static interface IListener {
        public void reactOnCommentAdded(String var1);
    }
}

