/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.bufferedcontent;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.http.HttpSession;
import org.eclnt.jsfserver.bufferedcontent.IBufferedContent;
import org.eclnt.jsfserver.bufferedcontent.IBufferedStreamContent;
import org.eclnt.jsfserver.session.UsageWithoutSessionContext;
import org.eclnt.jsfserver.util.DefaultSessionAbstractionListener;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.ISessionAbstraction;
import org.eclnt.util.log.CLog;

public class BufferedContentMgr {
    private static boolean s_crossSesssion = false;
    private static Hashtable<String, Object> s_crossSessionBufferedContent = new Hashtable();

    public static void initSpecialCrossSessionUsage() {
        CLog.L.log(CLog.LL_WAR, "BufferedContentMgr special usage mode is switched on by application!");
        s_crossSesssion = true;
    }

    public boolean checkIfSpecialCrossSessionUsageIsActive() {
        return s_crossSesssion;
    }

    public static void add(IBufferedContent bufferedContent) {
        block7: {
            if (bufferedContent != null) {
                CLog.L.log(CLog.LL_INF, "BufferedContentMgr: Adding buffered content: " + bufferedContent.getId());
            } else {
                CLog.L.log(CLog.LL_INF, "BufferedContentMgr: Adding buffered content: null");
            }
            if (s_crossSesssion) {
                s_crossSessionBufferedContent.put(bufferedContent.getId(), bufferedContent);
                return;
            }
            try {
                HttpSession hs = HttpSessionAccess.getCurrentHttpSession();
                hs.setAttribute("bufferedContent_" + bufferedContent.getId(), (Object)bufferedContent);
                hs.setAttribute("addedBufferedContent_" + bufferedContent.getId(), (Object)System.currentTimeMillis());
                ISessionAbstraction dialogSession = HttpSessionAccess.getCurrentDialogSession();
                final String contentId = bufferedContent.getId();
                dialogSession.addListener(new DefaultSessionAbstractionListener(){

                    @Override
                    public void reactOnClosed() {
                        BufferedContentMgr.removeById(contentId);
                    }
                });
            }
            catch (Throwable t) {
                if (UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
                    return;
                }
                CLog.L.log(CLog.LL_ERR, "BufferedContentMgr: problem when adding buffered content", t);
                if (t instanceof Error) {
                    throw (Error)t;
                }
                if (!(t instanceof RuntimeException)) break block7;
                throw (RuntimeException)t;
            }
        }
    }

    public static void add(IBufferedStreamContent bufferedStreamContent) {
        block7: {
            if (bufferedStreamContent != null) {
                CLog.L.log(CLog.LL_INF, "BufferedContentMgr: Adding buffered content: " + bufferedStreamContent.getId());
            } else {
                CLog.L.log(CLog.LL_INF, "BufferedContentMgr: Adding buffered content: null");
            }
            if (s_crossSesssion) {
                s_crossSessionBufferedContent.put(bufferedStreamContent.getId(), bufferedStreamContent);
                return;
            }
            try {
                HttpSession hs = HttpSessionAccess.getCurrentHttpSession();
                hs.setAttribute("bufferedContent_" + bufferedStreamContent.getId(), (Object)bufferedStreamContent);
                hs.setAttribute("addedBufferedContent_" + bufferedStreamContent.getId(), (Object)System.currentTimeMillis());
                ISessionAbstraction dialogSession = HttpSessionAccess.getCurrentDialogSession();
                final String contentId = bufferedStreamContent.getId();
                dialogSession.addListener(new DefaultSessionAbstractionListener(){

                    @Override
                    public void reactOnClosed() {
                        BufferedContentMgr.removeById(contentId);
                    }
                });
            }
            catch (Throwable t) {
                if (UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
                    return;
                }
                CLog.L.log(CLog.LL_INF, "BufferedContentMgr: problem when adding buffered content", t);
                if (t instanceof Error) {
                    throw (Error)t;
                }
                if (!(t instanceof RuntimeException)) break block7;
                throw (RuntimeException)t;
            }
        }
    }

    public static Object readBufferedContent(HttpSession session, String id) {
        if (s_crossSesssion) {
            return s_crossSessionBufferedContent.get(id);
        }
        try {
            if (session == null) {
                CLog.L.log(CLog.LL_INF, "Session that was passed for looking up buffered content is null, returning null as buffered content as consequence");
                return null;
            }
            String bufferId = "bufferedContent_" + id;
            Object bufferedObject = session.getAttribute(bufferId);
            return bufferedObject;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Could not find buffered content for id: " + id, t);
            return null;
        }
    }

    public static void remove(IBufferedContent[] bufferedContents) {
        if (bufferedContents == null) {
            return;
        }
        if (s_crossSesssion) {
            for (IBufferedContent bc : bufferedContents) {
                if (bc == null) continue;
                s_crossSessionBufferedContent.remove(bc.getId());
            }
            return;
        }
        try {
            for (IBufferedContent bc : bufferedContents) {
                if (bc == null) continue;
                BufferedContentMgr.removeById(bc.getId());
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Info when removing bufferedContent: " + t.toString());
        }
    }

    public static void remove(IBufferedContent bufferedContent) {
        if (bufferedContent == null) {
            CLog.L.log(CLog.LL_INF, "BufferedContentMgr: Removing buffered content: null was passed");
            return;
        }
        CLog.L.log(CLog.LL_INF, "BufferedContentMgr: Removing buffered content: " + bufferedContent.getId());
        if (s_crossSesssion) {
            s_crossSessionBufferedContent.remove(bufferedContent.getId());
            return;
        }
        BufferedContentMgr.removeById(bufferedContent.getId());
    }

    public static void remove(IBufferedStreamContent bufferedStreamContent) {
        if (bufferedStreamContent == null) {
            CLog.L.log(CLog.LL_INF, "BufferedContentMgr: Removing buffered stream content: null was passed");
            return;
        }
        if (s_crossSesssion) {
            s_crossSessionBufferedContent.remove(bufferedStreamContent.getId());
            return;
        }
        BufferedContentMgr.removeById(bufferedStreamContent.getId());
    }

    private static void removeById(String contentId) {
        try {
            HttpSession hs = HttpSessionAccess.getCurrentHttpSession();
            if (hs == null) {
                return;
            }
            hs.removeAttribute("bufferedContent_" + contentId);
            hs.removeAttribute("addedBufferedContent_" + contentId);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Info when removing bufferedStreamContent: " + t.toString());
        }
    }

    public static void removeAllContentOlderThan(long duration) {
        try {
            long now = System.currentTimeMillis();
            CLog.L.log(CLog.LL_INF, "Removing all content older than " + duration);
            if (s_crossSesssion) {
                CLog.L.log(CLog.LL_INF, "Cross session usage is set => no removing");
                return;
            }
            HttpSession hs = HttpSessionAccess.getCurrentHttpSession();
            Enumeration en = hs.getAttributeNames();
            ArrayList ans = new ArrayList();
            while (en.hasMoreElements()) {
                ans.add(en.nextElement());
            }
            for (String an : ans) {
                try {
                    if (!an.startsWith("bufferedContent_")) continue;
                    CLog.L.log(CLog.LL_INF, "Found buffered content " + an);
                    String anAdded = an.replace("bufferedContent_", "addedBufferedContent_");
                    Long l = (Long)hs.getAttribute(anAdded);
                    if (l == null || now - l <= duration) continue;
                    hs.removeAttribute(an);
                    hs.removeAttribute(anAdded);
                }
                catch (Throwable t) {
                    CLog.L.log(CLog.LL_INF, "Problem when removing content " + an, t);
                }
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem when removing all content older than " + duration, t);
        }
    }
}

