/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements;

import java.io.Serializable;
import javax.faces.component.UIComponent;
import javax.faces.event.ActionEvent;
import org.eclnt.jsfserver.elements.BaseComponent;
import org.eclnt.jsfserver.elements.BaseComponentTag;
import org.eclnt.jsfserver.elements.IBaseActionEvent;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;

public class BaseActionEvent
extends ActionEvent
implements IBaseActionEvent,
Serializable {
    boolean m_prior = false;
    boolean m_immediate = false;
    String m_type;
    String m_command;
    String[] m_params;
    Object m_internalReference;
    boolean m_onlyCallIfObjectIsAvailable = false;

    public BaseActionEvent(UIComponent component, String type) {
        super(component);
        this.m_type = type;
        int index = this.m_type.indexOf(40);
        this.m_command = this.m_type.substring(0, index);
        this.m_params = ValueManager.decodeMethodParams(this.m_type);
    }

    public String getCommand() {
        return this.m_command;
    }

    public String[] getParams() {
        return this.m_params;
    }

    public String getParam(int index) {
        try {
            return this.m_params[index];
        }
        catch (Throwable t) {
            return null;
        }
    }

    public String getEventInfo() {
        return this.m_type;
    }

    public void setInternalReference(Object o) {
        this.m_internalReference = o;
    }

    public Object getInternalReference() {
        return this.m_internalReference;
    }

    public String getSourceReference() {
        try {
            BaseComponent bc = (BaseComponent)this.getSource();
            return bc.getAttributeValueAsString(BaseComponentTag.ATT_REFERENCE);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem when accessing the source reference", t);
            return null;
        }
    }

    public String getSourceComment() {
        try {
            BaseComponent bc = (BaseComponent)this.getSource();
            return bc.getAttributeValueAsString(BaseComponentTag.ATT_COMMENT);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem when accessing the source reference", t);
            return null;
        }
    }

    public String getSourceConfiginfo() {
        try {
            BaseComponent bc = (BaseComponent)this.getSource();
            return bc.getAttributeValueAsString(BaseComponentTag.ATT_configinfo);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem when accessing the source config info", t);
            return null;
        }
    }

    public void setImmediate(boolean immediate) {
        this.m_immediate = immediate;
    }

    public boolean isImmediate() {
        return this.m_immediate;
    }

    public boolean getOnlyCallIfObjectIsAvailable() {
        return this.m_onlyCallIfObjectIsAvailable;
    }

    public void setOnlyCallIfObjectIsAvailable(boolean onlyCallIfObjectIsAvailable) {
        this.m_onlyCallIfObjectIsAvailable = onlyCallIfObjectIsAvailable;
    }

    protected String readParam(int index) {
        if (this.m_params == null) {
            return null;
        }
        if (index >= this.m_params.length) {
            return null;
        }
        return this.m_params[index];
    }

    protected void setPrior(boolean prior) {
        this.m_prior = prior;
    }

    public boolean isPrior() {
        return this.m_prior;
    }
}

