/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements;

import java.io.IOException;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.eclnt.jsfserver.defaultscreens.BasePopup;
import org.eclnt.jsfserver.elements.BaseActionComponent;
import org.eclnt.jsfserver.elements.impl.IPageIncluder;
import org.eclnt.jsfserver.util.ExpressionManagerV;
import org.eclnt.util.valuemgmt.ValueManager;

public class BasePopupComponent
extends BaseActionComponent
implements IPageIncluder {
    int m_modLeft = -1;
    int m_modTop = -1;
    int m_modWidth = -1;
    int m_modHeight = -1;
    int m_modWindowstate = 0;
    boolean m_firstEncode = true;

    @Override
    public Object saveState(FacesContext context) {
        return new Object[]{super.saveState(context), this.m_firstEncode};
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.m_firstEncode = (Boolean)values[1];
    }

    public BasePopupComponent() {
        this.setRendersChildren(true);
    }

    @Override
    public boolean checkIfRowIsExpected() {
        return true;
    }

    @Override
    public void encodeBegin(FacesContext context) throws IOException {
        if (this.m_firstEncode) {
            this.m_firstEncode = false;
            BasePopup popup = this.findBasePopup(context);
            if (popup != null) {
                popup.loadPersistedPosition();
            }
        }
        super.encodeBegin(context);
    }

    @Override
    public void encodeEnd(FacesContext context) throws IOException {
        super.encodeEnd(context);
    }

    @Override
    public void encodeChildren(FacesContext context) throws IOException {
        super.encodeChildren(context);
    }

    @Override
    public void decode(FacesContext context) {
        String clientId = this.getClientId(context);
        Map rpm = context.getExternalContext().getRequestParameterMap();
        this.m_modWidth = ValueManager.decodeIntWithRounding((String)rpm.get(clientId + ".width"), -1);
        if (this.m_modWidth >= 0) {
            this.m_modLeft = ValueManager.decodeIntWithRounding((String)rpm.get(clientId + ".left"), -1);
            this.m_modTop = ValueManager.decodeIntWithRounding((String)rpm.get(clientId + ".top"), -1);
            this.m_modHeight = ValueManager.decodeIntWithRounding((String)rpm.get(clientId + ".height"), -1);
            this.m_modWindowstate = ValueManager.decodeIntWithRounding((String)rpm.get(clientId + ".windowstate"), -1);
            this.updateAttributeValue(context, "left", this.m_modLeft + "", Integer.TYPE, true, false);
            this.updateAttributeValue(context, "top", this.m_modTop + "", Integer.TYPE, true, false);
            this.updateAttributeValue(context, "width", this.m_modWidth + "", Integer.TYPE, true, false);
            this.updateAttributeValue(context, "height", this.m_modHeight + "", Integer.TYPE, true, false);
            this.updateAttributeValue(context, "windowstate", this.m_modWindowstate + "", Integer.TYPE, true, false);
            this.updateAttributeValue(context, "lefttopreference", null, String.class, true, false);
        }
        super.decode(context);
    }

    @Override
    public void processUpdates(FacesContext context) {
        super.processUpdates(context);
        BasePopup popup = this.findBasePopup(context);
        if (popup != null) {
            popup.persistPosition();
        }
    }

    private BasePopup findBasePopup(FacesContext context) {
        try {
            String s = this.getAttributeString("left");
            int index = s.lastIndexOf(46);
            s = s.substring(0, index) + "}";
            BasePopup popup = (BasePopup)ExpressionManagerV.getValueForExpressionString(context, s);
            return popup;
        }
        catch (Throwable t) {
            return null;
        }
    }
}

