/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements;

import java.util.HashSet;
import java.util.Set;
import org.eclnt.jsfserver.elements.BaseActionEvent;
import org.eclnt.jsfserver.elements.BaseComponent;
import org.eclnt.jsfserver.elements.ICCComponentProperties;
import org.eclnt.jsfserver.elements.IEventBlockerDuringDecode;
import org.eclnt.jsfserver.elements.events.BaseActionEventCameraSnap;
import org.eclnt.jsfserver.elements.events.BaseActionEventFlush;
import org.eclnt.jsfserver.elements.events.BaseActionEventGeoLocationUpdate;
import org.eclnt.jsfserver.elements.events.BaseActionEventInvoke;
import org.eclnt.jsfserver.elements.events.BaseActionEventMultiScan;
import org.eclnt.jsfserver.elements.events.BaseActionEventQRCodeScan;
import org.eclnt.jsfserver.elements.events.BaseActionEventScan;
import org.eclnt.jsfserver.elements.events.BaseActionEventSelect;
import org.eclnt.jsfserver.elements.events.BaseActionEventUpload;
import org.eclnt.jsfserver.elements.impl.AVATARICONComponent;
import org.eclnt.jsfserver.elements.impl.AWESOMEFONTICONComponent;
import org.eclnt.jsfserver.elements.impl.BUTTONComponent;
import org.eclnt.jsfserver.elements.impl.BUTTONMENUComponent;
import org.eclnt.jsfserver.elements.impl.BUTTONPOPUPComponent;
import org.eclnt.jsfserver.elements.impl.BUTTONVERTICALComponent;
import org.eclnt.jsfserver.elements.impl.CAMERAComponent;
import org.eclnt.jsfserver.elements.impl.FILEUPLOADBUTTONComponent;
import org.eclnt.jsfserver.elements.impl.FILEUPLOADComponent;
import org.eclnt.jsfserver.elements.impl.FILEUPLOADLINKComponent;
import org.eclnt.jsfserver.elements.impl.FONTICONComponent;
import org.eclnt.jsfserver.elements.impl.GEOLOCATIONComponent;
import org.eclnt.jsfserver.elements.impl.ICONComponent;
import org.eclnt.jsfserver.elements.impl.KEYBOARDSCANNERComponent;
import org.eclnt.jsfserver.elements.impl.KEYBOARDSCANNERMULTISCANComponent;
import org.eclnt.jsfserver.elements.impl.LINKComponent;
import org.eclnt.jsfserver.elements.impl.LINKVERTICALComponent;
import org.eclnt.jsfserver.elements.impl.LISTComponent;
import org.eclnt.jsfserver.elements.impl.MENUITEMComponent;
import org.eclnt.jsfserver.elements.impl.SCANFIELDComponent;
import org.eclnt.jsfserver.elements.impl.TABBEDLINETABComponent;
import org.eclnt.jsfserver.elements.impl.TABBEDLINEVERTICALTABComponent;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.util.classresolver.CCClassResolver;
import org.eclnt.util.classresolver.ENUMCallerType;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;

public class DefaultEventBlockerDuringDecode
implements IEventBlockerDuringDecode {
    protected Set<Class> m_componentClassesWithEventEnabledCheck = new HashSet<Class>();
    protected Set<Class> m_eventClassesWithEventEnabledCheck = new HashSet<Class>();

    public DefaultEventBlockerDuringDecode() {
        this.initialize();
    }

    public void initialize() {
        this.initializeComponentClassesWithEventEnabledCheck();
        this.initializeComponentClassesWithEventEnabledCheckBySystemXml();
        this.initializeEventClassesWithEventEnabledCheck();
        this.initializeEventClassesWithEventEnabledCheckBySystemXml();
    }

    @Override
    public boolean checkIfEventIsBlocked(BaseActionEvent event, BaseComponent component) {
        if (event == null || component == null) {
            return false;
        }
        boolean blocked = false;
        blocked = this.checkIfEventIsBlockedFlush(event, component);
        if (!blocked) {
            blocked = this.checkIfEventIsBlockedAction(event, component);
        }
        if (blocked) {
            this.performEventBlockedActivity(event, component);
        }
        return blocked;
    }

    @Override
    public boolean checkIfPassingValueIsBlocked(BaseComponent component, BaseComponent.DecodePassData decodeInfo, String value) {
        boolean enabled;
        if (decodeInfo.getIdSuffix() != null && decodeInfo.getIdSuffix().length() == 0 && !(enabled = this.findEnabledValueForComponent(component))) {
            this.performPassingValueBlockedActivity(component, decodeInfo, value);
            return true;
        }
        return false;
    }

    protected boolean checkIfEventIsBlockedAction(BaseActionEvent event, BaseComponent component) {
        boolean enabled;
        return this.m_componentClassesWithEventEnabledCheck.contains(component.getClass()) && this.m_eventClassesWithEventEnabledCheck.contains(event.getClass()) && !(enabled = this.findEnabledValueForComponent(component));
    }

    protected boolean checkIfEventIsBlockedFlush(BaseActionEvent event, BaseComponent component) {
        boolean enabled;
        return event instanceof BaseActionEventFlush && !(enabled = this.findEnabledValueForComponent(component));
    }

    protected void initializeEventClassesWithEventEnabledCheckBySystemXml() {
        Set<String> classNames = SystemXml.getEventClassesWithEventEnabledCheck();
        for (String className : classNames) {
            try {
                Class clazz = CCClassResolver.resolveClass(className, ENUMCallerType.COMPONENT);
                this.m_eventClassesWithEventEnabledCheck.add(clazz);
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_WAR, "Problem when adding event class with event enabled check: " + className, t);
            }
        }
    }

    protected void initializeComponentClassesWithEventEnabledCheckBySystemXml() {
        Set<String> classNames = SystemXml.getComponentClassesWithEventEnabledCheck();
        for (String className : classNames) {
            try {
                Class clazz = CCClassResolver.resolveClass(className, ENUMCallerType.COMPONENT);
                this.m_componentClassesWithEventEnabledCheck.add(clazz);
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_WAR, "Problem when adding component class with event enabled check: " + className, t);
            }
        }
    }

    protected void initializeEventClassesWithEventEnabledCheck() {
        this.m_eventClassesWithEventEnabledCheck.add(BaseActionEventCameraSnap.class);
        this.m_eventClassesWithEventEnabledCheck.add(BaseActionEventGeoLocationUpdate.class);
        this.m_eventClassesWithEventEnabledCheck.add(BaseActionEventInvoke.class);
        this.m_eventClassesWithEventEnabledCheck.add(BaseActionEventMultiScan.class);
        this.m_eventClassesWithEventEnabledCheck.add(BaseActionEventQRCodeScan.class);
        this.m_eventClassesWithEventEnabledCheck.add(BaseActionEventScan.class);
        this.m_eventClassesWithEventEnabledCheck.add(BaseActionEventSelect.class);
        this.m_eventClassesWithEventEnabledCheck.add(BaseActionEventUpload.class);
    }

    protected void initializeComponentClassesWithEventEnabledCheck() {
        this.m_componentClassesWithEventEnabledCheck.add(AVATARICONComponent.class);
        this.m_componentClassesWithEventEnabledCheck.add(AWESOMEFONTICONComponent.class);
        this.m_componentClassesWithEventEnabledCheck.add(BUTTONComponent.class);
        this.m_componentClassesWithEventEnabledCheck.add(BUTTONMENUComponent.class);
        this.m_componentClassesWithEventEnabledCheck.add(BUTTONPOPUPComponent.class);
        this.m_componentClassesWithEventEnabledCheck.add(BUTTONVERTICALComponent.class);
        this.m_componentClassesWithEventEnabledCheck.add(CAMERAComponent.class);
        this.m_componentClassesWithEventEnabledCheck.add(FILEUPLOADComponent.class);
        this.m_componentClassesWithEventEnabledCheck.add(FILEUPLOADBUTTONComponent.class);
        this.m_componentClassesWithEventEnabledCheck.add(FILEUPLOADLINKComponent.class);
        this.m_componentClassesWithEventEnabledCheck.add(FONTICONComponent.class);
        this.m_componentClassesWithEventEnabledCheck.add(GEOLOCATIONComponent.class);
        this.m_componentClassesWithEventEnabledCheck.add(ICONComponent.class);
        this.m_componentClassesWithEventEnabledCheck.add(KEYBOARDSCANNERComponent.class);
        this.m_componentClassesWithEventEnabledCheck.add(KEYBOARDSCANNERMULTISCANComponent.class);
        this.m_componentClassesWithEventEnabledCheck.add(LINKComponent.class);
        this.m_componentClassesWithEventEnabledCheck.add(LINKVERTICALComponent.class);
        this.m_componentClassesWithEventEnabledCheck.add(LISTComponent.class);
        this.m_componentClassesWithEventEnabledCheck.add(MENUITEMComponent.class);
        this.m_componentClassesWithEventEnabledCheck.add(SCANFIELDComponent.class);
        this.m_componentClassesWithEventEnabledCheck.add(TABBEDLINETABComponent.class);
        this.m_componentClassesWithEventEnabledCheck.add(TABBEDLINEVERTICALTABComponent.class);
    }

    protected void performEventBlockedActivity(BaseActionEvent event, BaseComponent component) {
        CLog.L.log(CLog.LL_WAR, "An invoke event execution is blocked: the component is not enabled: " + component.getId() + "/" + event.getClass().getSimpleName());
    }

    protected boolean findEnabledValueForComponent(BaseComponent component) {
        try {
            Object o = component.getAttributeValue(ICCComponentProperties.ATT_enabled);
            if (o == null) {
                return true;
            }
            if (o instanceof Boolean) {
                return (Boolean)o;
            }
            String s = ValueManager.convertObject2ValueString(o);
            return ValueManager.decodeBoolean(s, true);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem when resolving enabled value: " + component.getClass(), t);
            return true;
        }
    }

    protected void performPassingValueBlockedActivity(BaseComponent component, BaseComponent.DecodePassData decodeInfo, String value) {
        CLog.L.log(CLog.LL_WAR, "DECODE-VETO: Component vetoes update of its content value. Reason: the component is disabled");
        CLog.L.log(CLog.LL_WAR, "DECODE-VETO: Component id: " + component.getId() + ", " + this.getClass().getName());
        CLog.L.log(CLog.LL_WAR, "DECODE-VETO: Value that is vetoed: " + value);
    }
}

