/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.faces.event.ActionEvent;
import org.eclnt.jsfserver.elements.componentnodes.BUTTONNode;
import org.eclnt.jsfserver.elements.impl.DYNAMICCONTENTBinding;
import org.eclnt.jsfserver.elements.impl.ROWDYNAMICCONTENTBinding;
import org.eclnt.jsfserver.pagebean.PageBean;

public class KEYSELECTORBinding
extends PageBean {
    Set<IListener> m_listeners = new HashSet<IListener>();
    boolean m_dirty = false;
    String m_labelStyleVariant = "keyselector";
    String m_labelStyleVariantSelected = "keyselectorselected";
    DYNAMICCONTENTBinding m_content = new DYNAMICCONTENTBinding();
    List<KeyInfo> m_keyInfos = new ArrayList<KeyInfo>();

    @Override
    public String getPageName() {
        return "/eclntjsfserver/includes/keyselector.jsp";
    }

    @Override
    public String getRootExpressionUsedInPage() {
        return "#{KEYSELECTOR}";
    }

    public void addListener(IListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeListener(IListener listener) {
        this.m_listeners.remove(listener);
    }

    public DYNAMICCONTENTBinding getContent() {
        return this.m_content;
    }

    public List<KeyInfo> getKeyInfos() {
        return this.m_keyInfos;
    }

    public void addKeyInfosAZ() {
        this.addKeyInfos("ABCDEFGHIJKLMNOPQRSTUVWXYZ");
    }

    public void addKeyInfos09() {
        this.addKeyInfos("0123456789");
    }

    public void addKeyInfos(String keys) {
        for (int i = 0; i < keys.length(); ++i) {
            this.addKeyInfo(keys.substring(i, i + 1));
        }
    }

    public void addKeyInfo(String key) {
        this.m_dirty = true;
        KeyInfo ki = new KeyInfo();
        ki.i_key = key;
        this.m_keyInfos.add(ki);
    }

    public void disableAll() {
        for (KeyInfo ki : this.m_keyInfos) {
            ki.i_enabled = false;
        }
    }

    public void enableAll() {
        for (KeyInfo ki : this.m_keyInfos) {
            ki.i_enabled = true;
        }
    }

    public void disableKeyInfo(String key) {
        KeyInfo ki = this.findKeyInfo(key);
        if (ki != null) {
            ki.i_enabled = false;
        }
    }

    public void enableKeyInfo(String key) {
        KeyInfo ki = this.findKeyInfo(key);
        if (ki != null) {
            ki.i_enabled = true;
        }
    }

    public void clearKeyInfos() {
        this.m_dirty = true;
        this.m_keyInfos.clear();
    }

    public void selectKeyInfo(String key) {
        this.selectKeyInfo(this.findKeyInfo(key));
    }

    public void clearKeyInfoSelection() {
        for (KeyInfo ki : this.m_keyInfos) {
            ki.i_selected = false;
        }
    }

    public void selectKeyInfo(KeyInfo keyInfo) {
        for (KeyInfo ki : this.m_keyInfos) {
            if (ki == keyInfo) {
                ki.i_selected = true;
                continue;
            }
            ki.i_selected = false;
        }
    }

    public void render() {
        if (this.m_dirty) {
            int counter = 0;
            ArrayList<ROWDYNAMICCONTENTBinding.ComponentNode> cs = new ArrayList<ROWDYNAMICCONTENTBinding.ComponentNode>();
            for (KeyInfo ki : this.m_keyInfos) {
                BUTTONNode ln = new BUTTONNode();
                ln.setText(ki.i_key);
                ln.setReference(ki.i_key);
                ln.setEnabled("#{KEYSELECTOR.keyInfos[" + counter + "].enabled}");
                ln.setStylevariant("#{KEYSELECTOR.keyInfos[" + counter + "].styleVariant}");
                ln.setActionListener("#{KEYSELECTOR.keyInfos[" + counter + "].onAction}");
                cs.add(ln);
                ++counter;
            }
            this.m_content.setContentNodes(cs);
        }
        this.m_dirty = false;
    }

    private KeyInfo findKeyInfo(String key) {
        if (key == null) {
            return null;
        }
        for (KeyInfo ki : this.m_keyInfos) {
            if (ki.i_key == null || !ki.i_key.equals(key)) continue;
            return ki;
        }
        return null;
    }

    public class KeyInfo {
        String i_key;
        boolean i_enabled = true;
        boolean i_selected;

        public String getKey() {
            return this.i_key;
        }

        public boolean isEnabled() {
            return this.i_enabled;
        }

        public boolean isSelected() {
            return this.i_selected;
        }

        public String getStyleVariant() {
            if (this.i_selected) {
                return KEYSELECTORBinding.this.m_labelStyleVariantSelected;
            }
            return KEYSELECTORBinding.this.m_labelStyleVariant;
        }

        public void onAction(ActionEvent event) {
            KEYSELECTORBinding.this.selectKeyInfo(this);
            for (IListener listener : KEYSELECTORBinding.this.m_listeners) {
                try {
                    listener.onKeySelected(this.i_key);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static interface IListener {
        public void onKeySelected(String var1);
    }
}

