/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements.impl;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionListener;
import javax.servlet.http.HttpSession;
import org.eclnt.jsfserver.elements.BaseActionComponent;
import org.eclnt.jsfserver.elements.BaseComponent;
import org.eclnt.jsfserver.elements.BaseComponentTag;
import org.eclnt.jsfserver.elements.ComponentDump;
import org.eclnt.jsfserver.elements.ICreateUpdateInnerComponents;
import org.eclnt.jsfserver.elements.ThreadData;
import org.eclnt.jsfserver.elements.impl.ARRAYGRIDComponent;
import org.eclnt.jsfserver.elements.impl.FIXGRIDComponent;
import org.eclnt.jsfserver.elements.impl.GRIDCOLComponent;
import org.eclnt.jsfserver.elements.impl.ROWDYNAMICCONTENTComponentTag;
import org.eclnt.jsfserver.elements.impl.SPANGRIDComponent;
import org.eclnt.jsfserver.util.ExpressionManagerV;
import org.eclnt.jsfserver.util.ExpressionUtil;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.IServerSideScrollList;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.XMLWriter;

public class REPEATComponent
extends BaseActionComponent
implements ICreateUpdateInnerComponents {
    int m_idCounter = 0;
    boolean m_jspAnalyzed = false;
    List<BaseComponent> m_jspComponents = new ArrayList<BaseComponent>();
    int m_currentListSize = 0;
    long mtransient_bufferReference = 0L;
    boolean mtransient_changeMarkerToBeWritten = false;

    @Override
    public Object saveState(FacesContext context) {
        ArrayList<Object> os = new ArrayList<Object>();
        os.add(super.saveState(context));
        os.add(this.m_idCounter);
        os.add(this.m_currentListSize);
        for (UIComponent uIComponent : this.m_jspComponents) {
            os.add(uIComponent);
        }
        Object[] osArray = new Object[os.size()];
        os.toArray(osArray);
        return osArray;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.m_idCounter = (Integer)values[1];
        this.m_currentListSize = (Integer)values[2];
        for (int i = 3; i < values.length; ++i) {
            this.m_jspComponents.add((BaseComponent)values[i]);
        }
    }

    @Override
    public void encodeBegin(FacesContext context) throws IOException {
        ++this.mtransient_bufferReference;
        HttpSession session = HttpSessionAccess.getCurrentHttpSessionIfAvailable(context);
        REPEATComponent.ensureSessionIsValid(session);
        this.createUpdateInnerComponents(context);
        if (this.mtransient_changeMarkerToBeWritten) {
            ResponseWriter writer = context.getResponseWriter();
            ThreadData threadData = ThreadData.getInstance();
            ComponentDump currentDump = (ComponentDump)session.getAttribute(threadData.getSubpageId() + "/" + "org.eclnt.jsfserver/currentDump");
            XMLWriter.writer_writeChangedMarker((Writer)writer, currentDump);
            this.mtransient_changeMarkerToBeWritten = false;
        }
    }

    @Override
    public void createUpdateInnerComponents(FacesContext context) {
        if (!this.m_jspAnalyzed) {
            this.parkJspComponents();
            this.m_jspAnalyzed = true;
        }
        this.removeOriginalComponents();
        try {
            Object listBindingObject = this.getAttributesGet(BaseComponentTag.ATT_listbinding);
            List dataList = null;
            boolean withServerSideScrolling = false;
            if (listBindingObject instanceof List) {
                dataList = (List)listBindingObject;
            } else if (listBindingObject instanceof IServerSideScrollList) {
                ((IServerSideScrollList)listBindingObject).setBufferReference(this.mtransient_bufferReference);
                dataList = ((IServerSideScrollList)listBindingObject).getClientItems();
                withServerSideScrolling = true;
            }
            String dataListExpression = this.getAttributeString(BaseComponentTag.ATT_listbinding);
            this.adaptRendering(context, dataList, dataListExpression, withServerSideScrolling);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem during creating/updating inner components", t);
        }
    }

    @Override
    public long getChangeIndex() {
        throw new Error("getChangeIndex not yet implemented for REPEAT component");
    }

    @Override
    public void encodeEnd(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        HttpSession session = HttpSessionAccess.getCurrentHttpSession(context);
        ComponentDump currentDump = this.readCurrentComponentDump(context);
        this.detectChangesInSubComponents((Writer)writer, currentDump);
    }

    private void parkJspComponents() {
        this.m_jspComponents.clear();
        for (Object child : this.getChildren()) {
            this.m_jspComponents.add((BaseComponent)child);
        }
        this.clearAndDestroyChildren();
    }

    private void adaptRendering(FacesContext context, List dataList, String dataListExpression, boolean withServerSideScrolling) {
        if (dataList == null) {
            return;
        }
        if (this.m_currentListSize == dataList.size()) {
            return;
        }
        if (this.m_currentListSize < dataList.size()) {
            for (int i = this.m_currentListSize; i < dataList.size(); ++i) {
                List<BaseComponent> newComponents = this.createItem(dataList, dataListExpression, i, withServerSideScrolling);
                for (BaseComponent newComponent : newComponents) {
                    this.getChildren().add(newComponent);
                }
            }
        } else if (this.m_currentListSize > dataList.size()) {
            int count = this.m_currentListSize - dataList.size();
            for (int i = 0; i < count; ++i) {
                this.removeLastItem();
            }
        }
        this.m_currentListSize = dataList.size();
        this.mtransient_changeMarkerToBeWritten = true;
    }

    private List<BaseComponent> createItem(List dataList, String dataListExpression, int index, boolean withServerSideScrolling) {
        ArrayList<BaseComponent> result = new ArrayList<BaseComponent>();
        for (BaseComponent child : this.m_jspComponents) {
            boolean replaceItemExpressions = this.checkIfComponentRequiresReplacement(child, true);
            BaseComponent childClone = this.createComponentClone(child, index, withServerSideScrolling, dataList, dataListExpression, replaceItemExpressions);
            result.add(childClone);
        }
        return result;
    }

    private boolean checkIfComponentRequiresReplacement(BaseComponent child, boolean defaultValue) {
        UIComponent childParent = child.getParent();
        if (childParent != null) {
            if (childParent instanceof REPEATComponent) {
                return false;
            }
            if (childParent instanceof GRIDCOLComponent) {
                try {
                    int index = childParent.getChildren().indexOf(child);
                    if (index == 0) {
                        return false;
                    }
                }
                catch (Throwable t) {
                    CLog.L.log(CLog.LL_INF, "should not happen", t);
                    return false;
                }
            }
            if (childParent instanceof ARRAYGRIDComponent) {
                return false;
            }
            if (childParent instanceof SPANGRIDComponent) {
                return false;
            }
        }
        return defaultValue;
    }

    private BaseComponent createComponentClone(BaseComponent template, int index, boolean withServerSideScrolling, List dataList, String dataListExpression, boolean replaceItemExpressions) {
        ActionListener actionListener;
        Application fapp = HttpSessionAccess.getCurrentFacesContext().getApplication();
        BaseComponentTag componentTag = FIXGRIDComponent.createComponentTag(template);
        componentTag.setId(template.getId() + "_idx" + index + "_ccrepeat");
        HashSet<String> processedAttributes = new HashSet<String>();
        for (String key : template.getAttributes().keySet()) {
            String value = template.getAttributeString(key);
            if (key.startsWith("_")) {
                key = key.substring(1);
            }
            if (value == null) continue;
            if (replaceItemExpressions && ExpressionUtil.checkIfExpressionIsRelativeExpression(value)) {
                String s = dataListExpression.substring(0, dataListExpression.length() - 1);
                s = s.substring(2);
                if (withServerSideScrolling) {
                    s = s + ".clientItems";
                }
                s = s + "[" + index + "]";
                value = ExpressionUtil.buildAbsoluteExpressionFromRelativeExpression(value, s);
            } else {
                processedAttributes.add(key);
            }
            componentTag.invokeSetter(key, value);
        }
        List<String> tagAttributes = template.getTagAttributes();
        for (int i = 0; i < tagAttributes.size(); ++i) {
            Object vb;
            String attribute = tagAttributes.get(i);
            if (processedAttributes.contains(attribute) || (vb = template.getExpressionFromComponentAttribute(attribute)) == null) continue;
            componentTag.invokeSetter(attribute, ExpressionManagerV.getExpressionString(vb));
        }
        if (componentTag instanceof ROWDYNAMICCONTENTComponentTag) {
            String dleBase = dataListExpression.substring(0, dataListExpression.length() - 1);
            componentTag.setGridcontentreplace(".{:" + dleBase + "[" + index + "].");
        }
        BaseComponent result = componentTag.createBaseComponent();
        if (template instanceof BaseActionComponent && result instanceof BaseActionComponent && (actionListener = ((BaseActionComponent)template).getFirstActionListener()) != null) {
            ((BaseActionComponent)result).addActionListener(actionListener);
        }
        List children = template.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            BaseComponent templateChild = (BaseComponent)children.get(i);
            boolean myReplaceItemExpressions = this.checkIfComponentRequiresReplacement(templateChild, replaceItemExpressions);
            BaseComponent childComp = this.createComponentClone(templateChild, index, withServerSideScrolling, dataList, dataListExpression, myReplaceItemExpressions);
            result.getChildren().add(childComp);
        }
        return result;
    }

    private void removeLastItem() {
        for (int i = 0; i < this.m_jspComponents.size(); ++i) {
            this.getChildren().remove(this.getChildCount() - 1);
        }
    }

    private void removeOriginalComponents() {
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            UIComponent c = this.getChild(i);
            if (c.getId().endsWith("_ccrepeat")) continue;
            this.getChildren().remove(i);
        }
    }
}

