/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements.phases;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.eclnt.jsfserver.elements.ThreadData;
import org.eclnt.util.log.CLog;

public class PhaseRunnables
implements Serializable {
    Set<Runnable> m_beforeUpdateRunnables = new HashSet<Runnable>();
    Set<Runnable> m_afterUpdateRunnables = new HashSet<Runnable>();
    Set<Runnable> m_beforeInvokeRunnables = new HashSet<Runnable>();
    Set<Runnable> m_afterInvokeRunnables = new HashSet<Runnable>();
    Set<Runnable> m_beforeRenderResponseRunnables = new HashSet<Runnable>();
    Set<Runnable> m_afterRenderResponseRunnables = new HashSet<Runnable>();

    void addAfterUpdateRunnable(Runnable r) {
        CLog.L.log(CLog.LL_INF, "Adding phase runnable (afterUpdate)");
        this.m_afterUpdateRunnables.add(r);
    }

    public void runAfterUpdateRunnables() {
        this.runAllFromList(this.m_afterUpdateRunnables, "afterUpdate");
    }

    void addBeforeUpdateRunnable(Runnable r) {
        CLog.L.log(CLog.LL_INF, "Adding phase runnable (beforeUpdate)");
        this.m_beforeUpdateRunnables.add(r);
    }

    public void runBeforeUpdateRunnables() {
        this.runAllFromList(this.m_beforeUpdateRunnables, "beforeUpdate");
    }

    void addAfterInvokeRunnable(Runnable r) {
        CLog.L.log(CLog.LL_INF, "Adding phase runnable (afterInvoke)");
        this.m_afterInvokeRunnables.add(r);
    }

    public void runAfterInvokeRunnables() {
        this.runAllFromList(this.m_afterInvokeRunnables, "afterInvoke");
    }

    void addBeforeInvokeRunnable(Runnable r) {
        CLog.L.log(CLog.LL_INF, "Adding phase runnable (beforeInvoke)");
        this.m_beforeInvokeRunnables.add(r);
    }

    public void runBeforeInvokeRunnables() {
        this.runAllFromList(this.m_beforeInvokeRunnables, "beforeInvoke");
    }

    void addAfterRenderResponseRunnable(Runnable r) {
        CLog.L.log(CLog.LL_INF, "Adding phase runnable (afterRender)");
        this.m_afterRenderResponseRunnables.add(r);
    }

    public void runAfterRenderResponseRunnables() {
        this.runAllFromList(this.m_afterRenderResponseRunnables, "afterRender");
    }

    void addBeforeRenderResponseRunnable(Runnable r) {
        CLog.L.log(CLog.LL_INF, "Adding phase runnable (beforeRender)");
        this.m_beforeRenderResponseRunnables.add(r);
    }

    public void runBeforeRenderResponseRunnables() {
        this.runAllFromList(this.m_beforeRenderResponseRunnables, "beforeRender");
    }

    private void runAllFromList(Set<Runnable> runnables, String phaseName) {
        Runnable[] runnableArray = new Runnable[runnables.size()];
        runnables.toArray(runnableArray);
        runnables.clear();
        for (Runnable r : runnableArray) {
            try {
                long startNano = System.nanoTime();
                CLog.L.log(CLog.LL_INF, "Executing Runnable from Phase Manager, starting...");
                r.run();
                CLog.L.log(CLog.LL_INF, "Executing Runnable from Phase Manager, ...finished!");
                long stopNano = System.nanoTime();
                ThreadData.getInstance().addConsumedNanosPhase(phaseName + ": " + r.getClass().getName(), stopNano - startNano);
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_ERR, "Error occurred when executing runnable", t);
            }
        }
    }
}

