/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.i18n;

import java.io.Serializable;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclnt.jsfserver.configuration.CCConfigurationObject;
import org.eclnt.jsfserver.i18n.I18NConnector;
import org.eclnt.jsfserver.resources.ResourceManager;
import org.eclnt.jsfserver.util.HttpSessionAccess;

public class I18N
implements Map<String, String>,
Serializable {
    public static final String I18N_RESOURCEBUNDLE = "org.eclnt.jsfserver.i18n.resources.Literals";
    public static final String I18N_RESOURCEMANAGER_RESOURCENAME = "cci18n";
    protected static I18NConnector s_connector = null;
    protected static CCConfigurationObject<I18NConnector> s_connectorCO = null;
    protected static I18N s_instance = new I18N();

    public static void setI18NConnector(I18NConnector connector) {
        s_connector = connector;
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean containsValue(Object value) {
        return false;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return null;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Set<String> keySet() {
        return null;
    }

    @Override
    public String put(String key, String value) {
        return null;
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
    }

    @Override
    public String remove(Object key) {
        return null;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public Collection<String> values() {
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        String result = this.get(key);
        return result != null;
    }

    @Override
    public String get(Object key) {
        return this.get(key, null);
    }

    public String get(Object key, String nullDefault) {
        String result;
        Locale currentLocale = this.findCurrentLocale();
        if (s_connector != null && (result = s_connector.readLiteralForKey(currentLocale, (String)key)) != null) {
            return result;
        }
        try {
            result = ResourceManager.getRuntimeInstance().readProperty(I18N_RESOURCEMANAGER_RESOURCENAME, key.toString());
            if (result == null && nullDefault != null) {
                result = nullDefault;
            }
            return result;
        }
        catch (Throwable t) {
            return nullDefault;
        }
    }

    public static String getString(String literalId) {
        return s_instance.get(literalId);
    }

    public static ResourceBundle getBundle() {
        Locale l = null;
        try {
            l = HttpSessionAccess.getCurrentFacesContext().getViewRoot().getLocale();
        }
        catch (Throwable t) {
            l = Locale.getDefault();
        }
        return ResourceBundle.getBundle(I18N_RESOURCEBUNDLE, l);
    }

    public static ResourceBundle getBundle(String language) {
        Locale locale = Locale.getDefault();
        if (language != null) {
            locale = new Locale(language);
        }
        return ResourceBundle.getBundle(I18N_RESOURCEBUNDLE, locale);
    }

    private Locale findCurrentLocale() {
        Locale result = null;
        try {
            result = HttpSessionAccess.getCurrentFacesContext().getViewRoot().getLocale();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (result == null) {
            result = Locale.getDefault();
        }
        return result;
    }
}

