/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.polling.websocket;

import org.eclnt.jsfserver.polling.ILongPolling;
import org.eclnt.jsfserver.polling.websocket.WebSocketPollingEndPoint;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.ServletUtil;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.UniqueIdCreator;

public class DefaultLongPollingWebSocket
implements ILongPolling {
    String m_id = "cclongpolling_" + UniqueIdCreator.createUUID();
    String m_bufferedUrl = null;
    String m_longPollingResponse = null;
    WebSocketPollingEndPoint m_endPoint = null;
    String m_messageToBeSent = null;
    long m_lastResponseTime;
    long m_lastWakeupStamp = -1L;
    boolean m_lastWakeupValue;
    long m_lastWakeupActionStamp = -1L;

    public DefaultLongPollingWebSocket() {
        this.updateLastResponseTime();
    }

    @Override
    public String getId() {
        return this.m_id;
    }

    @Override
    public boolean getContinuePolling() {
        return true;
    }

    public void registerEndPoint(WebSocketPollingEndPoint endPoint) {
        this.updateLastResponseTime();
        if (this.m_endPoint == endPoint) {
            return;
        }
        if (this.m_endPoint != null) {
            this.m_endPoint.close();
        }
        this.m_endPoint = endPoint;
        this.processMessage();
    }

    public synchronized void unregisterEndPoint(WebSocketPollingEndPoint endPoint) {
        if (this.m_endPoint == endPoint) {
            this.m_endPoint = null;
        }
    }

    @Override
    public String getURL() {
        if (this.m_bufferedUrl == null) {
            String result = "ccwebsocketpolling/" + this.m_id;
            result = ServletUtil.encodeURL(result, HttpSessionAccess.getCurrentRequest(), HttpSessionAccess.getCurrentResponse());
            this.m_bufferedUrl = result = "/" + result;
        }
        return this.m_bufferedUrl;
    }

    @Override
    public void wakeup(boolean continuePolling) {
        this.updateLastResponseTime();
        this.m_lastWakeupStamp = System.currentTimeMillis();
        this.m_lastWakeupValue = continuePolling;
        this.m_messageToBeSent = "" + continuePolling + ";" + this.m_id + ";" + this.m_lastWakeupStamp;
        this.processMessage();
    }

    protected void processMessage() {
        if (this.m_messageToBeSent == null) {
            return;
        }
        try {
            this.updateLastResponseTime();
            CLog.L.log(CLog.LL_INF, "Trying to send message: " + this.m_messageToBeSent);
            if (this.m_endPoint == null) {
                CLog.L.log(CLog.LL_INF, "Trying to send message: the end point is not yet built up from client side. The message will be sent when the end point is registered.");
                return;
            }
            this.m_endPoint.sendMessage(this.m_messageToBeSent);
            CLog.L.log(CLog.LL_INF, "Trying to send message: ...successful!");
            this.m_messageToBeSent = null;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem sending message: " + t.toString());
            CLog.L.log(CLog.LL_INF, "The message is stored: " + this.m_messageToBeSent);
        }
    }

    @Override
    public void wakeupForReconnect() {
        this.sendMessageToClient("           ");
    }

    protected void sendMessageToClient(String textMessage) {
        try {
            this.updateLastResponseTime();
            this.m_endPoint.sendMessage(textMessage);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    @Deprecated
    public void abortThreadWithouContinuingPolling() {
        this.abortThreadWithoutContinuingPolling();
    }

    public void abortThreadWithoutContinuingPolling() {
        this.m_messageToBeSent = "false";
        this.processMessage();
        this.m_endPoint.close();
    }

    @Override
    public void abortThread() {
        CLog.L.log(CLog.LL_INF, "Websocketpolling: aborting longpolling thread");
        this.m_messageToBeSent = "false";
        this.processMessage();
        if (this.m_endPoint != null) {
            this.m_endPoint.close();
        }
    }

    @Override
    public void abortThreadWithErrorIfWaiting() {
        this.m_messageToBeSent = "false";
        this.processMessage();
        if (this.m_endPoint != null) {
            this.m_endPoint.close();
        }
    }

    public String getLongPollingResponse() {
        return this.m_longPollingResponse;
    }

    @Override
    public void keepAlive() {
        try {
            this.updateLastResponseTime();
            this.m_endPoint.sendMessage("           ");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public long getLastResponseTime() {
        return this.m_lastResponseTime;
    }

    public void notifyActionForWakeup(long longPollingWakeupStamp) {
        long m_lastWakeupActionStamp = longPollingWakeupStamp;
        CLog.L.log(CLog.LL_INF, "LongPollingWebSocket: notification of action: " + longPollingWakeupStamp + " - " + this.m_lastWakeupStamp);
    }

    public void reprocessWakeupsWhichAreNotYetMirroredByAction() {
        if (this.m_lastWakeupStamp < 0L) {
            return;
        }
        if (this.m_lastWakeupActionStamp < this.m_lastWakeupStamp) {
            CLog.L.log(CLog.LL_INF, "LongPollingWebSocket: reprocessing wakeup that is not mirrored by action, " + this.getId() + ", " + this.m_lastWakeupValue);
            this.wakeup(this.m_lastWakeupValue);
        }
    }

    private void updateLastResponseTime() {
        this.m_lastResponseTime = System.currentTimeMillis();
    }
}

