/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.rttools;

import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import javax.faces.event.ActionEvent;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.eclnt.editor.annotations.CCGenClass;
import org.eclnt.jsfserver.defaultscreens.Statusbar;
import org.eclnt.jsfserver.defaultscreens.YESNOPopup;
import org.eclnt.jsfserver.rttools.DynBeanTreeUI;
import org.eclnt.jsfserver.streamstore.IStreamStore;
import org.eclnt.jsfserver.streamstore.StreamStore;
import org.eclnt.jsfserver.streamstore.StreamStoreFile;
import org.eclnt.util.file.ClassloaderReader;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;
import org.eclnt.workplace.IPrepareByWorkpageStartInfo;
import org.eclnt.workplace.IWorkpageDispatcher;
import org.eclnt.workplace.IWorkpageStartInfo;
import org.eclnt.workplace.WorkpageDefaultLifecycleListener;
import org.eclnt.workplace.WorkpageDispatchedPageBean;
import org.eclnt.workplace.WorkplaceFunctionTreeInfoManager;
import org.eclnt.workplace.WorkplaceFunctionTreeInfoNode;
import org.eclnt.workplace.WorkplaceTileInfo;
import org.eclnt.workplace.WorkplaceUserInfo;
import org.eclnt.workplace.WorkplaceUserInfoManager;
import org.eclnt.workplace.WorkplaceViewManager;

@CCGenClass(expressionBase="#{cctd.StreamStoreDetailUI}")
public class StreamStoreDetailUI
extends WorkpageDispatchedPageBean
implements Serializable,
IPrepareByWorkpageStartInfo {
    public static String PARAM_ABSPATH = "abspath";
    public static String PARAM_STREAMSTOREFILEROOTWS = "streamstorefilerootws";
    public static String PARAM_WITHTENANTMANAGEMENT = "withtenantmanagement";
    String m_absPath;
    String m_content;
    String m_contentLastSave = null;
    String m_template;
    String m_dividerPosition = "66%";
    String m_streamStoreFileRootWS = null;
    boolean m_withTenantManagement = true;
    IListener m_listener;
    IStreamStore m_streamStore = null;
    boolean m_renderTextEditor = true;
    boolean m_renderDynBeanEditor = false;
    DynBeanTreeUI m_dynBeanTree;

    public StreamStoreDetailUI(IWorkpageDispatcher workpageDispatcher) {
        super(workpageDispatcher);
        this.getWorkpage().addLifecycleListener(new WorkpageDefaultLifecycleListener(){

            @Override
            public boolean close() {
                StreamStoreDetailUI.this.buildContentString();
                if (ValueManager.checkIfStringsAreEqual(StreamStoreDetailUI.this.m_content, StreamStoreDetailUI.this.m_contentLastSave)) {
                    return true;
                }
                YESNOPopup.createInstance("Content was saved", "Do your really want to exit?", new YESNOPopup.IYesNoListener(){

                    @Override
                    public void reactOnYes() {
                        StreamStoreDetailUI.this.getWorkpageContainer().closeWorkpageForced(StreamStoreDetailUI.this.getWorkpage());
                    }

                    @Override
                    public void reactOnNo() {
                    }
                });
                return false;
            }
        });
    }

    @Override
    public String getPageName() {
        return "/eclntjsfserver/includes/streamstoredetail.jsp";
    }

    @Override
    public String getRootExpressionUsedInPage() {
        return "#{cctd.StreamStoreDetailUI}";
    }

    public String getContent() {
        return this.m_content;
    }

    public void setContent(String value) {
        this.m_content = value;
    }

    public String getTemplate() {
        return this.m_template;
    }

    public void setDividerPosition(String value) {
        this.m_dividerPosition = value;
    }

    public String getDividerPosition() {
        return this.m_dividerPosition;
    }

    public IListener getListener() {
        return this.m_listener;
    }

    public void setListener(IListener listener) {
        this.m_listener = listener;
    }

    public boolean getRenderTextEditor() {
        return this.m_renderTextEditor;
    }

    public boolean getRenderDynBeanEditor() {
        return this.m_renderDynBeanEditor;
    }

    public DynBeanTreeUI getDynBeanTree() {
        return this.m_dynBeanTree;
    }

    @Override
    public void prepare(IWorkpageStartInfo workpageStartInfo) {
        if (workpageStartInfo != null) {
            this.prepare(workpageStartInfo.getParam(PARAM_ABSPATH), workpageStartInfo.getParam(PARAM_STREAMSTOREFILEROOTWS), ValueManager.decodeBoolean(workpageStartInfo.getParam(PARAM_STREAMSTOREFILEROOTWS), true), null);
        }
    }

    public void prepare(String absPath, String streamStoreRootWS, boolean withTenantManagement, IListener listener) {
        this.m_streamStoreFileRootWS = streamStoreRootWS;
        this.m_withTenantManagement = withTenantManagement;
        this.m_listener = listener;
        this.prepare(absPath);
    }

    public void prepare(String absPath) {
        this.m_absPath = absPath;
        this.m_content = this.findStreamStore().readUTF8(this.m_absPath, false);
        if (this.m_content == null) {
            this.m_content = "";
        }
        this.m_contentLastSave = this.m_content;
        this.loadTemplate();
        this.useDynBeanEditor();
    }

    public void onSave(ActionEvent event) {
        this.buildContentString();
        if (this.check()) {
            this.findStreamStore().writeUTF8(this.m_absPath, this.m_content, true);
            this.m_contentLastSave = this.m_content;
            Statusbar.outputSuccess("Content was saved.");
            if (this.m_listener != null) {
                this.m_listener.reactOnSave();
            }
        }
    }

    private void buildContentString() {
        if (this.m_content == null) {
            this.m_content = "";
        }
        if (this.m_renderDynBeanEditor) {
            this.m_content = this.dervieContentFromBeanEditor();
        }
    }

    private String dervieContentFromBeanEditor() {
        try {
            Object bean = this.m_dynBeanTree.getBean();
            JAXBContext jbContext = JAXBContext.newInstance((Class[])new Class[]{bean.getClass()});
            Marshaller m = jbContext.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.setProperty("jaxb.encoding", (Object)"UTF-8");
            StringWriter writer = new StringWriter();
            m.marshal(bean, (Writer)writer);
            String result = ((Object)writer).toString();
            return result;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem when deriving content from DynBean Editor");
            throw new Error(t);
        }
    }

    public void onCheck(ActionEvent event) {
        if (this.m_content == null) {
            this.m_content = "";
        }
        this.check();
    }

    private void loadTemplate() {
        this.m_template = "No template available.";
        try {
            String templateName = this.m_absPath;
            int index = templateName.lastIndexOf(47);
            templateName = templateName.substring(0, index);
            templateName = templateName.replace("/", "");
            this.m_template = new ClassloaderReader().readUTF8File("org/eclnt/jsfserver/rttools/" + templateName + "_template.txt", true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void useDynBeanEditor() {
        try {
            Serializable bean = null;
            if (this.m_absPath.startsWith("/ccworkplace/perspectives")) {
                bean = this.m_content.length() > 0 ? WorkplaceViewManager.unmarshalTileInfo(this.m_content) : new WorkplaceTileInfo();
            } else if (this.m_absPath.startsWith("/ccworkplace/functiontrees")) {
                bean = this.m_content.length() > 0 ? WorkplaceFunctionTreeInfoManager.unmarshalFunctionTreeInfo(this.m_content) : new WorkplaceFunctionTreeInfoNode();
            } else if (this.m_absPath.startsWith("/ccworkplace/userinfo")) {
                bean = this.m_content.length() > 0 ? WorkplaceUserInfoManager.unmarshalUserInfo(this.m_content) : new WorkplaceUserInfo();
            }
            if (bean != null) {
                this.m_dynBeanTree = new DynBeanTreeUI();
                this.m_dynBeanTree.prepare(bean);
                this.m_renderTextEditor = false;
                this.m_renderDynBeanEditor = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean check() {
        try {
            if (this.m_absPath.startsWith("/ccworkplace/perspectives")) {
                WorkplaceViewManager.unmarshalTileInfo(this.m_content);
            } else if (this.m_absPath.startsWith("/ccworkplace/functiontrees")) {
                WorkplaceFunctionTreeInfoManager.unmarshalFunctionTreeInfo(this.m_content);
            } else if (this.m_absPath.startsWith("/ccworkplace/userinfo")) {
                WorkplaceUserInfoManager.unmarshalUserInfo(this.m_content);
            }
            Statusbar.outputSuccess("Check was successful.");
            return true;
        }
        catch (Throwable t) {
            Statusbar.outputError(t.toString(), ValueManager.getStackstraceString(t));
            return false;
        }
    }

    private IStreamStore findStreamStore() {
        if (this.m_streamStore == null) {
            if (this.m_streamStoreFileRootWS == null) {
                this.m_streamStore = StreamStore.getInstance();
            } else {
                this.m_streamStore = new StreamStoreFile();
                ((StreamStoreFile)this.m_streamStore).init(this.m_streamStoreFileRootWS, this.m_withTenantManagement);
            }
        }
        return this.m_streamStore;
    }

    public static interface IListener {
        public void reactOnSave();
    }
}

