/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import java.beans.FeatureDescriptor;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.el.ArrayELResolver;
import javax.el.BeanELResolver;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.Expression;
import javax.el.ListELResolver;
import javax.el.MapELResolver;
import javax.el.MethodExpression;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import javax.el.ValueExpression;
import org.eclnt.jsfserver.configuration.CCConfigurationObjectLoader;
import org.eclnt.jsfserver.elements.ThreadData;
import org.eclnt.jsfserver.managedbean.HotDeployManager;
import org.eclnt.jsfserver.util.FacesConfigReader;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.IAcceleratedPropertyAccess;
import org.eclnt.jsfserver.util.IPropertyResolverAware;
import org.eclnt.jsfserver.util.IPropertyTypeResolver;
import org.eclnt.jsfserver.util.IPropertyValueConverter;
import org.eclnt.jsfserver.util.InitEclntJsfServer;
import org.eclnt.jsfserver.util.ServletUtil;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.jsfserver.util.TypeOfSessionMgmt;
import org.eclnt.jsfserver.util.el.RecordELResolver;
import org.eclnt.util.java.JavaVersion;
import org.eclnt.util.log.CLog;
import org.eclnt.util.logdt.DTLogFactory;
import org.eclnt.util.logdt.ENUMLogCategory;

public class CCELResolver
extends ELResolver {
    ELResolver m_delegateTo = new CompositeELResolver();
    static String ATTRIBUTENAME = "VariableResolverByDelegation";
    static boolean s_managedBeanIsResetByApplication = false;
    static boolean s_hotDeployIsActive = false;
    static ValueExpression s_currentValueExpression;
    static MethodExpression s_currentMethodExpression;
    boolean m_firstResolving = true;
    static ICCELResolverListener s_listener;
    static BeanELResolver s_currentBeanELResolver;
    static Set<Thread> s_threadsWithErrorFalse;

    public CCELResolver(ELResolver delegateTo) {
        this();
    }

    public CCELResolver() {
        ((CompositeELResolver)this.m_delegateTo).add((ELResolver)new ListELResolver());
        ((CompositeELResolver)this.m_delegateTo).add((ELResolver)new ArrayELResolver());
        ((CompositeELResolver)this.m_delegateTo).add((ELResolver)new MapELResolver());
        if (JavaVersion.isSupportingRecords()) {
            ((CompositeELResolver)this.m_delegateTo).add((ELResolver)new RecordELResolver());
        }
        BeanELResolver beanELResolver = new BeanELResolver();
        ((CompositeELResolver)this.m_delegateTo).add((ELResolver)beanELResolver);
        s_currentBeanELResolver = beanELResolver;
        s_hotDeployIsActive = true;
    }

    public static void initListener(ICCELResolverListener listener) {
        s_listener = listener;
    }

    public static void passCurrentValueExpressionBegin(ValueExpression currentValueExpression) {
        s_currentValueExpression = currentValueExpression;
        if (SystemXml.getThreadContextStoreCurrentExpression()) {
            ThreadData td = ThreadData.getInstance(false);
            if (td == null) {
                CLog.L.log(CLog.LL_INF, "Expression could not be stored in current thread-data. No data associated with current thread. " + currentValueExpression.getExpressionString());
            } else {
                td.registerCurrentlyProcessedExpression((Expression)currentValueExpression);
            }
        }
    }

    public static void passCurrentMethodExpressionBegin(MethodExpression currentMethodExpression) {
        s_currentMethodExpression = currentMethodExpression;
        if (SystemXml.getThreadContextStoreCurrentExpression()) {
            ThreadData td = ThreadData.getInstance(false);
            if (td == null) {
                CLog.L.log(CLog.LL_INF, "Expression could not be stored in current thread-data. No data associated with current thread. " + currentMethodExpression.getExpressionString());
            } else {
                td.registerCurrentlyProcessedExpression((Expression)currentMethodExpression);
            }
        }
    }

    public static void passCurrentMethodExpressionEnd() {
        ThreadData td;
        s_currentMethodExpression = null;
        if (SystemXml.getThreadContextStoreCurrentExpression() && (td = ThreadData.getInstance(false)) != null) {
            td.unregisterCurrentlyProcessedExpression();
        }
    }

    public static void passCurrentValueExpressionEnd() {
        ThreadData td;
        s_currentValueExpression = null;
        if (SystemXml.getThreadContextStoreCurrentExpression() && (td = ThreadData.getInstance(false)) != null) {
            td.unregisterCurrentlyProcessedExpression();
        }
    }

    public static ValueExpression getCurrentValueExpression() {
        return s_currentValueExpression;
    }

    public static MethodExpression getCurrentMethodExpression() {
        return s_currentMethodExpression;
    }

    public Class<?> getType(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        Class result = null;
        if (base != null && base instanceof IPropertyTypeResolver && property != null) {
            try {
                result = ((IPropertyTypeResolver)base).resolveType(property.toString());
                if (result != null) {
                    return result;
                }
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_INF, "Error in IPropertyTypeResolver: " + t.toString());
            }
        }
        try {
            return this.m_delegateTo.getType(context, base, property);
        }
        catch (Throwable t) {
            return Object.class;
        }
    }

    public Object getValue(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (base == null && property != null) {
            if (this.m_firstResolving) {
                this.m_firstResolving = false;
                if (((Object)((Object)this)).getClass().getClassLoader() != HotDeployManager.currentClassLoader()) {
                    s_hotDeployIsActive = true;
                    CLog.L.log(CLog.LL_INF, "Hot Deployment is used within the resolving of variables");
                }
            }
            if (s_managedBeanIsResetByApplication || s_hotDeployIsActive || TypeOfSessionMgmt.getSessionMgmtViaCookie()) {
                Object result;
                String sessionMapName = null;
                sessionMapName = TypeOfSessionMgmt.getSessionMgmtViaCookie() ? ATTRIBUTENAME + "/" + ThreadData.getInstance().getSubpageId() : ATTRIBUTENAME;
                HashMap map = (HashMap)HttpSessionAccess.getCurrentHttpSession().getAttribute(sessionMapName);
                if (s_managedBeanIsResetByApplication && map != null && (result = map.get(property)) != null) {
                    result = this.convertValueAfterGet(base, property, result);
                    context.setPropertyResolved(true);
                    return result;
                }
                if (s_hotDeployIsActive || TypeOfSessionMgmt.getSessionMgmtViaCookie()) {
                    if (map == null) {
                        map = new HashMap();
                        ServletUtil.setSessionAttributeWithTrustedName(HttpSessionAccess.getCurrentHttpSession(), sessionMapName, map);
                    }
                    if ((result = map.get(property)) != null) {
                        result = this.convertValueAfterGet(base, property, result);
                        context.setPropertyResolved(true);
                        return result;
                    }
                    try {
                        FacesConfigReader.ManagedBean mb = FacesConfigReader.getManagedBean(property.toString());
                        if (mb != null) {
                            String className = mb.getClassName();
                            if (className == null) {
                                throw new Exception("Class name is not defined in faces-config.xml definition for: " + property.toString());
                            }
                            result = CCConfigurationObjectLoader.instance().loadInstance(className, true);
                            if (!"request".equals(mb.getScope())) {
                                map.put(property.toString(), result);
                            }
                            result = this.convertValueAfterGet(base, property, result);
                            context.setPropertyResolved(true);
                            return result;
                        }
                    }
                    catch (Throwable t) {
                        CLog.L.log(CLog.LL_WAR, "Exception when accessing: " + property, t);
                    }
                }
            }
        }
        try {
            Object result;
            if (base != null && base instanceof IAcceleratedPropertyAccess && property != null && (result = ((IAcceleratedPropertyAccess)base).getPropertyValue(property.toString())) != IAcceleratedPropertyAccess.NOT_AVAILABLE) {
                result = this.convertValueAfterGet(base, property, result);
                context.setPropertyResolved(true);
                return result;
            }
            result = this.m_delegateTo.getValue(context, base, property);
            result = this.convertValueAfterGet(base, property, result);
            context.setPropertyResolved(true);
            return result;
        }
        catch (Throwable t) {
            if (CCELResolver.checkIfThreandWithErrorFalse()) {
                return null;
            }
            if (CLog.L.isLoggable(InitEclntJsfServer.s_logLevelMissingPropertyGet)) {
                CLog.L.log(InitEclntJsfServer.s_logLevelMissingPropertyGet, "No property value available for: " + base + "/" + property + ", Error is: " + t.toString());
                if (s_currentValueExpression != null) {
                    CLog.L.log(InitEclntJsfServer.s_logLevelMissingPropertyGet, "                                 expression: " + s_currentValueExpression.getExpressionString());
                }
                if (InitEclntJsfServer.s_logStacktraceMissingPropertyGet) {
                    CLog.L.log(InitEclntJsfServer.s_logLevelMissingPropertyGet, "                                 Stacktrace:", t);
                }
                DTLogFactory.getLog().log(ENUMLogCategory.PROPERTYERROR_IMPL, s_currentValueExpression.getExpressionString(), null, t);
            }
            if (s_listener != null) {
                String probableExpression = null;
                if (s_currentValueExpression != null) {
                    probableExpression = s_currentValueExpression.getExpressionString();
                }
                s_listener.reactOnErrorDuringGetValue(t, base, property, probableExpression);
            }
            return null;
        }
    }

    private Object convertValueAfterGet(Object baseObject, Object property, Object result) {
        if (baseObject != null && baseObject instanceof IPropertyValueConverter) {
            result = property instanceof Integer ? ((IPropertyValueConverter)baseObject).convertObjectGet((Integer)property, result) : ((IPropertyValueConverter)baseObject).convertObjectGet(property.toString(), result);
        }
        return result;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) throws NullPointerException, PropertyNotFoundException, PropertyNotWritableException, ELException {
        try {
            if (CLog.L.isLoggable(CLog.LL_INF)) {
                CLog.L.log(CLog.LL_INF, "Setting property: " + property);
            }
            if (base != null && property != null && base instanceof IPropertyValueConverter) {
                value = property instanceof Integer ? ((IPropertyValueConverter)base).convertObject((Integer)property, value) : ((IPropertyValueConverter)base).convertObject(property, value);
                if (CLog.L.isLoggable(CLog.LL_INF)) {
                    CLog.L.log(CLog.LL_INF, "Setting property (value may have been updated): " + property + "/ value: " + value);
                }
            }
            this.m_delegateTo.setValue(context, base, property, value);
            if (base instanceof IPropertyResolverAware) {
                if (property instanceof Integer) {
                    ((IPropertyResolverAware)base).reactOnSetValue((Integer)property, value);
                } else {
                    ((IPropertyResolverAware)base).reactOnSetValue(property, value);
                }
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Error when setting property: " + base + "/" + property);
            CLog.L.log(CLog.LL_INF, "                             " + t.toString());
            if (s_currentValueExpression != null) {
                CLog.L.log(CLog.LL_INF, "                             expression is: " + s_currentValueExpression.getExpressionString());
            }
            if (s_currentValueExpression != null) {
                DTLogFactory.getLog().log(ENUMLogCategory.PROPERTYERROR_IMPL, s_currentValueExpression.getExpressionString(), null, t);
            } else {
                DTLogFactory.getLog().log(ENUMLogCategory.PROPERTYERROR_IMPL, null, null, t);
            }
            throw new Error(t);
        }
    }

    public boolean isReadOnly(ELContext arg0, Object arg1, Object arg2) throws NullPointerException, PropertyNotFoundException, ELException {
        return this.m_delegateTo.isReadOnly(arg0, arg1, arg2);
    }

    public Class<?> getCommonPropertyType(ELContext arg0, Object arg1) {
        return this.m_delegateTo.getCommonPropertyType(arg0, arg1);
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext arg0, Object arg1) {
        return this.m_delegateTo.getFeatureDescriptors(arg0, arg1);
    }

    public static void defineInstanceToBeUsed(String name, Object instance) {
        String sessionMapName = null;
        sessionMapName = TypeOfSessionMgmt.getSessionMgmtViaCookie() ? ATTRIBUTENAME + "/" + ThreadData.getInstance().getSubpageId() : ATTRIBUTENAME;
        HashMap<String, Object> map = (HashMap<String, Object>)HttpSessionAccess.getCurrentHttpSession().getAttribute(sessionMapName);
        if (map == null) {
            map = new HashMap<String, Object>();
            HttpSessionAccess.getCurrentHttpSession().setAttribute(sessionMapName, map);
        }
        map.put(name, instance);
        s_managedBeanIsResetByApplication = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerThreadWithErrorFalse() {
        Set<Thread> set = s_threadsWithErrorFalse;
        synchronized (set) {
            s_threadsWithErrorFalse.add(Thread.currentThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterThreadWithErrorFalse() {
        Set<Thread> set = s_threadsWithErrorFalse;
        synchronized (set) {
            s_threadsWithErrorFalse.remove(Thread.currentThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkIfThreandWithErrorFalse() {
        Set<Thread> set = s_threadsWithErrorFalse;
        synchronized (set) {
            return s_threadsWithErrorFalse.contains(Thread.currentThread());
        }
    }

    public static void resetBuffers() {
        Class<BeanELResolver> c = BeanELResolver.class;
        try {
            Field f = c.getDeclaredField("cache");
            f.setAccessible(true);
            Object o = f.get(s_currentBeanELResolver);
            Field mf = o.getClass().getDeclaredField("eden");
            mf.setAccessible(true);
            Map m = (Map)mf.get(o);
            m.clear();
            mf = o.getClass().getDeclaredField("longterm");
            mf.setAccessible(true);
            m = (Map)mf.get(o);
            m.clear();
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Could not reset BeanELResolver " + s_currentBeanELResolver, t);
        }
    }

    static {
        s_currentBeanELResolver = null;
        s_threadsWithErrorFalse = new HashSet<Thread>();
    }

    public static class DefaultCCELResolverListener
    implements ICCELResolverListener {
        @Override
        public void reactOnErrorDuringGetValue(Throwable t, Object base, Object property, String probableExpression) {
        }
    }

    public static interface ICCELResolverListener {
        public void reactOnErrorDuringGetValue(Throwable var1, Object var2, Object var3, String var4);
    }
}

