/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.eclnt.jsfserver.util.CCInitialize;

public abstract class CCFilterBase
implements Filter {
    static Map<Thread, List<CCFilterBase>> s_processedFiltersPerRequest = new Hashtable<Thread, List<CCFilterBase>>();

    public void init(FilterConfig filterConfig) throws ServletException {
        CCInitialize.initializeCCEnvironment(filterConfig.getServletContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean alreadyProcessed = false;
        try {
            alreadyProcessed = this.checkIfAlreadyProcessed();
            if (!alreadyProcessed) {
                this.doFilterExecute(request, response, chain);
            } else {
                chain.doFilter(request, response);
            }
        }
        finally {
            if (!alreadyProcessed) {
                this.cleanUpFilters();
            }
        }
    }

    protected abstract void doFilterExecute(ServletRequest var1, ServletResponse var2, FilterChain var3) throws IOException, ServletException;

    private void cleanUpFilters() {
        List<CCFilterBase> filters = s_processedFiltersPerRequest.get(Thread.currentThread());
        if (filters.get(0) == this) {
            s_processedFiltersPerRequest.remove(Thread.currentThread());
        }
    }

    private boolean checkIfAlreadyProcessed() {
        List<CCFilterBase> filters = s_processedFiltersPerRequest.get(Thread.currentThread());
        if (filters == null) {
            filters = new ArrayList<CCFilterBase>();
            s_processedFiltersPerRequest.put(Thread.currentThread(), filters);
        }
        if (filters.contains(this)) {
            return true;
        }
        filters.add(this);
        return false;
    }
}

