/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import java.util.HashSet;
import java.util.Set;
import org.eclnt.jsfserver.monitoring.Monitoring;
import org.eclnt.jsfserver.util.IDialogSessionListener;
import org.eclnt.jsfserver.util.ISessionAbstraction;
import org.eclnt.util.log.CLog;

public class DialogSessionListenerMgmt {
    static Set<IDialogSessionListener> s_listeners = new HashSet<IDialogSessionListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(IDialogSessionListener listener) {
        Set<IDialogSessionListener> set = s_listeners;
        synchronized (set) {
            HashSet<IDialogSessionListener> newSet = new HashSet<IDialogSessionListener>();
            newSet.addAll(s_listeners);
            newSet.add(listener);
            s_listeners = newSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(IDialogSessionListener listener) {
        Set<IDialogSessionListener> set = s_listeners;
        synchronized (set) {
            HashSet<IDialogSessionListener> newSet = new HashSet<IDialogSessionListener>();
            newSet.addAll(s_listeners);
            newSet.remove(listener);
            s_listeners = newSet;
        }
    }

    public static Set<IDialogSessionListener> getListeners() {
        return s_listeners;
    }

    public static void notifyDialogSessionCreated(ISessionAbstraction session) {
        Set<IDialogSessionListener> usedSet = s_listeners;
        for (IDialogSessionListener listener : usedSet) {
            try {
                listener.reactOnDialogSessionCreated(session);
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_ERR, "Problem in listener", t);
            }
        }
        Monitoring.increaseNumberOfSessions();
    }

    public static void notifyDialogSessionClosed(ISessionAbstraction session) {
        Set<IDialogSessionListener> usedSet = s_listeners;
        for (IDialogSessionListener listener : usedSet) {
            try {
                listener.reactOnDialogSessionClosed(session);
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_ERR, "Problem in listener", t);
            }
        }
        Monitoring.decreaseNumberOfSessions();
    }
}

