/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.eclnt.jsfserver.util.ServletUtil;

public class RemoveBorderRadiusCssFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String requestURI = httpRequest.getRequestURI();
        String cookieValue = ServletUtil.readCookieValuesFromRequest(httpRequest).get("ccsuppressborderradius");
        if ("true".equals(cookieValue) && requestURI.contains(".css")) {
            HttpServletRequestWrapper wrappedRequest = new HttpServletRequestWrapper(httpRequest){

                public String getHeader(String name) {
                    if ("Accept-Encoding".equalsIgnoreCase(name)) {
                        return null;
                    }
                    return super.getHeader(name);
                }
            };
            ResponseWrapper responseWrapper = new ResponseWrapper((HttpServletResponse)response);
            chain.doFilter((ServletRequest)wrappedRequest, (ServletResponse)responseWrapper);
            byte[] originalContent = responseWrapper.getContent();
            String contentStr = new String(originalContent, StandardCharsets.UTF_8);
            String modifiedContent = contentStr.replace("border-radius", "xxxborder-radius");
            byte[] modifiedBytes = modifiedContent.getBytes(StandardCharsets.UTF_8);
            ServletUtil.setResponseContentType((HttpServletResponse)responseWrapper, "text/css; charset=UTF-8");
            response.setContentLength(modifiedBytes.length);
            response.getOutputStream().write(modifiedBytes);
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    private static class ResponseWrapper
    extends HttpServletResponseWrapper {
        private ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        private ServletOutputStream outputStream;
        private PrintWriter writer;

        public ResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (this.outputStream == null) {
                this.outputStream = new ServletOutputStream(){

                    public void write(int b) throws IOException {
                        ResponseWrapper.this.byteStream.write(b);
                    }

                    public boolean isReady() {
                        return true;
                    }

                    public void setWriteListener(WriteListener listener) {
                    }
                };
            }
            return this.outputStream;
        }

        public PrintWriter getWriter() throws IOException {
            if (this.writer == null) {
                this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.getOutputStream(), StandardCharsets.UTF_8));
            }
            return this.writer;
        }

        public byte[] getContent() throws IOException {
            if (this.writer != null) {
                this.writer.flush();
            }
            if (this.outputStream != null) {
                this.outputStream.flush();
            }
            return this.byteStream.toByteArray();
        }
    }
}

