/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import java.util.Enumeration;
import javax.servlet.http.HttpSession;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.HttpSessionListenerDelegator;
import org.eclnt.jsfserver.util.IHttpSessionClosedReactor;
import org.eclnt.jsfserver.util.ISessionAbstraction;
import org.eclnt.jsfserver.util.ISessionAbstractionListener;
import org.eclnt.jsfserver.util.ServletUtil;
import org.eclnt.util.valuemgmt.UniqueIdCreator;

public class SessionAbstractionHttpSession
implements ISessionAbstraction {
    HttpSession m_session;
    HttpSessionListenerDelegator m_delegator;

    public SessionAbstractionHttpSession(HttpSession session) {
        this.m_session = session;
        if (session != null) {
            this.m_delegator = HttpSessionAccess.getCurrentHttpSessionListenerDelegator(session);
        }
    }

    @Override
    public void setAttribute(String name, Object value) {
        ServletUtil.setSessionAttributeWithTrustedName(this.m_session, name, value);
    }

    public HttpSession getSession() {
        return this.m_session;
    }

    @Override
    public String getId() {
        return this.m_session.getId();
    }

    @Override
    public Object getAttribute(String name) {
        return this.m_session.getAttribute(name);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return this.m_session.getAttributeNames();
    }

    @Override
    public void removeAttribute(String name) {
        this.m_session.removeAttribute(name);
    }

    @Override
    public void invalidate() {
        this.m_session.invalidate();
        this.m_delegator = null;
    }

    @Override
    public void addListener(ISessionAbstractionListener listener) {
        if (this.m_delegator == null) {
            return;
        }
        for (IHttpSessionClosedReactor reactor : this.m_delegator.getReactors()) {
            if (!(reactor instanceof ListenerDelegator)) continue;
            ListenerDelegator ldReactor = (ListenerDelegator)reactor;
            if (ldReactor.i_delegateTo != listener) continue;
            return;
        }
        ListenerDelegator ld = new ListenerDelegator(listener);
        this.m_delegator.addReactor(ld.i_id, ld);
    }

    @Override
    public void removeListener(ISessionAbstractionListener listener) {
        if (this.m_delegator == null) {
            return;
        }
        for (IHttpSessionClosedReactor reactor : this.m_delegator.getReactors()) {
            if (!(reactor instanceof ListenerDelegator)) continue;
            ListenerDelegator ldReactor = (ListenerDelegator)reactor;
            if (ldReactor.i_delegateTo != listener) continue;
            this.m_delegator.removeReactor(ldReactor.i_id);
            return;
        }
    }

    class ListenerDelegator
    implements IHttpSessionClosedReactor {
        ISessionAbstractionListener i_delegateTo;
        String i_id;

        public ListenerDelegator(ISessionAbstractionListener delegateTo) {
            this.i_delegateTo = delegateTo;
            this.i_id = UniqueIdCreator.createUUID();
        }

        @Override
        public void reactOnClosed() {
            this.i_delegateTo.reactOnClosed();
        }
    }
}

