/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.eclnt.jsfserver.messages.DialogMessageBus;
import org.eclnt.jsfserver.util.DialogSessionListenerMgmt;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.ISessionAbstraction;
import org.eclnt.jsfserver.util.ServletUtil;
import org.eclnt.jsfserver.util.SessionAbstractionSubpageContext;
import org.eclnt.jsfserver.util.ThreadingSynchronization;
import org.eclnt.jsfserver.util.TypeOfSessionMgmt;
import org.eclnt.util.log.CLog;

public class SubpageContext {
    boolean m_invalidated = false;
    String m_subPageId;
    Map<String, Object> m_data = new HashMap<String, Object>();
    Set<IListener> m_listeners = new HashSet<IListener>();
    SessionAbstractionSubpageContext m_sessionAbstraction;

    public static SubpageContext pickOrCreateSubpageContext(HttpSession session, String subpageId) {
        SubpageContext result = (SubpageContext)session.getAttribute(SubpageContext.class.getName() + "/" + subpageId);
        if (result == null) {
            result = new SubpageContext(session, subpageId);
        }
        return result;
    }

    public static SubpageContext getSubpageContext(HttpSession session, String subpageId) {
        SubpageContext result = (SubpageContext)session.getAttribute(SubpageContext.class.getName() + "/" + subpageId);
        return result;
    }

    public static SubpageContext getSubpageContext(ISessionAbstraction session, String subpageId) {
        SubpageContext result = (SubpageContext)session.getAttribute(SubpageContext.class.getName() + "/" + subpageId);
        return result;
    }

    public SubpageContext(HttpSession session, String subpageId) {
        this.m_subPageId = subpageId;
        ServletUtil.setSessionAttributeWithTrustedName(session, SubpageContext.class.getName() + "/" + subpageId, this);
        this.m_sessionAbstraction = new SessionAbstractionSubpageContext(this);
        if (TypeOfSessionMgmt.getSessionMgmtViaCookie(session)) {
            DialogSessionListenerMgmt.notifyDialogSessionCreated(this.m_sessionAbstraction);
        }
    }

    public static List<SubpageContext> findAllSubpageContextInSession(HttpSession session) {
        ArrayList<SubpageContext> result = new ArrayList<SubpageContext>();
        String prefix = SubpageContext.class.getName() + "/";
        Enumeration attributeNames = session.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attributeName = (String)attributeNames.nextElement();
            if (!attributeName.startsWith(prefix)) continue;
            SubpageContext spc = (SubpageContext)session.getAttribute(attributeName);
            result.add(spc);
        }
        return result;
    }

    public static int getNumberOfSubContextsInHttpSession(HttpSession session) {
        int result = 0;
        Enumeration names = session.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.startsWith(SubpageContext.class.getName() + "/")) continue;
            ++result;
        }
        return result;
    }

    public String getSubPageId() {
        return this.m_subPageId;
    }

    public Set<IListener> getListeners() {
        return this.m_listeners;
    }

    public void addListener(IListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeListener(IListener listener) {
        this.m_listeners.remove(listener);
    }

    public void invalidate() {
        this.invalidate(true);
    }

    public synchronized void invalidate(boolean withClosingSessionIfRequired) {
        if (this.m_invalidated) {
            return;
        }
        if (TypeOfSessionMgmt.getSessionMgmtViaCookie()) {
            DialogSessionListenerMgmt.notifyDialogSessionClosed(this.m_sessionAbstraction);
        }
        ArrayList<IListener> clonedListenersList = new ArrayList<IListener>(this.m_listeners);
        for (IListener listener : clonedListenersList) {
            try {
                listener.reactOnClosed();
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_INF, "Problem when invalidating subsession, listener threw Exception", t);
            }
        }
        HttpSession session = null;
        try {
            session = HttpSessionAccess.getCurrentHttpSession();
            session.removeAttribute(SubpageContext.class.getName() + "/" + this.m_subPageId);
        }
        catch (Throwable listener) {
            // empty catch block
        }
        if (session != null) {
            this.cleanUpSubpageContextRegistrationsInHttpSession(session);
        }
        ThreadingSynchronization.instance().unregisterDialogSession(this.m_subPageId);
        try {
            DialogMessageBus dmb = DialogMessageBus.instance(session, new SessionAbstractionSubpageContext(this), false);
            if (dmb != null) {
                dmb.destroy();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.m_invalidated = true;
        this.m_data.clear();
        this.m_listeners.clear();
        this.m_subPageId = null;
    }

    public boolean isInvalidated() {
        return this.m_invalidated;
    }

    public Object getAttribute(String attribute) {
        return this.m_data.get(attribute);
    }

    public void setAttribute(String attribute, Object value) {
        this.m_data.put(attribute, value);
    }

    public void removeAttribute(String attribute) {
        this.m_data.remove(attribute);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.m_data.keySet());
    }

    public ISessionAbstraction getSessionAbstraction() {
        return this.m_sessionAbstraction;
    }

    private void cleanUpSubpageContextRegistrationsInHttpSession(HttpSession session) {
        try {
            if (session == null) {
                return;
            }
            HashSet<String> names4Removal = new HashSet<String>();
            Enumeration attributeNames = session.getAttributeNames();
            while (attributeNames.hasMoreElements()) {
                String attributeName = (String)attributeNames.nextElement();
                if (attributeName.endsWith(this.m_subPageId)) {
                    names4Removal.add(attributeName);
                    continue;
                }
                if (!attributeName.startsWith(this.m_subPageId)) continue;
                names4Removal.add(attributeName);
            }
            for (String name : names4Removal) {
                session.removeAttribute(name);
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_DBG, "Problem when cleaning up supbageContext content in http-session, " + this.m_subPageId + ", " + t.toString());
        }
    }

    public static interface IListener {
        public void reactOnClosed();
    }
}

