/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.tool;

import java.util.Stack;
import org.eclnt.tool.BuildCSSViaXML;
import org.eclnt.tool.CSSStyle;
import org.eclnt.tool.CSSStyleClass;
import org.eclnt.tool.CSSStyleClassRISCInfo;
import org.eclnt.tool.CSSStyleClassStyle;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CSSParser
extends DefaultHandler {
    CSSStyle m_style;
    Stack<CSSStyleClass> m_currentStyleClasses = new Stack();
    Boolean m_conditionEdged = null;
    Boolean m_conditionRounded = null;

    public CSSParser(CSSStyle style) {
        this.m_style = style;
    }

    public void setConditionEdged(boolean edged) {
        this.m_conditionEdged = edged;
    }

    public void setConditionRounded(boolean rounded) {
        this.m_conditionRounded = rounded;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if ("class".equals(name)) {
            CSSStyleClass sc = new CSSStyleClass();
            if ("true".equals(attributes.getValue("internal"))) {
                sc.setInternal(true);
            }
            if ("true".equals(attributes.getValue("directcss"))) {
                sc.setDirectcss(true);
            }
            sc.setName(attributes.getValue("n"));
            if (sc.getName() == null) {
                throw new Error("Missing n-definition in class: <class n=\"xxx\" v=\"xxx\"...>...</class>");
            }
            sc.setExtends(attributes.getValue("extends"));
            if (this.currentStyleClass() != null) {
                this.currentStyleClass().addSubClass(sc);
                if (sc.getExtends() == null) {
                    int extendIndex = -1;
                    for (int i = this.m_currentStyleClasses.size() - 1; i >= 0; --i) {
                        if (((CSSStyleClass)this.m_currentStyleClasses.get(i)).getExtends() == null) continue;
                        extendIndex = i;
                        break;
                    }
                    if (extendIndex >= 0) {
                        String ext = "";
                        ext = ext + ((CSSStyleClass)this.m_currentStyleClasses.get(extendIndex)).getExtends() + "-->";
                        for (int i = extendIndex + 1; i < this.m_currentStyleClasses.size(); ++i) {
                            ext = ext + ((CSSStyleClass)this.m_currentStyleClasses.get(i)).getName();
                        }
                        ext = ext + sc.getName();
                        sc.setExtends(ext);
                    }
                }
            } else {
                if (sc.getName().startsWith(".")) {
                    throw new Error("top class definition must not start with dot \",\" : " + sc.getName());
                }
                this.m_style.addStyleClass(sc);
            }
            this.m_currentStyleClasses.push(sc);
        } else {
            boolean toBeProcessed = true;
            String condition = attributes.getValue("condition");
            if (condition != null) {
                if (this.m_conditionEdged != null && this.m_conditionEdged.booleanValue() && "@edged@".equals(condition)) {
                    toBeProcessed = true;
                } else if (this.m_conditionRounded != null && this.m_conditionRounded.booleanValue() && "@rounded@".equals(condition)) {
                    toBeProcessed = true;
                } else {
                    String conditionValue = BuildCSSViaXML.s_variables.get(condition);
                    toBeProcessed = "true".equals(conditionValue);
                }
            }
            if (toBeProcessed) {
                if ("risc".equals(name)) {
                    CSSStyleClassRISCInfo ri = new CSSStyleClassRISCInfo();
                    ri.m_name = attributes.getValue("n");
                    ri.m_value = attributes.getValue("v");
                    if (ri.m_name == null) {
                        throw new Error("Missing risc n-definition");
                    }
                    if (ri.m_value == null) {
                        throw new Error("Missing risc v-definition");
                    }
                    this.currentStyleClass().addRISCInfo(ri);
                } else if ("style".equals(name)) {
                    CSSStyleClassStyle si = new CSSStyleClassStyle();
                    si.m_name = attributes.getValue("n");
                    si.m_value = attributes.getValue("v");
                    if (si.m_name == null) {
                        throw new Error("Missing style n-definition");
                    }
                    if (si.m_value == null) {
                        throw new Error("Missing Style v-definition");
                    }
                    this.currentStyleClass().addStyle(si);
                } else if ("var".equals(name)) {
                    String n = attributes.getValue("n");
                    String v = attributes.getValue("v");
                    if (n == null) {
                        throw new Error("Missing var n-definition");
                    }
                    if (v == null) {
                        throw new Error("Missing var v-definition");
                    }
                    if (!n.startsWith("@")) {
                        throw new Error("var definition must start with @: " + n);
                    }
                    if (!n.endsWith("@")) {
                        throw new Error("var definition must end with @: " + n);
                    }
                    if (this.currentStyleClass() != null) {
                        this.currentStyleClass().addVariableValue(n, v);
                    } else {
                        this.m_style.addVariableValue(n, v);
                        String c = attributes.getValue("c");
                        if (c != null) {
                            this.m_style.addVariableCategory(n, c);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if ("class".equals(name)) {
            this.m_currentStyleClasses.pop();
        }
    }

    private CSSStyleClass currentStyleClass() {
        if (this.m_currentStyleClasses.isEmpty()) {
            return null;
        }
        return this.m_currentStyleClasses.peek();
    }
}

