/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.file;

import java.io.File;
import java.util.List;
import java.util.Set;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.valuemgmt.ValueManager;

public class DirectoryStampMgmt {
    public static long createStampForDirectory(String directory) {
        return DirectoryStampMgmt.createStampForDirectory(directory, null, 0L);
    }

    public static long createStampForDirectory(String directory, Set<String> ignoreNames) {
        return DirectoryStampMgmt.createStampForDirectory(directory, ignoreNames, 0L);
    }

    private static long createStampForDirectory(String directory, Set<String> ignoreNames, long currentStamp) {
        directory = ValueManager.encodeIntoValidFileName(directory, true);
        List<File> dirs = FileManager.getDirectoriesOfDirectory(directory);
        for (File dir : dirs) {
            StringBuffer sb = new StringBuffer();
            sb.append(dir.getName());
            if (!DirectoryStampMgmt.checkIfNameIsAccepted(dir, ignoreNames)) continue;
            currentStamp += (long)sb.toString().hashCode();
            currentStamp = DirectoryStampMgmt.createStampForDirectory(dir.getAbsolutePath(), ignoreNames, currentStamp);
        }
        List<File> files = FileManager.getFilesOfDirectory(directory);
        for (File file : files) {
            StringBuffer sb = new StringBuffer();
            if (!DirectoryStampMgmt.checkIfNameIsAccepted(file, ignoreNames)) continue;
            sb.append(file.getName());
            sb.append(file.lastModified());
            sb.append(file.length());
            currentStamp += (long)sb.toString().hashCode();
        }
        return currentStamp;
    }

    private static boolean checkIfNameIsAccepted(File dir, Set<String> ignoreNames) {
        if (ignoreNames == null) {
            return true;
        }
        for (String ignoreName : ignoreNames) {
            if (!ValueManager.checkIfStringMatchesAsteriskExpression(dir.getName(), ignoreName)) continue;
            return false;
        }
        return true;
    }
}

