/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.file;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.log.IObserver;
import org.eclnt.util.valuemgmt.ValueManager;

public class FileCrawler {
    static FileCrawler s_instance = new FileCrawler();

    public static FileCrawler instance() {
        return s_instance;
    }

    public CrawlResult crawl(List<String> directories, List<String> searchTexts, List<String> fileNameFilters, IObserver observer) {
        CrawlResult result = new CrawlResult();
        for (String directory : directories) {
            this.crawlDirectory(new File(directory), searchTexts, fileNameFilters, observer, result);
        }
        return result;
    }

    private void crawlDirectory(File directory, List<String> searchTexts, List<String> fileNameFilters, IObserver observer, CrawlResult result) {
        if (observer != null) {
            observer.addMessage("Directory: " + directory.getAbsolutePath());
        }
        List<File> files = FileManager.getFilesOfDirectory(directory.getAbsolutePath());
        for (File file : files) {
            CrawlResultItem cri;
            if (!this.checkIfFileMatchesFileNameFilters(file, fileNameFilters) || (cri = this.crawlFile(file, searchTexts)) == null) continue;
            result.getItems().add(cri);
        }
        List<File> subDirs = FileManager.getDirectoriesOfDirectory(directory.getAbsolutePath());
        for (File subDir : subDirs) {
            this.crawlDirectory(subDir, searchTexts, fileNameFilters, observer, result);
        }
    }

    private CrawlResultItem crawlFile(File file, List<String> searchTexts) {
        try {
            CrawlResultItem result = new CrawlResultItem(file);
            String content = FileManager.readUTF8File(file.getAbsolutePath(), true);
            for (String searchText : searchTexts) {
                if (searchText == null || searchText.length() == 0) {
                    throw new Error("searchText must not be null and must have a length of 0: " + searchText);
                }
                int index = 0;
                while ((index = content.indexOf(searchText, index)) >= 0) {
                    result.getMatchingSearchTexts().add(searchText);
                    String occurance = this.isolateOccurance(content, searchText, index);
                    result.getOccurances().add(occurance);
                    index += searchText.length();
                }
            }
            if (result.getMatchingSearchTexts().size() > 0) {
                return result;
            }
            return null;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private String isolateOccurance(String content, String searchText, int index) {
        int index1 = index - 50;
        int index2 = index + searchText.length() + 50;
        if (index1 < 0) {
            index1 = 0;
        }
        if (index2 > content.length()) {
            index2 = content.length();
        }
        String result = content.substring(index1, index) + ">>>>>" + searchText + "<<<<<" + content.substring(index + searchText.length(), index2);
        result = result.replace("\n", "");
        result = result.replace("\r", "");
        result = result.replace("\t", "");
        return result;
    }

    private boolean checkIfFileMatchesFileNameFilters(File file, List<String> fileNameFilters) {
        if (fileNameFilters == null || fileNameFilters.size() == 0) {
            return true;
        }
        String fileName = file.getName();
        for (String filter : fileNameFilters) {
            if (!ValueManager.checkIfStringMatchesAsteriskExpression(fileName, filter, true)) continue;
            return true;
        }
        return false;
    }

    public static class CrawlResultItem {
        File i_file;
        List<String> i_matchingSearchTexts = new ArrayList<String>();
        List<String> i_occurances = new ArrayList<String>();

        public CrawlResultItem(File file) {
            this.i_file = file;
        }

        public List<String> getMatchingSearchTexts() {
            return this.i_matchingSearchTexts;
        }

        public List<String> getOccurances() {
            return this.i_occurances;
        }

        public File getFile() {
            return this.i_file;
        }
    }

    public static class CrawlResult {
        List<CrawlResultItem> i_items = new ArrayList<CrawlResultItem>(0);

        public List<CrawlResultItem> getItems() {
            return this.i_items;
        }
    }
}

