/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.image;

import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.formats.jpeg.JpegImageMetadata;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.constants.TiffTagConstants;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;
import org.eclnt.util.valuemgmt.ValueManager;

public class ImageExifReader {
    public static boolean checkIfImageIsRotated(byte[] imageBytes) {
        try {
            JpegImageMetadata jpegMetadata;
            String orientation;
            int orientationInt;
            ImageMetadata metadata = Imaging.getMetadata((byte[])imageBytes);
            if (metadata instanceof JpegImageMetadata && (orientationInt = ValueManager.decodeInt(orientation = ImageExifReader.getTagValue(jpegMetadata = (JpegImageMetadata)metadata, (TagInfo)TiffTagConstants.TIFF_TAG_ORIENTATION), -1)) >= 5 && orientationInt <= 8) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static String getTagValue(JpegImageMetadata jpegMetadata, TagInfo tagInfo) {
        TiffField field = jpegMetadata.findEXIFValueWithExactMatch(tagInfo);
        if (field == null) {
            return null;
        }
        return field.getValueDescription();
    }
}

