/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.workplace;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import org.eclnt.jsfserver.streamstore.IStreamStore;
import org.eclnt.jsfserver.streamstore.StreamStore;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;
import org.eclnt.workplace.WorkpageStartInfo;
import org.eclnt.workplace.WorkplaceTileInfo;
import org.eclnt.workplace.WorkplaceTileInfoPageContainer;
import org.eclnt.workplace.WorkplaceTileInfoSplitPane;

public class WorkplaceViewManager {
    public static List<String> getAvailableTileInfos() {
        IStreamStore streamStore = StreamStore.getInstance();
        List<String> names = streamStore.getContainedStreams("ccworkplace/perspectives/", false);
        ArrayList<String> result = new ArrayList<String>();
        for (String name : names) {
            result.add(name.substring(0, name.length() - 4));
        }
        return result;
    }

    public static List<String> getAvailalablePersonalTileInfos(String user) {
        IStreamStore streamStore = StreamStore.getInstance();
        List<String> names = streamStore.getContainedStreams("ccworkplace/perspectives/" + user + "/", false);
        ArrayList<String> result = new ArrayList<String>();
        for (String name : names) {
            result.add(user + "/" + name.substring(0, name.length() - 4));
        }
        return result;
    }

    public static WorkplaceTileInfo loadPersonalTileInfo(String user, String perspective) {
        return WorkplaceViewManager.loadTileInfo(user + "/" + perspective);
    }

    public static WorkplaceTileInfo loadTileInfo(String perspective) {
        try {
            IStreamStore streamStore = StreamStore.getInstance();
            String xml = streamStore.readUTF8("ccworkplace/perspectives/" + perspective + ".xml", true);
            return WorkplaceViewManager.unmarshalTileInfo(xml);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Could not read perspective: " + perspective, t);
            return null;
        }
    }

    public static WorkplaceTileInfo unmarshalTileInfo(String xml) {
        try {
            Source r = ValueManager.convertStringIntoXMLSource(xml);
            JAXBContext jbContext = JAXBContext.newInstance((Class[])new Class[]{WorkplaceTileInfo.class});
            Unmarshaller um = jbContext.createUnmarshaller();
            WorkplaceTileInfo result = (WorkplaceTileInfo)um.unmarshal(r);
            return result;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Could not unmarshal xml: " + xml, t);
            throw new Error(t);
        }
    }

    public static void storePersonalTileInfo(WorkplaceTileInfo tileInfo, String user, String name) {
        WorkplaceViewManager.storeTileInfo(tileInfo, user + "/" + name);
    }

    public static void storeTileInfo(WorkplaceTileInfo tileInfo, String perspective) {
        try {
            IStreamStore streamStore = StreamStore.getInstance();
            String xml = WorkplaceViewManager.marshalTileInfo(tileInfo);
            String fileName = "ccworkplace/perspectives/" + perspective + ".xml";
            streamStore.writeUTF8(fileName, xml, true);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Could not store perspective: " + perspective, t);
        }
    }

    public static void removePersonalTileInfo(String user, String name) {
        WorkplaceViewManager.removeTileInfo(user + "/" + name);
    }

    public static void removeTileInfo(String perspective) {
        try {
            IStreamStore streamStore = StreamStore.getInstance();
            String fileName = "ccworkplace/perspectives/" + perspective + ".xml";
            streamStore.removeStream(fileName, true);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Could not remove perspective: " + perspective, t);
        }
    }

    public static String marshalTileInfo(WorkplaceTileInfo tileInfo) {
        try {
            JAXBContext jbContext = JAXBContext.newInstance((Class[])new Class[]{WorkplaceTileInfo.class});
            Marshaller m = jbContext.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.setProperty("jaxb.encoding", (Object)"UTF-8");
            StringWriter writer = new StringWriter();
            m.marshal((Object)tileInfo, (Writer)writer);
            String result = ((Object)writer).toString();
            return result;
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }

    public static void main(String[] args) {
        WorkplaceTileInfo wti = new WorkplaceTileInfo();
        WorkplaceTileInfoPageContainer pc = new WorkplaceTileInfoPageContainer();
        pc.setId(null);
        wti.setContainer(pc);
        String result = WorkplaceViewManager.marshalTileInfo(wti);
        System.out.println(result);
        System.out.println("------------------------");
        wti = new WorkplaceTileInfo();
        WorkplaceTileInfoSplitPane split = new WorkplaceTileInfoSplitPane();
        wti.setSplit(split);
        split.setDividerLocation("200");
        WorkplaceTileInfoPageContainer pc1 = new WorkplaceTileInfoPageContainer();
        split.setSubContainer1(pc1);
        pc1.setId("FUNCTIONS");
        WorkplaceTileInfoPageContainer pc2 = new WorkplaceTileInfoPageContainer();
        split.setSubContainer2(pc2);
        pc2.setId(null);
        WorkpageStartInfo wpsi = new WorkpageStartInfo();
        wpsi.setJspPage("/workplace/wpfunctiontrees.jsp");
        wpsi.setId("wpfunctionbar");
        wpsi.setOpenMultipleInstances(false);
        wpsi.setDecorated(false);
        wpsi.setCloseSupported(false);
        wpsi.setPopupSupported(false);
        wpsi.setText("Functions");
        wpsi.setStartSubWorkpageContainerId("FUNCTIONS");
        wti.getStartViews().add(wpsi);
        String result2 = WorkplaceViewManager.marshalTileInfo(wti);
        System.out.println(result2);
        System.out.println("------------------------");
    }
}

