/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.workplace.eximport;

import org.eclnt.jsfserver.pagebean.IPageBean;
import org.eclnt.jsfserver.state.IStateMgmt;
import org.eclnt.workplace.IWorkpage;
import org.eclnt.workplace.IWorkpageStartInfo;
import org.eclnt.workplace.WorkpageStartInfo;
import org.eclnt.workplace.eximport.WorkpageStartInfoExtensionAdapter;

public class WorkplacePageBeanStateExtractor {
    public static final String PARAM_EXTRACTEDSTATE = "ccExtractedState";
    private static WorkplacePageBeanStateExtractor s_instance = new WorkplacePageBeanStateExtractor();

    public static void initialize(WorkplacePageBeanStateExtractor instance) {
        s_instance = instance;
    }

    public static WorkplacePageBeanStateExtractor instance() {
        return s_instance;
    }

    public WorkpageStartInfo extractWorkpageStartInfo(IPageBean pageBean) {
        if (pageBean == null) {
            throw new Error("No page bean passed to extract state from");
        }
        WorkpageStartInfo result = new WorkpageStartInfo();
        result.setPageBeanName(this.extractPageBeanName(pageBean));
        result.setId(result.getPageBeanName());
        if (pageBean instanceof IStateMgmt) {
            String extractedState = ((IStateMgmt)((Object)pageBean)).extractState();
            result.setParam(PARAM_EXTRACTEDSTATE, extractedState);
        }
        return result;
    }

    public WorkpageStartInfo extractWorkpageStartInfo(IWorkpage workpage) {
        Object pageBean;
        if (workpage == null) {
            throw new Error("No page bean passed to extract state from");
        }
        WorkpageStartInfo result = new WorkpageStartInfo();
        IWorkpageStartInfo wpsi = workpage.getWorkpageStartInfo();
        if (wpsi != null) {
            if (wpsi instanceof WorkpageStartInfo) {
                wpsi = WorkpageStartInfoExtensionAdapter.instance().transferExtensionIntoDefault((WorkpageStartInfo)wpsi);
                result = ((WorkpageStartInfo)wpsi).createClone();
            } else {
                result = new WorkpageStartInfo();
                result.setJspPage(wpsi.getJspPage());
                result.setPageBeanName(wpsi.getPageBeanName());
            }
        } else {
            result = new WorkpageStartInfo();
        }
        result.setId(workpage.getId());
        result.setText(workpage.getTitle());
        result.setSelectorTitle(workpage.getSelectorTitle());
        result.setCloseSupported(workpage.isCloseSupported());
        result.setPopupSupported(workpage.isPopupSupported());
        result.setSelectorBgpaint(workpage.getSelectorBgpaint());
        result.setImage(workpage.getIconURL());
        result.setDecorated(workpage.isDecorated());
        result.setStartSubWorkpageContainerId(workpage.getWorkpageContainer().getSubWorkpageContainerIdForWorkpage(workpage));
        boolean parametersRead = false;
        if (result.getPageBeanName() != null && (pageBean = workpage.getDispatcher().getDispatchedBean(result.getPageBeanName())) != null && pageBean instanceof IStateMgmt) {
            String extractedState = ((IStateMgmt)pageBean).extractState();
            result.setParam(PARAM_EXTRACTEDSTATE, extractedState);
            parametersRead = true;
        }
        if (!parametersRead && wpsi != null) {
            result.getParamMap().putAll(wpsi.getParamMap());
        }
        return result;
    }

    public void applyStateIntoPageBean(IPageBean pageBean, WorkpageStartInfo wpsi) {
        if (pageBean == null) {
            return;
        }
        if (!(pageBean instanceof IStateMgmt)) {
            return;
        }
        if (wpsi == null) {
            return;
        }
        String state = wpsi.getParam(PARAM_EXTRACTEDSTATE);
        if (state == null) {
            return;
        }
        ((IStateMgmt)((Object)pageBean)).applyState(state);
    }

    private String extractPageBeanName(IPageBean pageBean) {
        return pageBean.getClass().getSimpleName();
    }
}

