/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.workplace.wfinbox;

import java.io.Serializable;
import java.util.List;
import javax.faces.event.ActionEvent;
import org.eclnt.jsfserver.defaultscreens.ISetId;
import org.eclnt.jsfserver.defaultscreens.IdTextSelection;
import org.eclnt.jsfserver.defaultscreens.ModelessPopup;
import org.eclnt.workplace.IWorkpageDispatcher;
import org.eclnt.workplace.WorkpageDispatchedPageBean;
import org.eclnt.workplace.wfinbox.WFDummyManager;
import org.eclnt.workplace.wfinbox.WFManagerFactory;
import org.eclnt.workplace.wfinbox.WorkItem;

public class WFDelegateUI
extends WorkpageDispatchedPageBean
implements Serializable {
    IListener m_listener;
    WorkItem m_workItem;
    protected String m_comment;
    protected String m_toUser;
    protected ModelessPopup m_popup;

    public WFDelegateUI(IWorkpageDispatcher dispatcher) {
        super(dispatcher);
        this.m_workItem = WFDummyManager.createDummyWorkItemDetail().getWorkItem();
        this.construct();
    }

    public WFDelegateUI(IWorkpageDispatcher dispatcher, WorkItem wi, IListener listener) {
        super(dispatcher);
        this.m_workItem = wi;
        this.m_listener = listener;
        this.construct();
    }

    private void construct() {
        this.m_toUser = this.m_workItem.getAssignedUser();
        this.m_comment = this.m_workItem.getComment();
    }

    @Override
    public String getPageName() {
        return "/eclntjsfserver/includes/wfdelegate.jsp";
    }

    @Override
    public String getRootExpressionUsedInPage() {
        return "#{WFDelegateUI}";
    }

    public String getComment() {
        return this.m_comment;
    }

    public void setComment(String value) {
        this.m_comment = value;
    }

    public String getToUser() {
        return this.m_toUser;
    }

    public void setToUser(String value) {
        this.m_toUser = value;
    }

    public void onToUserAction(ActionEvent event) {
        List<String> users = WFManagerFactory.getInstance().readUserNamesForDelegation(this.m_workItem);
        IdTextSelection idts = IdTextSelection.createInstance();
        for (String user : users) {
            idts.addLine(user, user);
        }
        idts.setCallBack(new ISetId(){

            @Override
            public void setId(String id) {
                WFDelegateUI.this.m_toUser = id;
            }
        });
        idts.setRenderIdColumn(false);
    }

    public void onDelegateAction(ActionEvent event) {
        if (this.m_listener != null) {
            this.m_listener.reactOnDelegate(this.m_toUser, this.m_comment);
        }
    }

    public void onCancelAction(ActionEvent event) {
        if (this.m_listener != null) {
            this.m_listener.reactOnCancel();
        }
    }

    public static interface IListener {
        public void reactOnDelegate(String var1, String var2);

        public void reactOnCancel();
    }
}

