/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclnt.util.valuemgmt.PojoManager;
import org.junit.Assert;
import org.junit.Test;

public class TestPojoManager {
    @Test
    public void testSimpleSetGet() {
        try {
            TestBean b = new TestBean();
            PojoManager.setPropertyValue(b, "name1", "Harry");
            Assert.assertEquals((Object)"Harry", (Object)b.getName1());
            Assert.assertEquals((Object)"Harry", (Object)PojoManager.getPropertyValue(b, "name1"));
            PojoManager.setPropertyValue(b, "int2", 2);
            Assert.assertEquals((long)2L, (long)b.getInt2());
            Assert.assertEquals((Object)2, (Object)PojoManager.getPropertyValue(b, "int2"));
            System.out.println("FINISHED");
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)t.getMessage());
        }
    }

    @Test
    public void testBeanToMap() {
        try {
            TestBean b = new TestBean();
            Map<String, Object> m = PojoManager.transferPojoIntoMap(b);
            Assert.assertEquals((long)4L, (long)m.size());
            Assert.assertEquals((Object)"Name1", (Object)m.get("name1"));
            Assert.assertEquals((Object)2, (Object)m.get("int2"));
            System.out.println("Finished");
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)t.getMessage());
        }
    }

    @Test
    public void testBeanHashCode() {
        try {
            String s1 = null;
            String s2 = null;
            String s3 = null;
            TestBean b = new TestBean();
            b.setInt2(100);
            b.setName1("AAA");
            b.setName2("BBB");
            s1 = PojoManager.calculateHashForPojo(b);
            b = new TestBean();
            b.setInt2(100);
            b.setName1("AAA");
            b.setName2("BBB");
            s2 = PojoManager.calculateHashForPojo(b);
            b = new TestBean();
            b.setInt2(100);
            b.setName1("AAA1");
            b.setName2("BBB");
            s3 = PojoManager.calculateHashForPojo(b);
            System.out.println(s1 + "/" + s2 + "/" + s3);
            Assert.assertEquals((Object)s1, (Object)s2);
            Assert.assertNotEquals((Object)s1, (Object)s3);
            System.out.println("Finished");
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)t.getMessage());
        }
    }

    @Test
    public void testBeanWithListHashCode() {
        try {
            TestBean b;
            int i;
            String s1 = null;
            String s2 = null;
            String s3 = null;
            TestBeanWithList bl = new TestBeanWithList();
            for (i = 0; i < 10; ++i) {
                b = new TestBean();
                b.setInt2(100);
                b.setName1("AAA");
                b.setName2("BBB");
                bl.getBeans().add(b);
            }
            s1 = PojoManager.calculateHashForPojo(bl, true);
            bl = new TestBeanWithList();
            for (i = 0; i < 10; ++i) {
                b = new TestBean();
                b.setInt2(100);
                b.setName1("AAA");
                b.setName2("BBB");
                bl.getBeans().add(b);
            }
            s2 = PojoManager.calculateHashForPojo(bl, true);
            bl = new TestBeanWithList();
            for (i = 0; i < 11; ++i) {
                b = new TestBean();
                b.setInt2(100);
                b.setName1("AAA");
                b.setName2("BBB");
                bl.getBeans().add(b);
            }
            s3 = PojoManager.calculateHashForPojo(bl, true);
            System.out.println(s1 + "/" + s2 + "/" + s3);
            Assert.assertEquals((Object)s1, (Object)s2);
            Assert.assertNotEquals((String)s1, (Object)s2, (Object)s3);
            System.out.println("Finished");
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)t.getMessage());
        }
    }

    @Test
    public void testBeanTransferWithChecker() {
        try {
            TestBean b1 = new TestBean();
            b1.setInt2(100);
            b1.setName1("AAA");
            b1.setName2("BBB");
            TestBean b2 = new TestBean();
            PojoManager.transferPojoIntoPojo((Object)b1, (Object)b2, true, new PojoManager.ICheckIfToTransferPropertyValue(){

                @Override
                public boolean check(Object fromBean, Object toBean, String propertyName, Object fromValue, Object toValue) {
                    return !"name2".equals(propertyName);
                }
            }, true);
            Assert.assertEquals((Object)b1.getName1(), (Object)b2.getName1());
            Assert.assertEquals((Object)"Name2", (Object)b2.getName2());
            Assert.assertEquals((long)b1.getInt2(), (long)b2.getInt2());
            System.out.println("Finished");
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)t.getMessage());
        }
    }

    @Test
    public void testCompareBeans() {
        try {
            TestBean b1 = new TestBean();
            b1.setInt2(100);
            b1.setName1("AAA");
            b1.setName2("BBB");
            TestBean b2 = new TestBean();
            b2.setInt2(1000);
            b2.setName1("AAA2");
            b2.setName2("BBB");
            List<PojoManager.PojoPropertyChangeInfo> cis = PojoManager.comparePojosOfSameClass(b1, b2);
            Assert.assertEquals((long)2L, (long)cis.size());
            System.out.println(cis);
            System.out.println("Finished");
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)t.getMessage());
        }
    }

    @Test
    public void testSortBeans() {
        try {
            ArrayList<TestBean> tbs = new ArrayList<TestBean>();
            for (int i = 0; i < 5; ++i) {
                TestBean tb = new TestBean("Name1_" + (10 - i), "Name2_fix", i);
                if (i % 3 == 0) {
                    tb.setBool(null);
                }
                if (i % 3 == 1) {
                    tb.setBool(true);
                }
                if (i % 3 == 2) {
                    tb.setBool(false);
                }
                tbs.add(tb);
            }
            this.sysoutListOfTestBeans(tbs);
            PojoManager.sortPojoList(tbs, new String[]{"name1"}, new boolean[]{true});
            this.sysoutListOfTestBeans(tbs);
            Assert.assertEquals((Object)"Name1_10", (Object)((TestBean)tbs.get(0)).getName1());
            PojoManager.sortPojoList(tbs, new String[]{"int2"}, new boolean[]{true});
            this.sysoutListOfTestBeans(tbs);
            Assert.assertEquals((long)0L, (long)((TestBean)tbs.get(0)).getInt2());
            PojoManager.sortPojoList(tbs, new String[]{"int2"}, new boolean[]{false});
            this.sysoutListOfTestBeans(tbs);
            Assert.assertEquals((long)4L, (long)((TestBean)tbs.get(0)).getInt2());
            PojoManager.sortPojoList(tbs, new String[]{"name2", "name1"}, new boolean[]{true, true});
            this.sysoutListOfTestBeans(tbs);
            Assert.assertEquals((Object)"Name1_10", (Object)((TestBean)tbs.get(0)).getName1());
            PojoManager.sortPojoList(tbs, new String[]{"bool", "name2"}, new boolean[]{true, true});
            this.sysoutListOfTestBeans(tbs);
            Assert.assertEquals((Object)"Name1_10", (Object)((TestBean)tbs.get(0)).getName1());
            System.out.println("Finished");
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)t.getMessage());
        }
    }

    private void sysoutListOfTestBeans(List<TestBean> tbs) {
        System.out.println("-------------------");
        for (TestBean tb : tbs) {
            System.out.println(tb.getName1() + ", " + tb.getName2() + ", " + tb.getInt2() + ", " + tb.getBool());
        }
    }

    public class TestBeanWithList {
        String m_name = "Harry";
        List<TestBean> m_beans = new ArrayList<TestBean>();

        public List<TestBean> getBeans() {
            return this.m_beans;
        }

        public String getName() {
            return this.m_name;
        }

        public void setName(String name) {
            this.m_name = name;
        }
    }

    public class TestBean {
        String m_name1 = "Name1";
        String m_name2 = "Name2";
        int m_int2 = 2;
        Boolean m_bool = null;

        public TestBean() {
        }

        public TestBean(String name1, String name2, int int2) {
            this.m_name1 = name1;
            this.m_name2 = name2;
            this.m_int2 = int2;
        }

        public String getName1() {
            return this.m_name1;
        }

        public void setName1(String name1) {
            this.m_name1 = name1;
        }

        public String getName2() {
            return this.m_name2;
        }

        public void setName2(String name2) {
            this.m_name2 = name2;
        }

        public int getInt2() {
            return this.m_int2;
        }

        public void setInt2(int int2) {
            this.m_int2 = int2;
        }

        public Boolean getBool() {
            return this.m_bool;
        }

        public void setBool(Boolean bool) {
            this.m_bool = bool;
        }
    }
}

