/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.time.LocalDate;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import org.eclnt.util.valuemgmt.ISimpleDataTypeExtension;
import org.eclnt.util.valuemgmt.PojoManager;
import org.eclnt.util.valuemgmt.ValueManager;
import org.eclnt.util.valuemgmt.simpledatatypemgmt.SimpleDataTypeMapper;
import org.junit.Assert;
import org.junit.Test;
import test.XYZDate;

public class TestSimpleDataTypeMapper {
    @Test
    public void testLocalDate() {
        try {
            LocalDate ld = LocalDate.of(2022, 5, 31);
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            long longLD = SimpleDataTypeMapper.map((Object)ld, Long.class, true);
            cal.clear();
            cal.set(1, 2022);
            cal.set(2, 4);
            cal.set(5, 31);
            long longCAL = cal.getTimeInMillis();
            System.out.println(longLD);
            System.out.println(longCAL);
            Assert.assertEquals((long)longLD, (long)longCAL);
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)t.toString());
        }
    }

    @Test
    public void testSimpleDataTypeExtension() {
        try {
            ValueManager.initializeAddSimpleDataTypeExtension(new MySimpleDataTypeExtension());
            Object o = ValueManager.convertStringIntoObject("100000", XYZDate.class);
            Assert.assertEquals(XYZDate.class, o.getClass());
            Assert.assertEquals((long)((XYZDate)o).getTime(), (long)100000L);
            String s = ValueManager.convertObject2ValueString(o);
            Assert.assertEquals((Object)"100000", (Object)s);
            System.out.println("Finished!");
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)t.toString());
        }
    }

    @Test
    public void testSimpleDataTypeExtensionPojo() {
        try {
            MyPojo p = new MyPojo("Captain", "Casa", new XYZDate(10000L));
            ValueManager.initializeAddSimpleDataTypeExtension(new MySimpleDataTypeExtension());
            MyPojo p2 = new MyPojo();
            PojoManager.transferPojoIntoPojo(p, p2, true);
            Assert.assertEquals((Object)p.getFirstName(), (Object)p2.getFirstName());
            Assert.assertEquals((Object)p.getXyzDate(), (Object)p2.getXyzDate());
            System.out.println("Finished!");
            p2 = new MyPojo();
            PojoManager.transferPojoIntoPojo((Object)p, (Object)p2, true, false, true);
            Assert.assertEquals((Object)p.getFirstName(), (Object)p2.getFirstName());
            Assert.assertEquals((Object)p.getXyzDate(), (Object)p2.getXyzDate());
            System.out.println("Finished!");
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)t.toString());
        }
    }

    @Test
    public void testByteArray() {
        try {
            MyImage image = new MyImage("testImage", new byte[]{1, 2, 3, 4, 5});
            Map<String, Object> m = PojoManager.transferPojoIntoMap(image);
            System.out.println(m);
            String s = ValueManager.convertObject2ValueString(image.getContent());
            System.out.println(s);
            System.out.println("Finished!");
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)t.toString());
        }
    }

    class MySimpleDataTypeExtension
    implements ISimpleDataTypeExtension {
        MySimpleDataTypeExtension() {
        }

        @Override
        public boolean checkIfClassIsSimpleDataType(Class c) {
            return c == XYZDate.class;
        }

        @Override
        public Object convertStringIntoSimpleDataTypeObject(String value, Class c) {
            long l = ValueManager.decodeLong(value, 0L);
            return new XYZDate(l);
        }

        @Override
        public String convertSimpleDataTypeObjectIntoString(Object o) {
            if (o instanceof XYZDate) {
                return ((XYZDate)o).getTime() + "";
            }
            return null;
        }
    }

    public static class MyImage {
        String m_name;
        byte[] m_content;

        public MyImage() {
        }

        public MyImage(String name, byte[] content) {
            this.m_name = name;
            this.m_content = content;
        }

        public String getName() {
            return this.m_name;
        }

        public void setName(String name) {
            this.m_name = name;
        }

        public byte[] getContent() {
            return this.m_content;
        }

        public void setContent(byte[] content) {
            this.m_content = content;
        }
    }

    public static class MyPojo {
        String m_firstName;
        String m_lastName;
        XYZDate m_xyzDate;

        public MyPojo() {
        }

        public MyPojo(String firstName, String lastName, XYZDate xyzDate) {
            this.m_firstName = firstName;
            this.m_lastName = lastName;
            this.m_xyzDate = xyzDate;
        }

        public String getFirstName() {
            return this.m_firstName;
        }

        public void setFirstName(String firstName) {
            this.m_firstName = firstName;
        }

        public String getLastName() {
            return this.m_lastName;
        }

        public void setLastName(String lastName) {
            this.m_lastName = lastName;
        }

        public XYZDate getXyzDate() {
            return this.m_xyzDate;
        }

        public void setXyzDate(XYZDate xyzDate) {
            this.m_xyzDate = xyzDate;
        }
    }
}

