/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.defaultscreens;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.eclnt.jsfserver.defaultscreens.DefaultScreens;
import org.eclnt.jsfserver.polling.LongPollingMgr;
import org.eclnt.jsfserver.polling.websocket.DefaultLongPollingWebSocket;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.ISessionAbstraction;
import org.eclnt.jsfserver.util.ISessionAbstractionListener;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.JAXBManager;

public class BlockerInfo {
    BlockerInfoWebSocketPolling m_blockerInfoWebSocketPolling;
    boolean m_available = false;

    public BlockerInfo() {
        try {
            if (HttpSessionAccess.checkIfCurrentClientTypeIsRisc() && SystemXml.getBlockerInfoActive()) {
                this.m_available = true;
                this.m_blockerInfoWebSocketPolling = new BlockerInfoWebSocketPolling();
                LongPollingMgr.add(this.m_blockerInfoWebSocketPolling);
                HttpSessionAccess.addDialogSessionClosedReactorForCurrentSession(new ISessionAbstractionListener(){

                    @Override
                    public void reactOnClosed() {
                        BlockerInfo.this.destroy();
                    }
                });
            } else {
                this.m_available = false;
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem when creating/registering web socket endpoint for blocker info", t);
        }
    }

    public static void sendProgressToClient(String text, int progress) {
        try {
            BlockerInfo bi = DefaultScreens.getSessionAccess().getBlockerInfo();
            bi.sendProgress(text, progress, null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void sendProgressToClient(String text, int progress, String protocol) {
        try {
            BlockerInfo bi = DefaultScreens.getSessionAccess().getBlockerInfo();
            bi.sendProgress(text, progress, protocol);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void sendProgressToClient(String text) {
        BlockerInfo.sendProgressToClient(text, 0);
    }

    public static void sendProgressToClientInOwnThread(ISessionAbstraction dialogSession, String text, int progress) {
        try {
            BlockerInfo bi = DefaultScreens.getSessionAccess(dialogSession).getBlockerInfo();
            bi.sendProgress(text, progress, null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void sendProgressToClientInOwnThread(ISessionAbstraction dialogSession, String text, int progress, String protocol) {
        try {
            BlockerInfo bi = DefaultScreens.getSessionAccess(dialogSession).getBlockerInfo();
            bi.sendProgress(text, progress, protocol);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getBlockerInfoWebSocketPollingUrl() {
        if (this.isAvailable()) {
            return this.m_blockerInfoWebSocketPolling.getURL();
        }
        return null;
    }

    public boolean isAvailable() {
        return this.m_available;
    }

    private void destroy() {
        try {
            if (this.m_blockerInfoWebSocketPolling != null) {
                LongPollingMgr.remove(this.m_blockerInfoWebSocketPolling);
                this.m_blockerInfoWebSocketPolling = null;
                this.m_available = false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void sendProgress(String text, int progress, String protocol) {
        try {
            BlockerData bd = new BlockerData();
            bd.setText(text);
            bd.setProgress(progress);
            bd.setProtocol(protocol);
            String message = JAXBManager.marshal(bd);
            if (this.isAvailable()) {
                this.m_blockerInfoWebSocketPolling.sendMessageToClient(message);
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem sending message to client: " + text);
        }
    }

    public static class BlockerInfoWebSocketPolling
    extends DefaultLongPollingWebSocket {
        @Override
        public void sendMessageToClient(String textMessage) {
            super.sendMessageToClient(textMessage);
        }
    }

    @XmlRootElement(name="blockerData")
    public static class BlockerData {
        String i_text;
        int i_progress = 0;
        String i_protocol;

        @XmlAttribute(name="text")
        public String getText() {
            return this.i_text;
        }

        public void setText(String text) {
            this.i_text = text;
        }

        @XmlAttribute(name="progress")
        public int getProgress() {
            return this.i_progress;
        }

        public void setProgress(int progress) {
            this.i_progress = progress;
        }

        @XmlAttribute(name="protocol")
        public String getProtocol() {
            return this.i_protocol;
        }

        public void setProtocol(String protocol) {
            this.i_protocol = protocol;
        }
    }
}

