/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.defaultscreens;

import java.io.Serializable;
import javax.faces.event.ActionEvent;
import org.eclnt.jsfserver.defaultscreens.ModalPopup;
import org.eclnt.jsfserver.elements.ThreadData;
import org.eclnt.jsfserver.polling.DefaultLongPolling;
import org.eclnt.jsfserver.polling.ILongPolling;
import org.eclnt.jsfserver.polling.LongPollingMgr;
import org.eclnt.jsfserver.polling.websocket.DefaultLongPollingWebSocket;
import org.eclnt.util.log.CLog;
import org.eclnt.util.log.IObserver;
import org.eclnt.util.log.Observer;

public class ObserverPopup
implements Serializable {
    public static int POPUP_WIDTH = 600;
    public static int POPUP_HEIGHT = 300;
    LongPollerObserver m_observer;
    Runnable m_runnable;
    Runnable m_runnableWhenFinished;
    ModalPopup m_popup;
    ILongPolling m_longPolling;
    String m_headline;
    String m_image;
    boolean m_showingFinalMessages = false;
    boolean m_showingFinalMessagesFinished = false;
    int m_durationShowFinalMessages = 0;
    boolean m_usingWebSockets = false;

    public boolean getAvailableImage() {
        return this.m_image != null;
    }

    public boolean getRenderedHttpPolling() {
        return !this.m_usingWebSockets;
    }

    public boolean getRenderedWebSocketPolling() {
        return this.m_usingWebSockets;
    }

    public String getImage() {
        return this.m_image;
    }

    public int getDurationShowFinalMessages() {
        return this.m_durationShowFinalMessages;
    }

    public void setDurationShowFinalMessages(int durationShowFinalMessages) {
        this.m_durationShowFinalMessages = durationShowFinalMessages;
    }

    public void onLongPollingAction(ActionEvent event) {
        if (!this.checkIfRunning()) {
            try {
                if (this.m_runnableWhenFinished != null) {
                    this.m_runnableWhenFinished.run();
                }
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_ERR, "Error when processing runnable after update...", t);
            }
            if (this.m_popup != null) {
                this.m_popup.close();
            }
            if (this.m_longPolling != null) {
                LongPollingMgr.remove(this.m_longPolling);
            }
            this.m_longPolling = null;
            this.m_popup = null;
            this.m_runnable = null;
            this.m_runnableWhenFinished = null;
            this.m_showingFinalMessages = false;
            this.m_showingFinalMessagesFinished = false;
            this.m_durationShowFinalMessages = 0;
        }
    }

    private boolean checkIfRunning() {
        if (this.m_observer.checkIfRunning()) {
            return true;
        }
        if (this.m_durationShowFinalMessages > 0 && !this.m_showingFinalMessages) {
            this.m_showingFinalMessages = true;
            this.m_showingFinalMessagesFinished = false;
            new WaiterThread().start();
            return true;
        }
        return this.m_durationShowFinalMessages > 0 && this.m_showingFinalMessages && !this.m_showingFinalMessagesFinished;
    }

    public IObserver prepare(String headline) {
        return this.prepare(headline, null);
    }

    public IObserver prepare(String headline, String image) {
        this.m_observer = new LongPollerObserver();
        this.m_headline = headline;
        this.m_image = image;
        return this.m_observer;
    }

    public void run(Runnable r, Runnable runnableWhenFinished) {
        this.run(r, runnableWhenFinished, POPUP_WIDTH, POPUP_HEIGHT);
    }

    public void run(Runnable r, Runnable runnableWhenFinished, int popupWidth, int popupHeight) {
        this.m_popup = ModalPopup.createInstance();
        this.m_popup.open("/eclntjsfserver/popups/observerpopup.jsp", "", popupWidth, popupHeight, new ModalPopup.IModalPopupListener(){

            @Override
            public void reactOnPopupClosedByUser() {
            }
        });
        this.m_popup.setLeftTopReferenceCentered();
        this.m_popup.setUndecorated(true);
        this.m_popup.setUpdateIsolation(true);
        this.m_popup.setStartfromrootwindow(false);
        this.createLongPolling();
        this.m_runnable = r;
        this.m_runnableWhenFinished = runnableWhenFinished;
        new ObservedThread(this.m_observer, this.m_longPolling, this.m_runnable).start();
    }

    public String getText() {
        return this.m_observer.getText();
    }

    public void setText(String s) {
    }

    public void setHeadline(String value) {
        this.m_headline = value;
    }

    public String getHeadline() {
        return this.m_headline;
    }

    public String getLongPollingURL() {
        return this.m_longPolling.getURL();
    }

    private void createLongPolling() {
        this.m_longPolling = this.m_usingWebSockets ? new DefaultLongPollingWebSocket() : new DefaultLongPolling();
        LongPollingMgr.add(this.m_longPolling);
    }

    class WaiterThread
    extends Thread {
        @Override
        public void run() {
            try {
                Thread.sleep(ObserverPopup.this.m_durationShowFinalMessages);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ObserverPopup.this.m_showingFinalMessagesFinished = true;
            ObserverPopup.this.m_longPolling.wakeup(true);
        }
    }

    static class ObservedThread
    extends Thread
    implements Serializable {
        LongPollerObserver i_observer;
        ILongPolling i_longPolling;
        Runnable i_runnable;

        public ObservedThread(LongPollerObserver observer, ILongPolling longPolling, Runnable runnable) {
            this.i_observer = observer;
            this.i_longPolling = longPolling;
            this.i_runnable = runnable;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            this.i_observer.start(this);
            try {
                this.i_runnable.run();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.i_observer.end(this);
            this.i_longPolling.wakeup(true);
            ThreadData instance = ThreadData.getInstance(false);
            if (instance != null) {
                instance.destroy();
            }
        }
    }

    public class LongPollerObserver
    extends Observer
    implements Serializable {
        IObserver i_delegate = null;

        public void setDelegate(IObserver delegate) {
            this.i_delegate = delegate;
        }

        public IObserver getDelegate() {
            return this.i_delegate;
        }

        @Override
        public void start(Object caller) {
            super.start(caller);
            if (this.i_delegate != null) {
                try {
                    this.i_delegate.start(caller);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        @Override
        public void end(Object caller) {
            super.end(caller);
            if (this.i_delegate != null) {
                try {
                    this.i_delegate.end(caller);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        @Override
        public void addMessage(String message) {
            super.addMessage(message);
            if (this.i_delegate != null) {
                try {
                    this.i_delegate.addMessage(message);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            ObserverPopup.this.m_longPolling.wakeup(true);
        }
    }
}

