/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements.adapter;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.eclnt.jsfserver.elements.adapter.ComponentAttribute;
import org.eclnt.jsfserver.elements.adapter.ComponentAttributeType;
import org.eclnt.jsfserver.util.BeanIntrospector;
import org.eclnt.util.log.CLog;

public class ReflectionAnalyzer {
    static final Object SYNCHER1 = new Object();
    static final Map<Class, ReflectionInfo> s_iis = new Hashtable<Class, ReflectionInfo>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReflectionInfo analyze(Class clazz) {
        ReflectionInfo ii = s_iis.get(clazz);
        if (ii == null) {
            Object object = SYNCHER1;
            synchronized (object) {
                ii = s_iis.get(clazz);
                if (ii == null) {
                    ii = ReflectionAnalyzer.createIntroSpectionInfo(clazz);
                    s_iis.put(clazz, ii);
                }
            }
        }
        return ii;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetBuffers() {
        Object object = SYNCHER1;
        synchronized (object) {
            s_iis.clear();
        }
    }

    private static ReflectionInfo createIntroSpectionInfo(Class clazz) {
        ReflectionInfo ii = new ReflectionInfo();
        try {
            Map<String, BeanIntrospector.PropertyIntrospectionInfo> piis = BeanIntrospector.readProperties(clazz);
            for (BeanIntrospector.PropertyIntrospectionInfo pii : piis.values()) {
                ComponentAttribute p = null;
                if (pii.getGetter() != null && pii.getGetter().isAnnotationPresent(ComponentAttribute.class)) {
                    p = pii.getGetter().getAnnotation(ComponentAttribute.class);
                }
                if (p == null && pii.getSetter() != null && pii.getSetter().isAnnotationPresent(ComponentAttribute.class)) {
                    p = pii.getGetter().getAnnotation(ComponentAttribute.class);
                }
                if (p == null) continue;
                String attributeName = pii.getPropertyName();
                if (p.attribute() != null && p.attribute().length() > 0) {
                    attributeName = p.attribute();
                }
                ComponentAttributeType type = ComponentAttributeType.DYNAMIC;
                if (p.type() != null) {
                    type = p.type();
                }
                if (type == ComponentAttributeType.FIX) {
                    ii.i_fixAttributes.add(attributeName);
                } else {
                    ii.i_dynAttributes.add(attributeName);
                }
                ii.i_propertyMap.put(attributeName, pii);
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem analyzing class: " + clazz, t);
        }
        return ii;
    }

    public static class ReflectionInfo {
        Set<String> i_fixAttributes = new HashSet<String>();
        Set<String> i_dynAttributes = new HashSet<String>();
        Map<String, BeanIntrospector.PropertyIntrospectionInfo> i_propertyMap = new HashMap<String, BeanIntrospector.PropertyIntrospectionInfo>();

        public Set<String> getFixAttributes() {
            return this.i_fixAttributes;
        }

        public Set<String> getDynAttributes() {
            return this.i_dynAttributes;
        }

        public Map<String, BeanIntrospector.PropertyIntrospectionInfo> getProperties() {
            return this.i_propertyMap;
        }
    }
}

