/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements.impl;

import org.eclnt.jsfserver.elements.util.IValueByToString;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.ICCServerConstants;
import org.eclnt.jsfserver.util.valuemgmt.IDynamicContentBindingObject;
import org.eclnt.util.chart.ChartInfo;
import org.eclnt.util.chart.util.ChartInfoExporter;
import org.eclnt.util.chart.util.ChartSVGExporter;
import org.eclnt.util.chart.util.JFreeChartRenderer;
import org.jfree.chart.JFreeChart;

public class CHARTBinding
implements ICCServerConstants,
IDynamicContentBindingObject,
IValueByToString {
    ChartInfo m_chartInfo;
    String m_chartXML;
    boolean m_returnXML = true;
    int m_svgWidth = 600;
    int m_svgHeight = 450;

    public CHARTBinding() {
        try {
            if (HttpSessionAccess.checkIfCurrentClientJavaTypeIsFX() || HttpSessionAccess.checkIfCurrentClientTypeIsRisc()) {
                this.m_returnXML = false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public ChartInfo getChartInfo() {
        return this.m_chartInfo;
    }

    public void setChartInfo(ChartInfo chartInfo) {
        this.m_chartInfo = chartInfo;
        if (this.m_chartInfo == null) {
            this.m_chartXML = null;
        } else if (this.m_returnXML) {
            this.m_chartXML = ChartInfoExporter.exportXML(chartInfo);
        } else {
            JFreeChart chart = new JFreeChartRenderer().renderChart(this.m_chartInfo).getChart();
            this.m_chartXML = ChartSVGExporter.generateSVG(chart, this.m_svgWidth, this.m_svgHeight);
        }
    }

    public String toString() {
        return this.m_chartXML;
    }

    public String getChartXML() {
        return this.m_chartXML;
    }

    public void setSvgBounds(int svgWidth, int svgHeight) {
        this.m_svgWidth = svgWidth;
        this.m_svgHeight = svgHeight;
        if (!this.m_returnXML && this.m_chartInfo != null) {
            this.setChartInfo(this.m_chartInfo);
        }
    }
}

