/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.pagebean.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.eclnt.jsfserver.elements.pagemodifier.DefaultPageModifier;
import org.eclnt.jsfserver.elements.pagemodifier.IPageModifier;
import org.eclnt.jsfserver.elements.pagemodifier.implxml.PageModifierSequence;
import org.eclnt.jsfserver.elements.pagemodifier.implxml.PageModifierXML;
import org.eclnt.jsfserver.managedbean.HotDeployManager;
import org.eclnt.jsfserver.pagebean.PageBean;
import org.eclnt.jsfserver.pagebean.component.IPageBeanComponentInfoService;
import org.eclnt.jsfserver.pagebean.component.PageBeanComponent;
import org.eclnt.jsfserver.pagebean.component.PageBeanComponentInfo;
import org.eclnt.jsfserver.pagebean.component.PageBeanComponentInfos;
import org.eclnt.jsfserver.pagebean.component.PageBeanConfig;
import org.eclnt.jsfserver.pagebean.component.PageBeanConfigParam;
import org.eclnt.jsfserver.pagebean.component.PageBeanConfigParentExit;
import org.eclnt.jsfserver.pagebean.component.PageBeanConfigSubItem;
import org.eclnt.jsfserver.util.BeanIntrospector;
import org.eclnt.util.classresolver.CCClassResolver;
import org.eclnt.util.classresolver.ENUMCallerType;
import org.eclnt.util.file.ClassloaderReader;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.JAXBManager;
import org.eclnt.util.valuemgmt.ValueManager;

public class PageBeanComponentRepository {
    static final IPageModifier NULLMODIFIER = new DefaultPageModifier();
    static Map<String, PageBeanConfig> s_configs = new Hashtable<String, PageBeanConfig>();
    static Map<Class, IPageModifier> s_modifications = new Hashtable<Class, IPageModifier>();
    static Map<Class, Class> s_oringalClasses = new Hashtable<Class, Class>();
    static Map<String, PageModifierXML> s_bufferedPageModifiersXML = new HashMap<String, PageModifierXML>();
    static ClassLoader s_lastClassLoader4PageModifiersXML = null;

    public static void resetBuffers() {
        s_configs.clear();
        s_modifications.clear();
        s_oringalClasses.clear();
        s_bufferedPageModifiersXML.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class readOriginalClass(Class c) {
        Class result;
        block7: {
            result = null;
            try {
                result = s_oringalClasses.get(c);
                if (result != null) break block7;
                Map<Class, Class> map = s_oringalClasses;
                synchronized (map) {
                    block8: {
                        result = s_oringalClasses.get(c);
                        if (result == null) {
                            Class current = c;
                            do {
                                String xml;
                                if ((xml = PageBeanComponentRepository.readLayoutDefinition(current)) == null) continue;
                                result = current;
                                s_oringalClasses.put(c, result);
                                break block8;
                            } while ((current = current.getSuperclass()) != PageBeanComponent.class);
                            throw new Error("Could not find original class");
                        }
                    }
                }
            }
            catch (Throwable t) {
                result = c;
                s_oringalClasses.put(c, result);
            }
        }
        return result;
    }

    public static String readLayoutDefinition(Class clazz) {
        String xmlResource = clazz.getName().replace(".", "/") + ".xml";
        String xml = new ClassloaderReader(clazz.getClassLoader()).readUTF8File(xmlResource, false);
        if (xml == null) {
            xmlResource = clazz.getName().replace(".", "/") + ".jsp";
        }
        xml = new ClassloaderReader(clazz.getClassLoader()).readUTF8File(xmlResource, false);
        return xml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IPageModifier readPageModification(Class c) {
        IPageModifier result;
        block10: {
            result = null;
            try {
                result = s_modifications.get(c);
                if (result != null) break block10;
                Map<Class, IPageModifier> map = s_modifications;
                synchronized (map) {
                    result = s_modifications.get(c);
                    if (result == null) {
                        CLog.L.log(CLog.LL_INF, "Reading page modifications for class: " + c.getName() + " - begin");
                        result = new PageModifierSequence(c);
                        for (Class current = c; current != PageBeanComponent.class && current != PageBean.class; current = current.getSuperclass()) {
                            String resource = current.getName().replace(".", "/") + ".mod.xml";
                            PageModifierXML pm = PageBeanComponentRepository.readPageModifierXML(resource);
                            if (!pm.checkIfAnyModificationContained()) continue;
                            ((PageModifierSequence)result).addToSequenceAsFirst(pm);
                        }
                        if (((PageModifierSequence)result).checkIfAnyModificationContained()) {
                            s_modifications.put(c, result);
                        } else {
                            s_modifications.put(c, NULLMODIFIER);
                        }
                        CLog.L.log(CLog.LL_INF, "Reading page modifications for class: - end");
                    }
                }
            }
            catch (Throwable t) {
                result = NULLMODIFIER;
                s_modifications.put(c, result);
            }
        }
        if (result == NULLMODIFIER) {
            result = null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PageModifierXML readPageModifierXML(String resource) {
        PageModifierXML result;
        ClassLoader current = HotDeployManager.currentClassLoader();
        if (current != s_lastClassLoader4PageModifiersXML) {
            s_bufferedPageModifiersXML.clear();
            s_lastClassLoader4PageModifiersXML = current;
        }
        if ((result = s_bufferedPageModifiersXML.get(resource)) == null) {
            Map<String, PageModifierXML> map = s_bufferedPageModifiersXML;
            synchronized (map) {
                result = s_bufferedPageModifiersXML.get(resource);
                if (result == null) {
                    result = new PageModifierXML(resource);
                    s_bufferedPageModifiersXML.put(resource, result);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PageBeanConfig readPageBeanConfig(ClassLoader classLoader, String className) {
        try {
            PageBeanConfig result = s_configs.get(className);
            if (result != null) {
                return result;
            }
            Map<String, PageBeanConfig> map = s_configs;
            synchronized (map) {
                result = s_configs.get(className);
                if (result != null) {
                    return result;
                }
                String configName = className.replace('.', '/') + ".config";
                if (classLoader == null) {
                    classLoader = PageBeanComponentRepository.class.getClassLoader();
                }
                ClassloaderReader clr = new ClassloaderReader(classLoader);
                String xml = clr.readUTF8File(configName, true);
                result = PageBeanConfig.createFromXML(xml);
                s_configs.put(className, result);
                PageBeanComponentRepository.addClassInitParameters(classLoader, result);
                PageBeanComponentRepository.addParentExitDefinitions(classLoader, className, result);
                return result;
            }
        }
        catch (Throwable t) {
            return new PageBeanConfig();
        }
    }

    public static void addClassInitParameters(ClassLoader classLoader, PageBeanConfig config) {
        PageBeanComponentRepository.addInitParametersFromParamClass(classLoader, config.getParamClass(), config.getParams());
        for (PageBeanConfigSubItem subItem : config.getSubItems()) {
            PageBeanComponentRepository.addInitParametersFromParamClass(classLoader, subItem.getParamClass(), subItem.getParams());
        }
    }

    public static void addParentExitDefinitions(ClassLoader classLoader, String className, PageBeanConfig config) {
        try {
            Class clazz = CCClassResolver.resolveClass(className, false, classLoader, ENUMCallerType.COMPONENT);
            String layoutXml = PageBeanComponentRepository.readLayoutDefinition(clazz);
            if (layoutXml != null) {
                int indexTagClose;
                int index;
                int currentIndex = 0;
                while ((index = layoutXml.indexOf("<t:parentexit", currentIndex)) >= 0 && (indexTagClose = layoutXml.indexOf(">", index + "<t:parentexit".length())) >= 0) {
                    if ((index = layoutXml.indexOf(" exitid=\"", index + "<t:parentexit".length())) < indexTagClose) {
                        int closingIndex = layoutXml.indexOf("\"", index + " exitid=\"".length());
                        if (closingIndex > 0) {
                            String exitId = layoutXml.substring(index + " exitid=\"".length(), closingIndex);
                            PageBeanConfigParentExit parentExit = new PageBeanConfigParentExit();
                            parentExit.setExitid(exitId);
                            config.getParentExits().add(parentExit);
                        }
                        currentIndex = closingIndex + 1;
                        continue;
                    }
                    currentIndex = indexTagClose + 1;
                }
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Could not read parent exit definitions for page bean component: " + className, t);
        }
    }

    private static void addInitParametersFromParamClass(ClassLoader classLoader, String paramClassName, List<PageBeanConfigParam> configParams) {
        try {
            if (paramClassName == null) {
                return;
            }
            Class c = CCClassResolver.resolveClass(paramClassName, false, classLoader, ENUMCallerType.EXPRESSIONRESOLUTION);
            List<BeanIntrospector.PropertyIntrospectionInfo> piis = BeanIntrospector.readPropertiesAsList(c);
            for (BeanIntrospector.PropertyIntrospectionInfo pii : piis) {
                Class<?> propertyClass = pii.getGetter().getReturnType();
                if (!ValueManager.checkIfSimpleDataType(propertyClass)) continue;
                boolean alreadyInList = false;
                for (PageBeanConfigParam param : configParams) {
                    if (!ValueManager.checkIfObjectsAreEqual(param.getName(), pii.getPropertyName())) continue;
                    alreadyInList = true;
                    break;
                }
                if (alreadyInList) continue;
                PageBeanConfigParam param = new PageBeanConfigParam();
                param.setName(pii.getPropertyName());
                configParams.add(param);
            }
            Collections.sort(configParams);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem reading page bean configuration, paramClass: " + paramClassName, t);
        }
    }

    public static List<Class> readPageBeanClasses(ClassLoader classLoader) {
        ArrayList<Class> allClasses = new ArrayList<Class>();
        List<PageBeanComponentInfos> piss = PageBeanComponentRepository.readAllCCPAGEBEANCOMPONENTINFOXML();
        for (PageBeanComponentInfos pis : piss) {
            for (PageBeanComponentInfo pi : pis.getPageBeanComponents()) {
                String className = pi.getClassName();
                if (className == null) continue;
                try {
                    Class c = CCClassResolver.resolveClass(className, true, classLoader, ENUMCallerType.EXPRESSIONRESOLUTION);
                    allClasses.add(c);
                }
                catch (Throwable t) {
                    CLog.L.log(CLog.LL_INF, "Problem occurred when accessing: " + pi.getClassName(), t);
                }
            }
        }
        ServiceLoader<IPageBeanComponentInfoService> sl = ServiceLoader.load(IPageBeanComponentInfoService.class, classLoader);
        Iterator<IPageBeanComponentInfoService> it = sl.iterator();
        while (it.hasNext()) {
            try {
                IPageBeanComponentInfoService pbcis = it.next();
                allClasses.addAll(pbcis.getPageBeanComponents());
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_INF, "Problem when loading page bean component classes", t);
            }
        }
        Collections.sort(allClasses, new Comparator<Class>(){

            @Override
            public int compare(Class o1, Class o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return allClasses;
    }

    public static List<String> readPackageNamesOfStyleExtensions(ClassLoader classLoader) {
        ArrayList<String> result = new ArrayList<String>();
        List<PageBeanComponentInfos> piss = PageBeanComponentRepository.readAllCCPAGEBEANCOMPONENTINFOXML();
        for (PageBeanComponentInfos pis : piss) {
            if (pis.getPackageOfStyleExtensions() == null) continue;
            result.add(pis.getPackageOfStyleExtensions());
        }
        ServiceLoader<IPageBeanComponentInfoService> sl = ServiceLoader.load(IPageBeanComponentInfoService.class, classLoader);
        Iterator<IPageBeanComponentInfoService> it = sl.iterator();
        while (it.hasNext()) {
            try {
                IPageBeanComponentInfoService pbcis = it.next();
                String packageName = pbcis.getPackageNameOfStyleExtensions();
                if (packageName == null) continue;
                result.add(packageName);
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_INF, "Problem when loading package name for style extensions", t);
            }
        }
        return result;
    }

    private static List<PageBeanComponentInfos> readAllCCPAGEBEANCOMPONENTINFOXML() {
        ArrayList<PageBeanComponentInfos> result = new ArrayList<PageBeanComponentInfos>();
        ClassLoader cl = HotDeployManager.currentClassLoader();
        List<String> xmls = new ClassloaderReader(cl).readUTF8Files("ccpagebeancomponentinfo.xml", false);
        for (String xml : xmls) {
            try {
                PageBeanComponentInfos pis = (PageBeanComponentInfos)JAXBManager.unmarshal(xml, PageBeanComponentInfos.class);
                result.add(pis);
            }
            catch (Throwable tt) {
                CLog.L.log(CLog.LL_ERR, "Problem reading ccpagebeancomponentinfo.xml content: " + xml, tt);
            }
        }
        return result;
    }
}

