/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.polling;

import java.io.Serializable;
import java.util.Date;
import javax.servlet.AsyncContext;
import javax.servlet.http.HttpServletResponse;
import org.eclnt.jsfserver.polling.ILongPolling;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.ServletUtil;
import org.eclnt.util.log.CLog;

public class DefaultLongPolling30API
implements ILongPolling,
Serializable {
    static int s_idCounter = 0;
    String m_id = "cclongpollingcomet_" + new Date().getTime() + "_" + ++s_idCounter;
    boolean m_continuePolling = false;
    boolean m_wasWokenUpInNotWaitingPhase = false;
    boolean m_throwError = false;
    String m_longPollingResponse = null;
    HttpServletResponse m_httpServletResponse;
    AsyncContext m_asyncContext;
    long m_lastResponseTime;

    public DefaultLongPolling30API() {
        this.updateLastResponseTime();
    }

    @Override
    public String getId() {
        return this.m_id;
    }

    @Override
    public boolean getContinuePolling() {
        return this.m_continuePolling;
    }

    @Override
    public String getURL() {
        String result = "cclongpollingcomet/" + this.m_id + ".cclongpolling30API";
        result = ServletUtil.encodeURL(result, HttpSessionAccess.getCurrentRequest(), HttpSessionAccess.getCurrentResponse());
        result = "/" + result;
        return result;
    }

    public boolean waitForEvent(AsyncContext asyncContext, HttpServletResponse response) {
        if (this.isWaitingForEvent()) {
            try {
                this.m_httpServletResponse.getWriter().write("false");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.m_httpServletResponse.getWriter().close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.m_asyncContext.complete();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.m_httpServletResponse = null;
            this.m_asyncContext = null;
        }
        this.m_asyncContext = asyncContext;
        this.m_httpServletResponse = response;
        if (!this.m_wasWokenUpInNotWaitingPhase) {
            this.m_httpServletResponse = response;
        } else {
            this.wakeup(this.m_continuePolling);
        }
        return true;
    }

    protected boolean isWaitingForEvent() {
        return this.m_httpServletResponse != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wakeup(boolean continuePolling) {
        this.m_throwError = false;
        DefaultLongPolling30API defaultLongPolling30API = this;
        synchronized (defaultLongPolling30API) {
            this.updateLastResponseTime();
            this.m_continuePolling = continuePolling;
            if (this.isWaitingForEvent()) {
                this.m_wasWokenUpInNotWaitingPhase = false;
                this.sendMessageToClient("" + this.m_continuePolling, true);
            } else {
                CLog.L.log(CLog.LL_INF, "##### Buffering wakeup to client " + this.m_continuePolling);
                this.m_wasWokenUpInNotWaitingPhase = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wakeupForReconnect() {
        this.m_throwError = false;
        DefaultLongPolling30API defaultLongPolling30API = this;
        synchronized (defaultLongPolling30API) {
            this.updateLastResponseTime();
            if (this.isWaitingForEvent()) {
                this.sendMessageToClient("reconnect", true);
            }
        }
    }

    @Override
    public void abortThread() {
        if (this.isWaitingForEvent()) {
            this.sendMessageToClient(null, true);
        }
    }

    @Override
    public void abortThreadWithErrorIfWaiting() {
        this.abortThread();
    }

    @Override
    public void abortThreadWithouContinuingPolling() {
        this.wakeup(false);
    }

    @Override
    public void keepAlive() {
        this.m_throwError = false;
        this.updateLastResponseTime();
        if (this.isWaitingForEvent()) {
            this.sendMessageToClient("          ", false);
        }
    }

    @Override
    public long getLastResponseTime() {
        return this.m_lastResponseTime;
    }

    private void sendMessageToClient(String message, boolean close) {
        CLog.L.log(CLog.LL_INF, "##### Sending message to client " + this.m_continuePolling);
        if (this.isWaitingForEvent()) {
            try {
                if (message != null) {
                    this.m_httpServletResponse.getWriter().write(message);
                }
                this.m_httpServletResponse.getWriter().flush();
                if (!close) {
                    return;
                }
                this.m_httpServletResponse.getWriter().close();
                this.m_asyncContext.complete();
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_INF, "Problem when writing long polling response", t);
            }
            this.m_httpServletResponse = null;
            this.m_asyncContext = null;
        } else {
            CLog.L.log(CLog.LL_INF, "##### No response to write to found");
        }
    }

    private void updateLastResponseTime() {
        this.m_lastResponseTime = System.currentTimeMillis();
    }
}

