/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.resources;

import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import org.eclnt.jsfserver.configuration.CCConfigurationObject;
import org.eclnt.jsfserver.managedbean.HotDeployManager;
import org.eclnt.jsfserver.resources.IResourceAccess;
import org.eclnt.jsfserver.resources.IResourceManagerPreProcessor;
import org.eclnt.jsfserver.resources.ResourceUtil;
import org.eclnt.jsfserver.util.ExpressionManagerV;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.ICCServerConstants;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.jsfserver.util.parse.SAXParserUtil;
import org.eclnt.util.file.EclntConfigFileReader;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.log.CLog;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ResourceManager
implements ICCServerConstants {
    static ResourceManager s_runtimeInstance;
    static ServletContext s_servletContext;
    Map<String, String> m_resources = new Hashtable<String, String>();
    Map<String, String> m_defaultValues = new Hashtable<String, String>();
    Map<String, String> m_rrExpressions = new Hashtable<String, String>();
    CCConfigurationObject<IResourceAccess> m_resourceAccess = null;
    CCConfigurationObject<IResourceManagerPreProcessor> m_resourceManagerPreProcessor = null;

    public static void init(ServletContext context) {
        s_runtimeInstance = new ResourceManager();
        s_servletContext = context;
        List<String> xmls = EclntConfigFileReader.readConfiguration("resources", false);
        for (String xml : xmls) {
            try {
                SAXParserUtil.parse(xml, (DefaultHandler)new MyParser(s_runtimeInstance));
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_ERR, "Error when starting the resource bundle management, xml: " + xml, t);
            }
        }
        ResourceManager.initOutsourcedResourceAccess(context);
    }

    private static void initOutsourcedResourceAccess(ServletContext context) {
        if (SystemXml.getResourceManagerResourceAccessClassName() != null) {
            try {
                ResourceManager.s_runtimeInstance.m_resourceAccess = new CCConfigurationObject(SystemXml.getResourceManagerResourceAccessClassName(), null);
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_ERR, "Could not create resource data access instance, class name: " + SystemXml.getResourceManagerResourceAccessClassName());
            }
        }
        if (SystemXml.getResourceManagerResourceManagerPreProcessorClassName() != null) {
            try {
                ResourceManager.s_runtimeInstance.m_resourceManagerPreProcessor = new CCConfigurationObject(SystemXml.getResourceManagerResourceManagerPreProcessorClassName(), null);
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_ERR, "Could not create resource manager preprocessor, class name: " + SystemXml.getResourceManagerResourceManagerPreProcessorClassName());
            }
        }
    }

    public static void initForJUnitTest() {
        s_runtimeInstance = new ResourceManager();
    }

    public static ResourceManager getRuntimeInstance() {
        return s_runtimeInstance;
    }

    public static ResourceManager getInstanceViaFileSystem(String ... resourcesConfigDirectories) {
        ResourceManager result = new ResourceManager();
        if (resourcesConfigDirectories != null) {
            for (String resourcesConfigDirectory : resourcesConfigDirectories) {
                List<String> fileNames = FileManager.getFilesOfDirectoryByPattern(resourcesConfigDirectory, "resources", ".xml");
                for (String fileName : fileNames) {
                    try {
                        String xml = FileManager.readUTF8File(fileName, false);
                        if (xml == null || xml.equals("")) continue;
                        SAXParserUtil.parse(xml, (DefaultHandler)new MyParser(result));
                    }
                    catch (Throwable t) {
                        CLog.L.log(CLog.LL_ERR, "Error when starting the resource bundle management", t);
                        return null;
                    }
                }
            }
        }
        return result;
    }

    public void setResourceAccess(IResourceAccess resourceAccess) {
        this.m_resourceAccess = new CCConfigurationObject<IResourceAccess>(resourceAccess);
    }

    public IResourceAccess getResourceAccess() {
        return this.m_resourceAccess != null ? this.m_resourceAccess.instance() : null;
    }

    public String readProperty(String resourceName, String property, Locale locale) {
        return this.readProperty(resourceName, property, locale, false);
    }

    public String readProperty(String resourceName, String property, Locale locale, boolean withError) {
        return this.readPropertyExecute(resourceName, property, locale, withError, 0);
    }

    public String readProperty(String resourceName, String property) {
        return this.readProperty(resourceName, property, false);
    }

    public String readProperty(String resourceName, String property, boolean withError) {
        try {
            return this.readProperty(resourceName, property, HttpSessionAccess.getCurrentLocale(), withError);
        }
        catch (Throwable t) {
            String defaultValue = this.m_defaultValues.get(resourceName);
            if (defaultValue == null) {
                if (withError) {
                    throw new Error("Could not read property: " + resourceName + ", " + property, t);
                }
                return "{" + resourceName + "." + property + "}";
            }
            if ("null".equals(defaultValue)) {
                return null;
            }
            return defaultValue;
        }
    }

    public Map<String, String> getResources() {
        return this.m_resources;
    }

    public static String findLiteral(String resourceName, String literalId) {
        return s_runtimeInstance.readProperty(resourceName, literalId);
    }

    public static String findLiteral(String resourceName, String literalId, boolean withError) {
        return s_runtimeInstance.readProperty(resourceName, literalId, withError);
    }

    public static String findLiteral(String resourceName, String literalId, Locale locale, boolean withError) {
        return s_runtimeInstance.readProperty(resourceName, literalId, locale, withError);
    }

    public static String findLiteral(String resourceName, String literalId, Locale locale) {
        return s_runtimeInstance.readProperty(resourceName, literalId, locale);
    }

    public static String findText(String text) {
        if (text == null) {
            return null;
        }
        if (text.startsWith("#{") && text.endsWith("}")) {
            try {
                String value = (String)ExpressionManagerV.getValueForExpressionString(HttpSessionAccess.getCurrentFacesContext(), text);
                return value;
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_INF, "Could not resolve text: " + text, t);
            }
        }
        return text;
    }

    public void addResourceConfiguration(String resourceName, String packageName, String defaultValue) {
        this.m_resources.put(resourceName, packageName);
        if (defaultValue != null) {
            this.m_defaultValues.put(resourceName, defaultValue);
        }
    }

    public String getResourceReaderExpression(String resource) {
        try {
            String result = this.m_rrExpressions.get(resource);
            if (result == null) {
                result = "rr";
            }
            return result;
        }
        catch (Throwable t) {
            return "rr";
        }
    }

    private String readPropertyExecute(String resourceName, String property, Locale locale, boolean withError, int stackSize) {
        try {
            String result = this.readPropertyValueFromPreProcessor(resourceName, property, locale);
            if (result != null) {
                result = ResourceUtil.updateResourceTextBeforeUsage(result);
                result = this.processPropertyLink(resourceName, result, locale, withError, stackSize);
                return result;
            }
            if (this.getResourceAccess() == null || "cci18n".equals(resourceName)) {
                String packageName = this.m_resources.get(resourceName);
                String resourceBundleName = null;
                if (packageName != null) {
                    resourceBundleName = packageName + "." + resourceName;
                } else if ("cci18n".equals(resourceName)) {
                    resourceBundleName = "org.eclnt.jsfserver.i18n.resources.Literals";
                } else {
                    throw new Exception("packageName not defined for resourceName: " + resourceName);
                }
                ResourceBundle rb = ResourceBundle.getBundle(resourceBundleName, locale, HotDeployManager.currentClassLoader());
                String result2 = rb.getString(property);
                if (result2 == null) {
                    throw new Exception("not found");
                }
                result2 = ResourceUtil.updateResourceTextBeforeUsage(result2);
                result2 = this.processPropertyLink(resourceName, result2, locale, withError, stackSize);
                return result2;
            }
            result = this.m_resourceAccess.instance().readProperty(resourceName, property, locale, withError);
            if (result == null) {
                throw new Exception("not found");
            }
            result = ResourceUtil.updateResourceTextBeforeUsage(result);
            result = this.processPropertyLink(resourceName, result, locale, withError, stackSize);
            return result;
        }
        catch (Throwable t) {
            if (withError) {
                throw new Error("Could not read property: " + resourceName + "," + property, t);
            }
            String defaultValue = this.m_defaultValues.get(resourceName);
            if (defaultValue == null) {
                return "{" + resourceName + "." + property + "}";
            }
            if ("null".equals(defaultValue)) {
                return null;
            }
            return defaultValue;
        }
    }

    protected String processPropertyLink(String resourceName, String literal, Locale locale, boolean withError, int stackSize) {
        if (literal != null) {
            if (stackSize > 20) {
                throw new Error("Recursion when resolving linked literal definition: " + resourceName + ", " + literal + ", " + locale.getLanguage());
            }
            if (literal.startsWith("!>")) {
                literal = literal.substring("!>".length());
                int colonIndex = literal.indexOf(":");
                String linkedResourceName = resourceName;
                String linkedLiteral = literal;
                if (colonIndex >= 0) {
                    linkedResourceName = literal.substring(0, colonIndex);
                    linkedLiteral = literal.substring(colonIndex + 1);
                }
                return this.readPropertyExecute(linkedResourceName, linkedLiteral, locale, withError, stackSize + 1);
            }
        }
        return literal;
    }

    private String readPropertyValueFromPreProcessor(String resourceName, String property, Locale locale) {
        if (this.m_resourceManagerPreProcessor != null) {
            try {
                return this.m_resourceManagerPreProcessor.instance().readPropertyValue(resourceName, property, locale);
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_INF, "Error received by IResourceManangerPreProcessor " + resourceName + ", " + property + ", " + locale, t);
                return null;
            }
        }
        return null;
    }

    static {
        s_servletContext = null;
    }

    public static class MyParser
    extends DefaultHandler {
        ResourceManager i_instance;

        public MyParser(ResourceManager instance) {
            this.i_instance = instance;
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (name.equals("resource")) {
                String resName = attributes.getValue("name");
                String resPackage = attributes.getValue("package");
                String defaultValue = attributes.getValue("defaultvalue");
                String expression = attributes.getValue("expression");
                this.i_instance.m_resources.put(resName, resPackage);
                if (defaultValue != null) {
                    this.i_instance.m_defaultValues.put(resName, defaultValue);
                }
                if (expression != null) {
                    this.i_instance.m_rrExpressions.put(resName, expression);
                }
                CLog.L.log(CLog.LL_INF, "Resource Manager: added " + resPackage + "." + resName);
            }
        }
    }
}

