/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.streamstore;

import java.util.List;
import java.util.Set;
import org.eclnt.jsfserver.util.WebResourceClassloaderReader;
import org.eclnt.util.log.CLog;

public class StreamStoreConfigPath {
    public void addContainedStreams(List<String> result, String path, boolean withError) {
        block3: {
            try {
                String resourcePath = this.buildRootConfigPathWS() + path;
                Set<String> names = WebResourceClassloaderReader.getFilesInPathDirectory(resourcePath);
                for (String name : names) {
                    if (result.contains(name)) continue;
                    result.add(name);
                }
            }
            catch (Throwable t) {
                if (!withError) break block3;
                CLog.L.log(CLog.LL_INF, "Problem reading contained streams of streamstore: path " + path);
                throw new Error(t);
            }
        }
    }

    public String readUTF8(String path, boolean withError) {
        try {
            String resourcePath = this.buildRootConfigPathWS() + path;
            return WebResourceClassloaderReader.readUTF8FileIntoString(resourcePath, withError);
        }
        catch (Throwable t) {
            if (withError) {
                CLog.L.log(CLog.LL_INF, "Problem reading streamstore: path " + path);
                throw new Error(t);
            }
            return null;
        }
    }

    public byte[] readData(String path, boolean withError) {
        try {
            String resourcePath = this.buildRootConfigPathWS() + path;
            return WebResourceClassloaderReader.readFileIntoByteArray(resourcePath);
        }
        catch (Throwable t) {
            if (withError) {
                CLog.L.log(CLog.LL_INF, "Problem reading streamstore: path " + path);
                throw new Error(t);
            }
            return null;
        }
    }

    private String buildRootConfigPathWS() {
        return "/eclntjsfserver/config/";
    }
}

