/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.streamstore;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclnt.jsfserver.streamstore.IStreamStoreWithBinary;
import org.eclnt.jsfserver.streamstore.StreamStoreConfigPath;
import org.eclnt.jsfserver.util.useraccess.TenantAccessMgr;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;

public class StreamStoreFile
implements IStreamStoreWithBinary {
    String m_rootDirectoryWS;
    boolean m_withTenantManagement = true;
    StreamStoreConfigPath m_streamStoreConfigPath = new StreamStoreConfigPath();

    public void init(String rootDirectoryWS) {
        CLog.L.log(CLog.LL_INF, "Initializing StreamStoreFile for root: " + rootDirectoryWS);
        rootDirectoryWS = ValueManager.convertFileNameToCanonical(rootDirectoryWS, true);
        this.m_rootDirectoryWS = ValueManager.encodeIntoValidFileName(rootDirectoryWS, true);
    }

    public void init(String rootDirectoryWS, boolean withTenantManagement) {
        CLog.L.log(CLog.LL_INF, "Initializing StreamStoreFile for root: " + rootDirectoryWS + ", with tenant management: " + withTenantManagement);
        rootDirectoryWS = ValueManager.convertFileNameToCanonical(rootDirectoryWS, true);
        this.m_rootDirectoryWS = ValueManager.encodeIntoValidFileName(rootDirectoryWS, true);
        this.m_withTenantManagement = withTenantManagement;
    }

    @Override
    public List<String> getContainedStreams(String path, boolean withError) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            path = path.replace('\\', '/');
            String dirName = this.buildRootDirectoryWS() + path;
            List<File> files = FileManager.getFilesOfDirectory(dirName);
            for (File file : files) {
                result.add(file.getName());
            }
            this.m_streamStoreConfigPath.addContainedStreams(result, path, true);
            Collections.sort(result);
            return result;
        }
        catch (Throwable t) {
            if (withError) {
                CLog.L.log(CLog.LL_INF, "Problem reading contained streams of streamstore: path " + path);
                throw new Error(t);
            }
            return null;
        }
    }

    public String getRootDirectory() {
        return this.m_rootDirectoryWS;
    }

    @Override
    public List<String> getContainedFolders(String path, boolean withError) {
        try {
            path = path.replace('\\', '/');
            String dirName = this.buildRootDirectoryWS() + path;
            List<File> directories = FileManager.getDirectoriesOfDirectory(dirName);
            ArrayList<String> result = new ArrayList<String>();
            for (File directory : directories) {
                result.add(directory.getName());
            }
            Collections.sort(result);
            return result;
        }
        catch (Throwable t) {
            if (withError) {
                CLog.L.log(CLog.LL_INF, "Problem reading contained folders of streamstore: path " + path);
                throw new Error(t);
            }
            return new ArrayList<String>();
        }
    }

    @Override
    public String readUTF8(String path, boolean withError) {
        try {
            path = ValueManager.encodeIntoValidFileName(path, false);
            String fileName = this.buildRootDirectoryWS() + path;
            CLog.L.log(CLog.LL_INF, "StreamStoreFile readUTF8: " + fileName);
            if (FileManager.checkIfFileExists(fileName)) {
                return FileManager.readUTF8File(fileName, true);
            }
            return this.m_streamStoreConfigPath.readUTF8(path, withError);
        }
        catch (Throwable t) {
            if (withError) {
                CLog.L.log(CLog.LL_INF, "Problem reading streamstore: path " + path);
                throw new Error(t);
            }
            return null;
        }
    }

    @Override
    public void writeUTF8(String path, String xml, boolean withError) {
        block2: {
            try {
                path = ValueManager.encodeIntoValidFileName(path, false);
                String fileName = this.buildRootDirectoryWS() + path;
                CLog.L.log(CLog.LL_INF, "StreamStoreFile writeUTF8: " + fileName);
                FileManager.ensureDirectoryForFileExists(fileName);
                FileManager.writeUTF8File(fileName, xml, true);
            }
            catch (Throwable t) {
                if (!withError) break block2;
                CLog.L.log(CLog.LL_INF, "Problem writing to streamstore: path " + path);
                throw new Error(t);
            }
        }
    }

    @Override
    public byte[] readData(String path, boolean withError) {
        try {
            path = ValueManager.encodeIntoValidFileName(path, false);
            String fileName = this.buildRootDirectoryWS() + path;
            CLog.L.log(CLog.LL_INF, "StreamStoreFile readData: " + fileName);
            if (FileManager.checkIfFileExists(fileName)) {
                return FileManager.readFile(fileName, true);
            }
            return this.m_streamStoreConfigPath.readData(path, withError);
        }
        catch (Throwable t) {
            if (withError) {
                CLog.L.log(CLog.LL_INF, "Problem reading streamstore: path " + path);
                throw new Error(t);
            }
            return null;
        }
    }

    @Override
    public void writeData(String path, byte[] data, boolean withError) {
        block2: {
            try {
                path = ValueManager.encodeIntoValidFileName(path, false);
                String fileName = this.buildRootDirectoryWS() + path;
                CLog.L.log(CLog.LL_INF, "StreamStoreFile writeData: " + fileName);
                FileManager.ensureDirectoryForFileExists(fileName);
                FileManager.writeFile(fileName, data, true);
            }
            catch (Throwable t) {
                if (!withError) break block2;
                CLog.L.log(CLog.LL_INF, "Problem writing to streamstore: path " + path);
                throw new Error(t);
            }
        }
    }

    @Override
    public void removeStream(String path, boolean withError) {
        try {
            path = ValueManager.encodeIntoValidFileName(path, false);
            String fileName = this.buildRootDirectoryWS() + path;
            CLog.L.log(CLog.LL_INF, "StreamStoreFile removeStream: " + fileName);
            FileManager.deleteFile(fileName);
            File f = new File(fileName);
            while (true) {
                File dir;
                String dirName;
                if (!(dirName = ValueManager.encodeIntoValidFileName((dir = f.getParentFile()).getAbsolutePath(), true)).startsWith(this.m_rootDirectoryWS)) {
                    return;
                }
                List<File> subDirs = FileManager.getDirectoriesOfDirectory(dir.getAbsolutePath());
                if (subDirs.size() > 0) {
                    return;
                }
                List<File> subFiles = FileManager.getFilesOfDirectory(dir.getAbsolutePath());
                if (subFiles.size() > 0) {
                    return;
                }
                FileManager.deleteFile(dir.getAbsolutePath());
                f = dir;
            }
        }
        catch (Throwable t) {
            if (withError) {
                CLog.L.log(CLog.LL_INF, "Problem writing to streamstore: path " + path);
                throw new Error(t);
            }
            return;
        }
    }

    @Override
    public boolean checkIfStreamExists(String path, boolean withError) {
        try {
            path = path.replace('\\', '/');
            String fileName = this.buildRootDirectoryWS() + path;
            return FileManager.checkIfFileExists(fileName);
        }
        catch (Throwable t) {
            if (withError) {
                CLog.L.log(CLog.LL_INF, "Problem when checking if stream exsits: path " + path);
                throw new Error(t);
            }
            return false;
        }
    }

    private String buildRootDirectoryWS() {
        if (!this.m_withTenantManagement) {
            return this.m_rootDirectoryWS;
        }
        String tenant = TenantAccessMgr.getCurrentTenant();
        if ("undefined".equals(tenant)) {
            return this.m_rootDirectoryWS;
        }
        return this.m_rootDirectoryWS + "TENANT_" + tenant + "/";
    }
}

