/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import java.util.ArrayList;
import java.util.List;
import org.eclnt.jsfserver.util.ClientGridDataRow;
import org.eclnt.util.valuemgmt.ValueManager;

public class ClientGridData {
    List<String> m_titles = new ArrayList<String>();
    List<String> m_widths = new ArrayList<String>();
    List<String> m_minScreenWidths = new ArrayList<String>();
    List<Boolean> m_demandPopupins = new ArrayList<Boolean>();
    List<ClientGridDataRow> m_rows = new ArrayList<ClientGridDataRow>();

    public static void main(String[] args) {
        ClientGridData g = new ClientGridData();
        g.addRow(new ClientGridDataRow().addValue("V1").addValue("V2")).addRow(new ClientGridDataRow().addValue("V3").addValue("V4"));
        System.out.println(g.getConfigXML());
        System.out.println(g.getModelXML());
    }

    public List<ClientGridDataRow> getRows() {
        return this.m_rows;
    }

    public void setRows(List<ClientGridDataRow> rows) {
        this.m_rows = rows;
    }

    public ClientGridData addColumn(String title, String width) {
        this.m_titles.add(title);
        this.m_widths.add(width);
        this.m_minScreenWidths.add(null);
        this.m_demandPopupins.add(false);
        return this;
    }

    public ClientGridData addColumn(String title, String width, String minScreenWidth, boolean demandPopin) {
        this.m_titles.add(title);
        this.m_widths.add(width);
        this.m_minScreenWidths.add(minScreenWidth);
        this.m_demandPopupins.add(demandPopin);
        return this;
    }

    public String getTitles() {
        return ValueManager.encodeCSV(this.m_titles);
    }

    public String getWidths() {
        return ValueManager.encodeCSV(this.m_widths);
    }

    public String getMinScreenWidths() {
        return ValueManager.encodeCSV(this.m_widths);
    }

    public String getDemandPopins() {
        return ValueManager.encodeCSV(this.m_widths);
    }

    public ClientGridData addRow(ClientGridDataRow row) {
        this.m_rows.add(row);
        return this;
    }

    public String getConfigXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<clientgridconfig>\n");
        for (int i = 0; i < this.m_titles.size(); ++i) {
            sb.append("<column>\n");
            sb.append("  <width>" + this.m_widths.get(i) + "</width>\n");
            sb.append("  <title>" + this.m_titles.get(i) + "</title>\n");
            sb.append("  <minscreenwidth>" + this.m_minScreenWidths.get(i) + "</minscreenwidth>\n");
            sb.append("  <demandpopin>" + this.m_demandPopupins.get(i) + "</demandpopin>\n");
            sb.append("</column>\n");
        }
        sb.append("</clientgridconfig>\n");
        return sb.toString();
    }

    public String getModelXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<clientgrid>\n");
        for (ClientGridDataRow row : this.m_rows) {
            row.toXML(sb);
        }
        sb.append("</clientgrid>\n");
        return sb.toString();
    }
}

