/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.xml.parsers.SAXParser;
import org.eclnt.jsfserver.configuration.CCConfigurationObjectLoader;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.IClientI18NCountriesUpdate;
import org.eclnt.jsfserver.util.IClientI18NLiteralsUpdate;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.jsfserver.util.WebResourceClassloaderReader;
import org.eclnt.jsfserver.util.parse.SAXParserCreator;
import org.eclnt.util.log.CLog;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ClientI18NReader {
    public static final String COUNTRY_decimalSeparator = "decimalSeparator";
    public static final String COUNTRY_thousandsSeparator = "thousandsSeparator";
    public static final String COUNTRY_dateSeparator = "dateSeparator";
    public static final String COUNTRY_timeSeparator = "timeSeparator";
    public static final String COUNTRY_ymdSequence = "ymdSequence";
    static String s_result = null;
    static Map<String, Object> s_resultMap = null;
    static final Object s_syncher = new Object();
    static Set<String> s_countries = new HashSet<String>();
    static Set<String> s_languages = new HashSet<String>();

    public static void init(ServletContext servletContext) {
        ClientI18NReader.buildI18NJson(servletContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String buildI18NJson(ServletContext servletContext) {
        if (s_result == null) {
            Object object = s_syncher;
            synchronized (object) {
                if (s_result == null) {
                    if (servletContext == null) {
                        servletContext = HttpSessionAccess.getServletContext();
                    }
                    Gson g = new GsonBuilder().setPrettyPrinting().create();
                    Map<String, Object> map = ClientI18NReader.buildI18NMap(servletContext);
                    s_result = g.toJson(map);
                    s_resultMap = map;
                }
            }
        }
        return s_result;
    }

    public static Set<String> getCountries() {
        ClientI18NReader.init(HttpSessionAccess.getServletContext());
        return s_countries;
    }

    public static Set<String> getLanguages() {
        ClientI18NReader.init(HttpSessionAccess.getServletContext());
        return s_languages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        Object object = s_syncher;
        synchronized (object) {
            s_result = null;
            s_resultMap = null;
            s_languages.clear();
            s_countries.clear();
        }
    }

    public static Map<String, String> getCountryInfoMap(String countryId) {
        ClientI18NReader.init(HttpSessionAccess.getServletContext());
        try {
            Map map = (Map)s_resultMap.get("countries");
            Map result = (Map)map.get(countryId);
            if (result == null) {
                result = (Map)map.get("DE");
            }
            if (result == null) {
                throw new Error("Could not find any country inforamtion");
            }
            return result;
        }
        catch (Throwable t) {
            throw new Error("Could not read country infor for " + countryId);
        }
    }

    private static Map<String, Object> buildI18NMap(ServletContext servletContext) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("countries", ClientI18NReader.transferCountriesMapToJsonMap(ClientI18NReader.getMapCountries(servletContext)));
        result.put("languages", ClientI18NReader.transferLiteralsMapToJsonMap(ClientI18NReader.getMapLanguages(servletContext)));
        return result;
    }

    private static Map<String, CountryInfo> getMapCountries(ServletContext servletContext) {
        Map<String, CountryInfo> result = ClientI18NReader.readMapCountriesByInternalData(servletContext);
        try {
            if (SystemXml.getClientCountriesUpdateClass() != null) {
                IClientI18NCountriesUpdate upd = (IClientI18NCountriesUpdate)CCConfigurationObjectLoader.instance().loadInstance(SystemXml.getClientCountriesUpdateClass(), true);
                upd.updateCountryInfo(result);
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem executing implementation of IClientI18NLiteralsUpdate", t);
        }
        return result;
    }

    private static Map<String, CountryInfo> readMapCountriesByInternalData(ServletContext servletContext) {
        s_countries.clear();
        HashMap<String, CountryInfo> countriesMap = new HashMap<String, CountryInfo>();
        Set<String> xmlFileNames = WebResourceClassloaderReader.getFilesInPathDirectory("/eclnt/risc/i18n", ".xml");
        for (String xmlFileName : xmlFileNames) {
            try {
                if (!xmlFileName.startsWith("country_")) continue;
                String country = xmlFileName.substring("country_".length(), xmlFileName.length() - 4);
                String xml = WebResourceClassloaderReader.readUTF8FileIntoString("/eclnt/risc/i18n/" + xmlFileName, true);
                SAXParser parser = SAXParserCreator.createSAXParser();
                InputSource is = new InputSource(new StringReader(xml));
                CountryParser cp = new CountryParser();
                parser.parse(is, (DefaultHandler)cp);
                countriesMap.put(country, cp.i_country);
                s_countries.add(country);
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_WAR, "Problem when processing file: " + xmlFileName, t);
            }
        }
        for (String country : s_countries) {
            CountryInfo ci = (CountryInfo)countriesMap.get(country);
            if (ci.reference == null) continue;
            CountryInfo refCi = (CountryInfo)countriesMap.get(ci.reference);
            if (refCi != null) {
                countriesMap.put(country, refCi);
                continue;
            }
            CLog.L.log(CLog.LL_ERR, "Wrong country setup: " + country + ", reference not avaliable: " + ci.reference);
        }
        return countriesMap;
    }

    private static Map<String, Object> transferLiteralsMapToJsonMap(Map<String, LanguageInfo> mapLanguages) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String language : mapLanguages.keySet()) {
            LanguageInfo li = mapLanguages.get(language);
            result.put(language, li.toJsonMap());
        }
        return result;
    }

    private static Map<String, Object> transferCountriesMapToJsonMap(Map<String, CountryInfo> mapCountries) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String country : mapCountries.keySet()) {
            CountryInfo ci = mapCountries.get(country);
            result.put(country, ci.toJsonMap());
        }
        return result;
    }

    private static Map<String, LanguageInfo> getMapLanguages(ServletContext servletContext) {
        Map<String, LanguageInfo> result = ClientI18NReader.readMapLanguagesByInternalData(servletContext);
        try {
            if (SystemXml.getClientLiteralsUpdateClass() != null) {
                IClientI18NLiteralsUpdate upd = (IClientI18NLiteralsUpdate)CCConfigurationObjectLoader.instance().loadInstance(SystemXml.getClientLiteralsUpdateClass(), true);
                upd.updateLiteralInfo(result);
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem executing implementation of IClientI18NLiteralsUpdate", t);
        }
        return result;
    }

    private static Map<String, LanguageInfo> readMapLanguagesByInternalData(ServletContext servletContext) {
        HashMap<String, LanguageInfo> result = new HashMap<String, LanguageInfo>();
        Set<String> xmlFileNames = WebResourceClassloaderReader.getFilesInPathDirectory("/eclnt/risc/i18n", ".xml");
        for (String xmlFileName : xmlFileNames) {
            try {
                if (!xmlFileName.startsWith("language_")) continue;
                String language = xmlFileName.substring("language_".length(), xmlFileName.length() - 4);
                String xml = WebResourceClassloaderReader.readUTF8FileIntoString("/eclnt/risc/i18n/" + xmlFileName, true);
                SAXParser parser = SAXParserCreator.createSAXParser();
                InputSource is = new InputSource(new StringReader(xml));
                LanguageParser lp = new LanguageParser();
                parser.parse(is, (DefaultHandler)lp);
                result.put(language, lp.i_languageInfo);
                ClientI18NReader.addClientErrorTexts("clienterrorscreen", language, lp.i_languageInfo.getLiterals());
                ClientI18NReader.addClientErrorTexts("clienterrorscreensessiontimeout", language, lp.i_languageInfo.getLiterals());
                s_languages.add(language);
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_WAR, "Problem when processing file: " + xmlFileName, t);
            }
        }
        return result;
    }

    private static void addClientErrorTexts(String name, String language, Map<String, String> map) {
        block4: {
            try {
                String txt = WebResourceClassloaderReader.readUTF8FileIntoString("/eclntjsfserver/config/" + name + "_" + language + ".txt", true);
                map.put(name, txt);
            }
            catch (Throwable t) {
                if (!"en".equals(language) && !"de".equals(language)) break block4;
                try {
                    String txt = WebResourceClassloaderReader.readUTF8FileIntoString("/eclntjsfserver/config/" + name + ".txt", true);
                    map.put(name, txt);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public static class LanguageInfo {
        List<String> m_monthNames = new ArrayList<String>();
        List<String> m_weekdayNamesShort = new ArrayList<String>();
        Map<String, String> m_literals = new HashMap<String, String>();

        public List<String> getMonthNames() {
            return this.m_monthNames;
        }

        public List<String> getWeekdayNamesShort() {
            return this.m_weekdayNamesShort;
        }

        public Map<String, String> getLiterals() {
            return this.m_literals;
        }

        public Map<String, Object> toJsonMap() {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("monthNames", this.m_monthNames);
            result.put("weekdayNamesShort", this.m_weekdayNamesShort);
            result.put("literals", this.m_literals);
            return result;
        }
    }

    static class LanguageParser
    extends DefaultHandler {
        LanguageInfo i_languageInfo = new LanguageInfo();

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (name.equals("monthName")) {
                this.i_languageInfo.getMonthNames().add(attributes.getValue("text"));
            } else if (name.equals("weekdayNameShort")) {
                this.i_languageInfo.getWeekdayNamesShort().add(attributes.getValue("text"));
            } else if (name.equals("literal")) {
                String id = attributes.getValue("id");
                String text = attributes.getValue("text");
                this.i_languageInfo.getLiterals().put(id, text);
            }
        }
    }

    static class CountryParser
    extends DefaultHandler {
        CountryInfo i_country = new CountryInfo();

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (name.equals("country")) {
                this.i_country.reference = attributes.getValue("reference");
                this.i_country.decimalSeparator = attributes.getValue(ClientI18NReader.COUNTRY_decimalSeparator);
                this.i_country.thousandsSeparator = attributes.getValue(ClientI18NReader.COUNTRY_thousandsSeparator);
                this.i_country.dateSeparator = attributes.getValue(ClientI18NReader.COUNTRY_dateSeparator);
                this.i_country.timeSeparator = attributes.getValue(ClientI18NReader.COUNTRY_timeSeparator);
                this.i_country.ymdSequence = attributes.getValue(ClientI18NReader.COUNTRY_ymdSequence);
            }
        }
    }

    public static class CountryInfo {
        public String reference;
        public String decimalSeparator;
        public String thousandsSeparator;
        public String dateSeparator;
        public String timeSeparator;
        public String ymdSequence;

        public Map<String, String> toJsonMap() {
            HashMap<String, String> countryMap = new HashMap<String, String>();
            countryMap.put(ClientI18NReader.COUNTRY_decimalSeparator, this.decimalSeparator);
            countryMap.put(ClientI18NReader.COUNTRY_thousandsSeparator, this.thousandsSeparator);
            countryMap.put(ClientI18NReader.COUNTRY_dateSeparator, this.dateSeparator);
            countryMap.put(ClientI18NReader.COUNTRY_timeSeparator, this.timeSeparator);
            countryMap.put(ClientI18NReader.COUNTRY_ymdSequence, this.ymdSequence);
            return countryMap;
        }
    }
}

