/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclnt.jsfserver.util.WebResourceClassloaderReader;
import org.eclnt.jsfserver.util.parse.SAXParserUtil;
import org.eclnt.util.file.ClassloaderReader;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FacesConfigReader {
    static final Object s_syncher = new Object();
    static Map<String, ManagedBean> s_managedBeans = null;
    static boolean s_initialized = false;

    public static ManagedBean getManagedBean(String name) {
        FacesConfigReader.initialize();
        return s_managedBeans.get(name);
    }

    public static List<ManagedBean> getManagedBeans() {
        FacesConfigReader.initialize();
        ArrayList<ManagedBean> result = new ArrayList<ManagedBean>();
        result.addAll(s_managedBeans.values());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initialize() {
        if (!s_initialized) {
            Object object = s_syncher;
            synchronized (object) {
                if (!s_initialized) {
                    FacesConfigReader.initializeExecute();
                }
                s_initialized = true;
            }
        }
    }

    private static synchronized void initializeExecute() {
        if (s_managedBeans != null) {
            return;
        }
        try {
            s_managedBeans = new HashMap<String, ManagedBean>();
            String xml = FacesConfigReader.readAllFacesConfigXMLs();
            Map<String, ManagedBean> mbs = FacesConfigReader.parseFacesConfigXMLContent(xml);
            for (String key : mbs.keySet()) {
                s_managedBeans.put(key, mbs.get(key));
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "error when reading and parsing WEB-INF/faces-config.xml");
            throw new Error(t);
        }
    }

    private static String readAllFacesConfigXMLs() {
        List<String> jarXMLs;
        StringBuffer sb = new StringBuffer();
        sb.append("<all>");
        try {
            jarXMLs = new ClassloaderReader().readUTF8Files("META-INF/faces-config.xml", true);
            for (String xml : jarXMLs) {
                sb.append(FacesConfigReader.unstripXMLContent(xml));
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem reading the faces-config.xml from jar files", t);
        }
        try {
            jarXMLs = new ClassloaderReader().readUTF8Files("META-INF/ccfaces-config.xml", true);
            for (String xml : jarXMLs) {
                sb.append(FacesConfigReader.unstripXMLContent(xml));
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem reading the ccfaces-config.xml from jar files", t);
        }
        String xml = WebResourceClassloaderReader.readUTF8FileIntoString("/WEB-INF/faces-config.xml", false);
        if (!ValueManager.isEmpty(xml)) {
            sb.append(FacesConfigReader.unstripXMLContent(xml));
        }
        if (!ValueManager.isEmpty(xml = WebResourceClassloaderReader.readUTF8FileIntoString("/WEB-INF/ccfaces-config.xml", false))) {
            sb.append(FacesConfigReader.unstripXMLContent(xml));
        }
        sb.append("</all>");
        return sb.toString();
    }

    private static String unstripXMLContent(String xml) {
        if (xml == null) {
            return null;
        }
        int index = xml.indexOf("?>");
        if (index >= 0) {
            return xml.substring(index + 2);
        }
        return xml;
    }

    public static synchronized void addFacesConfigXMLContent(String xml) {
        FacesConfigReader.initialize();
        try {
            Map<String, ManagedBean> mbs = FacesConfigReader.parseFacesConfigXMLContent(xml);
            for (String key : mbs.keySet()) {
                s_managedBeans.put(key, mbs.get(key));
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "error when parsing additional faces-config.xml content");
            throw new Error(t);
        }
    }

    public static Map<String, ManagedBean> parseFacesConfigXMLContent(String xml) {
        try {
            FacesConfigParser fcp = new FacesConfigParser();
            SAXParserUtil.parse(xml, (DefaultHandler)fcp);
            return fcp.i_managedBeans;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "error when parsing faces-config.xml content");
            throw new Error("error when parsing faces-config.xml content", t);
        }
    }

    public static ManagedBean getManagedBeanFromFacesConfigXml(String xml, String beanName) {
        Map<String, ManagedBean> m = FacesConfigReader.parseFacesConfigXMLContent(xml);
        return m.get(beanName);
    }

    static class FacesConfigParser
    extends DefaultHandler {
        String i_currentTagCharacters;
        ManagedBean i_currentMB;
        Map<String, ManagedBean> i_managedBeans = new HashMap<String, ManagedBean>();

        FacesConfigParser() {
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (name.equals("managed-bean")) {
                ManagedBean mb;
                this.i_currentMB = mb = new ManagedBean();
            }
            this.i_currentTagCharacters = "";
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.i_currentTagCharacters = this.i_currentTagCharacters + new String(ch, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            if (name.equals("managed-bean-name")) {
                this.i_currentMB.m_name = this.i_currentTagCharacters;
                this.i_managedBeans.put(this.i_currentMB.m_name, this.i_currentMB);
            } else if (name.equals("managed-bean-class")) {
                this.i_currentMB.m_className = this.i_currentTagCharacters;
            } else if (name.equals("managed-bean-class")) {
                this.i_currentMB.m_className = this.i_currentTagCharacters;
            } else if (name.equals("managed-bean-scope")) {
                this.i_currentMB.m_scope = this.i_currentTagCharacters;
            }
        }
    }

    public static class ManagedBean
    implements Serializable {
        public String m_name;
        public String m_className;
        public String m_scope;

        public String getName() {
            return this.m_name;
        }

        public String getClassName() {
            return this.m_className;
        }

        public String getScope() {
            return this.m_scope;
        }
    }
}

