/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import javax.el.StandardELContext;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import org.eclnt.jsfserver.util.StackedValueExpression;
import org.eclnt.jsfserver.util.el.ExpressionVariableFinderCL;

public class StackedComplexValueExpressionEL
extends ValueExpression {
    Application m_app;
    String m_vbStringOriginal;
    String m_vbStringUpdated;
    ExpressionFactory m_expressionFactory;
    Set<String> m_insideValueExpressions = new HashSet<String>();
    Map<String, String> m_insideValueExpressions2DirectReference = new HashMap<String, String>();

    public StackedComplexValueExpressionEL(Application app, String vbString) {
        if (vbString == null) {
            throw new Error("Value binding string must not be null");
        }
        if (vbString.length() == 0) {
            throw new Error("Value binding string must not be empty");
        }
        this.m_app = app;
        this.m_vbStringOriginal = vbString;
        StackedComplexValueExpressionEL.parseString(this.m_vbStringOriginal, this.m_insideValueExpressions);
        this.m_vbStringUpdated = this.m_vbStringOriginal;
        for (String insideVE : this.m_insideValueExpressions) {
            String insideVEDirect = this.updateVariableIntoDirectReference(insideVE);
            this.m_insideValueExpressions2DirectReference.put(insideVE, insideVEDirect);
            this.m_vbStringUpdated = this.m_vbStringUpdated.replace(insideVE, insideVEDirect);
        }
    }

    private String updateVariableIntoDirectReference(String insideVE) {
        String result = insideVE;
        if (result != null) {
            result = result.replaceAll("[^A-Za-z0-9]", "X");
        }
        return result;
    }

    public Object getValue(ELContext arg0) throws NullPointerException, PropertyNotFoundException, ELException {
        try {
            HashMap<String, Object> valueMap = new HashMap<String, Object>();
            for (String string : this.m_insideValueExpressions) {
                String insideVEDirect = this.m_insideValueExpressions2DirectReference.get(string);
                StackedValueExpression ve = new StackedValueExpression(this.m_app, "#{" + string + "}");
                Object value = ve.getValue(arg0);
                valueMap.put(insideVEDirect, value);
            }
            if (this.m_expressionFactory == null) {
                this.m_expressionFactory = ExpressionFactory.newInstance();
            }
            StandardELContext context = new StandardELContext(this.m_expressionFactory);
            for (String key : valueMap.keySet()) {
                Object value = valueMap.get(key);
                context.getELResolver().setValue((ELContext)context, null, (Object)key, value);
            }
            ValueExpression valueExpression = this.m_expressionFactory.createValueExpression((ELContext)context, this.m_vbStringUpdated, String.class);
            String result = (String)valueExpression.getValue((ELContext)context);
            return result;
        }
        catch (Throwable t) {
            throw new Error("Error when resolving the expression: " + this.m_vbStringOriginal, t);
        }
    }

    public Class<?> getExpectedType() {
        return Boolean.TYPE;
    }

    public Class<?> getType(ELContext arg0) throws NullPointerException, PropertyNotFoundException, ELException {
        return Boolean.TYPE;
    }

    public boolean isReadOnly(ELContext arg0) throws NullPointerException, PropertyNotFoundException, ELException {
        return true;
    }

    public void setValue(ELContext arg0, Object arg1) throws NullPointerException, PropertyNotFoundException, PropertyNotWritableException, ELException {
        throw new Error("Not supported with complex expression");
    }

    public boolean equals(Object arg0) {
        throw new Error("Not supported with complex expression");
    }

    public String getExpressionString() {
        return this.m_vbStringOriginal;
    }

    public int hashCode() {
        return this.m_vbStringOriginal.hashCode();
    }

    public boolean isLiteralText() {
        return false;
    }

    public static void junit_parseString(String s, Set<String> result) {
        StackedComplexValueExpressionEL.parseString(s, result);
    }

    private static void parseString(String s, Set<String> result) {
        try {
            List<String> variables = StackedComplexValueExpressionEL.findVariables(s);
            result.addAll(variables);
        }
        catch (Throwable t) {
            throw new Error("Problem parsing expression: " + s, t);
        }
    }

    private static List<String> findVariables(String expression) {
        return ExpressionVariableFinderCL.findVariables(expression);
    }
}

