/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import java.util.ArrayList;
import java.util.List;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import org.eclnt.jsfserver.defaultscreens.ShowServerError;
import org.eclnt.jsfserver.elements.ApplicationErrorInfoDuringSet;
import org.eclnt.jsfserver.elements.impl.FIXGRIDItem;
import org.eclnt.jsfserver.util.CCELResolver;
import org.eclnt.jsfserver.util.ExpressionManagerV;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.IPropertyResolverAware2;
import org.eclnt.jsfserver.util.StackedComplexValueExpressionEL;
import org.eclnt.jsfserver.util.StackedMethodExpression;
import org.eclnt.jsfserver.util.StackedValueKeeper;
import org.eclnt.jsfserver.util.VersionXml;
import org.eclnt.jsfserver.util.el.ExpressionChecker;
import org.eclnt.util.log.CLog;
import org.eclnt.util.logdt.DTLogFactory;
import org.eclnt.util.logdt.ENUMLogCategory;

public class StackedValueExpression
extends ValueExpression {
    ValueExpression m_delegate;
    String[] m_tokens;
    transient int[] m_tokenIds;
    transient Application m_app;
    transient Class m_valueClass;
    transient boolean m_valueClassWasFoundByReflection = true;
    transient boolean m_flagSetMayFail = false;
    transient boolean m_expressionIsValid = true;
    transient String m_invalidVbString = null;

    public StackedValueExpression(Application app, String vbString) {
        if (CLog.L.isLoggable(CLog.LL_DBG)) {
            CLog.L.log(CLog.LL_DBG, "StackedValueExpression: creating expression " + vbString);
        }
        ExpressionChecker.CheckResult cr = ExpressionChecker.instance().checkExpression(vbString);
        this.m_expressionIsValid = cr.expressionIsValid;
        if (this.m_expressionIsValid) {
            if (cr.expressionIsComplex) {
                if (!VersionXml.checkIfOwnUIImplementation()) {
                    this.m_delegate = app.getExpressionFactory().createValueExpression(HttpSessionAccess.getCurrentFacesContext().getELContext(), vbString, Object.class);
                    CLog.L.log(CLog.LL_DBG, "Expression detected for which non-optimized value expression is used: " + vbString);
                    return;
                }
                try {
                    this.m_delegate = new StackedComplexValueExpressionEL(app, vbString);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (this.m_delegate == null) {
                    throw new Error("Could not interpret expression: " + vbString);
                }
            }
            this.m_app = app;
            this.m_tokens = ExpressionManagerV.buildTokens(vbString);
        } else {
            this.m_invalidVbString = vbString;
        }
    }

    public String[] getTokens() {
        return this.m_tokens;
    }

    public boolean getFlagSetMayFail() {
        return this.m_flagSetMayFail;
    }

    public void setFlagSetMayFail(boolean flagSetMayFail) {
        this.m_flagSetMayFail = flagSetMayFail;
    }

    public boolean equals(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (arg0 == this) {
            return true;
        }
        if (!(arg0 instanceof StackedValueExpression)) {
            return false;
        }
        StackedValueExpression svearg0 = (StackedValueExpression)((Object)arg0);
        return this.getExpressionString().equals(svearg0.getExpressionString());
    }

    public Class<?> getType(ELContext elContext) throws NullPointerException, PropertyNotFoundException, ELException {
        if (!this.m_expressionIsValid) {
            return String.class;
        }
        if (this.m_delegate != null) {
            return this.m_delegate.getType(elContext);
        }
        this.m_valueClass = null;
        this.rebuildTokenIds();
        this.getValue(elContext);
        return this.m_valueClass;
    }

    public Class<?> getExpectedType() {
        ELContext elContext = HttpSessionAccess.getCurrentFacesContext().getELContext();
        return this.getType(elContext);
    }

    public String getExpressionString() {
        if (this.m_delegate != null) {
            return this.m_delegate.getExpressionString();
        }
        if (this.m_tokens == null) {
            return this.m_invalidVbString;
        }
        this.rebuildTokenIds();
        StringBuffer result = new StringBuffer();
        result.append("#{");
        int counter = 0;
        for (String token : this.m_tokens) {
            if (counter != 0) {
                result.append(".");
            }
            result.append(token);
            ++counter;
        }
        result.append("}");
        return result.toString();
    }

    public Object getValue(ELContext elContext) throws NullPointerException, PropertyNotFoundException, ELException {
        return this.getValue(elContext, false);
    }

    public Object getValue(ELContext elContext, boolean withError) throws NullPointerException, PropertyNotFoundException, ELException {
        CCELResolver.passCurrentValueExpressionBegin(this);
        try {
            if (!this.m_expressionIsValid) {
                CLog.L.log(CLog.LL_ERR, "Invalid expression detected: " + this.getExpressionString());
                DTLogFactory.getLog().log(ENUMLogCategory.PROPERTYERROR_IMPL, this.m_invalidVbString, "Expression contains invalid characters", null);
                String string = "Invalid expression detected.";
                return string;
            }
            if (this.m_delegate != null) {
                Object object = this.m_delegate.getValue(elContext);
                return object;
            }
            this.rebuildTokenIds();
            StackedValueKeeper svk = StackedValueKeeper.getInstance();
            StackedValueKeeper.PickResult svkPR = svk.pickValueById(this.m_tokenIds, this.m_tokens);
            Object currentValue = svkPR.getValue();
            ELResolver elResolver = this.m_app.getELResolver();
            for (int i = svkPR.getLevel() + 1; i < this.m_tokens.length; ++i) {
                String token = this.m_tokens[i];
                if (i > 0 && currentValue == null) {
                    String expression = null;
                    if (CCELResolver.getCurrentMethodExpression() != null) {
                        expression = CCELResolver.getCurrentMethodExpression().getExpressionString();
                        DTLogFactory.getLog().log(ENUMLogCategory.METHODERROR_NULL, expression, this.m_tokens[i - 1] + " is null", null);
                    } else {
                        String prevToken = this.m_tokens[i - 1];
                        if (!(prevToken.startsWith("rows[") || prevToken.startsWith("modelessPopups[") || prevToken.startsWith("modalPopups["))) {
                            expression = this.getExpressionString();
                            DTLogFactory.getLog().log(ENUMLogCategory.PROPERTYERROR_NULL, this.getExpressionString(), this.m_tokens[i - 1] + " is null", null);
                        }
                    }
                    if (!withError) break;
                    throw new NullPointerException();
                }
                if (token.charAt(token.length() - 1) == ']') {
                    Object arrayValue;
                    String arrayName;
                    boolean useArrayBinding = false;
                    if (this.checkIfArrayToken(token)) {
                        useArrayBinding = true;
                    }
                    if (useArrayBinding) {
                        try {
                            int index = token.indexOf(91);
                            arrayName = token.substring(0, index);
                            arrayValue = elResolver.getValue(elContext, currentValue, (Object)arrayName);
                            int arrayIndex = Integer.valueOf(this.isolateArrayIndexString(token, index));
                            if (this.m_valueClass == null && i == this.m_tokens.length - 1) {
                                this.m_valueClass = elResolver.getType(elContext, arrayValue, (Object)arrayIndex);
                                if (this.m_valueClass == Object.class) {
                                    this.m_valueClass = null;
                                }
                            }
                            currentValue = elResolver.getValue(elContext, arrayValue, (Object)arrayIndex);
                        }
                        catch (NumberFormatException nfe) {
                            useArrayBinding = false;
                        }
                    }
                    if (!useArrayBinding) {
                        int index = token.indexOf(91);
                        arrayName = token.substring(0, index);
                        arrayValue = elResolver.getValue(elContext, currentValue, (Object)arrayName);
                        String arrayKey = this.isolateKeyString(token, index);
                        if (this.m_valueClass == null && i == this.m_tokens.length - 1) {
                            this.m_valueClass = elResolver.getType(elContext, arrayValue, (Object)arrayKey);
                            if (this.m_valueClass == Object.class) {
                                this.m_valueClass = null;
                            }
                        }
                        currentValue = elResolver.getValue(elContext, arrayValue, (Object)arrayKey);
                    }
                } else {
                    if (this.m_valueClass == null && i == this.m_tokens.length - 1) {
                        this.m_valueClass = elResolver.getType(elContext, currentValue, (Object)token);
                        if (this.m_valueClass == Object.class) {
                            this.m_valueClass = null;
                        }
                    }
                    currentValue = elResolver.getValue(elContext, currentValue, (Object)token);
                }
                if (i >= this.m_tokenIds.length) continue;
                svk.addValue(currentValue, this.m_tokenIds[i], i);
            }
            if (this.m_valueClass == null && currentValue != null) {
                this.m_valueClass = currentValue.getClass();
            }
            Object object = currentValue;
            return object;
        }
        catch (Throwable t) {
            if (!withError) {
                if (CLog.L.isLoggable(CLog.LL_INF)) {
                    CLog.L.log(CLog.LL_INF, "Problems getting property: " + this.getExpressionString() + ", " + t.toString(), t);
                }
                Object var4_8 = null;
                return var4_8;
            }
            throw new PropertyNotFoundException("Problems getting property: " + this.getExpressionString(), t);
        }
        finally {
            CCELResolver.passCurrentValueExpressionEnd();
        }
    }

    public int hashCode() {
        return this.getExpressionString().hashCode();
    }

    public boolean isLiteralText() {
        return false;
    }

    public boolean isReadOnly(ELContext arg0) throws NullPointerException, PropertyNotFoundException, ELException {
        return false;
    }

    public void setValue(ELContext elContext, Object value) throws NullPointerException, PropertyNotFoundException, PropertyNotWritableException, ELException {
        if (!this.m_expressionIsValid) {
            CLog.L.log(CLog.LL_ERR, "Invalid expression detected: " + this.getExpressionString());
            return;
        }
        this.setValue(elContext, value, true);
    }

    public void setValue(ELContext elContext, Object valueToSet, boolean clearStack) throws NullPointerException, PropertyNotFoundException, PropertyNotWritableException, ELException {
        if (!this.m_expressionIsValid) {
            CLog.L.log(CLog.LL_ERR, "Invalid expression detected: " + this.getExpressionString());
            return;
        }
        try {
            CCELResolver.passCurrentValueExpressionBegin(this);
            this.setValueExecute(elContext, valueToSet, clearStack);
        }
        catch (Throwable t) {
            if (this.m_flagSetMayFail) {
                return;
            }
            CLog.L.log(CLog.LL_ERR, "Error happened when setting value: " + this.getExpressionString() + "/" + valueToSet, t);
            String valueName = this.getExpressionString();
            int index = valueName.lastIndexOf(46);
            if (index < 0) {
                throw new Error("Problem to analyze expression: " + valueName);
            }
            List<String> baseExpressions = this.getBaseExpressions(valueName);
            for (int i = 0; i < baseExpressions.size(); ++i) {
                valueName = baseExpressions.get(i) + ".onApplicationErrorDuringSet}";
                CLog.L.log(CLog.LL_ERR, "Try to delegate to " + valueName);
                try {
                    StackedMethodExpression mb = new StackedMethodExpression(this.m_app, valueName);
                    ApplicationErrorInfoDuringSet aei = new ApplicationErrorInfoDuringSet(t, this.getExpressionString(), valueToSet);
                    mb.invoke(elContext, new Object[]{aei});
                    return;
                }
                catch (Throwable throwable) {
                    continue;
                }
            }
            ShowServerError.passThrowable(t);
            if (t instanceof NullPointerException) {
                throw (NullPointerException)t;
            }
            if (t instanceof PropertyNotFoundException) {
                throw (PropertyNotFoundException)t;
            }
            if (t instanceof PropertyNotWritableException) {
                throw (PropertyNotWritableException)t;
            }
            if (t instanceof ELException) {
                throw (ELException)t;
            }
            throw new Error(t);
        }
        finally {
            CCELResolver.passCurrentValueExpressionEnd();
        }
    }

    private void setValueExecute(ELContext elContext, Object valueToSet, boolean clearStack) throws NullPointerException, PropertyNotFoundException, PropertyNotWritableException, ELException {
        if (this.m_delegate != null) {
            this.m_delegate.setValue(elContext, valueToSet);
            return;
        }
        this.rebuildTokenIds();
        ELResolver elResolver = elContext.getELResolver();
        Object currentValue = null;
        for (int i = 0; i < this.m_tokens.length - 1; ++i) {
            String token = this.m_tokens[i];
            if (i == 0) {
                Object value;
                currentValue = value = elResolver.getValue(elContext, null, (Object)token);
            } else {
                if (currentValue == null) break;
                if (token.charAt(token.length() - 1) == ']') {
                    Object arrayValue;
                    String arrayName;
                    int index;
                    boolean useArrayBinding = false;
                    if (this.checkIfArrayToken(token)) {
                        useArrayBinding = true;
                    }
                    if (useArrayBinding) {
                        try {
                            index = token.indexOf(91);
                            arrayName = token.substring(0, index);
                            arrayValue = elResolver.getValue(elContext, currentValue, (Object)arrayName);
                            this.notifyPropertyResolverAwareWithSubObject(arrayValue, valueToSet);
                            int arrayIndex = Integer.valueOf(this.isolateArrayIndexString(token, index));
                            currentValue = elResolver.getValue(elContext, arrayValue, (Object)arrayIndex);
                            if (i == this.m_tokens.length - 1) {
                                this.m_valueClass = elResolver.getType(elContext, arrayValue, (Object)arrayIndex);
                                if (this.m_valueClass == Object.class) {
                                    this.m_valueClass = null;
                                }
                            }
                            this.notifyPropertyResolverAwareWithSubObject(currentValue, valueToSet);
                        }
                        catch (NumberFormatException nfe) {
                            useArrayBinding = false;
                        }
                    }
                    if (!useArrayBinding) {
                        index = token.indexOf(91);
                        arrayName = token.substring(0, index);
                        arrayValue = elResolver.getValue(elContext, currentValue, (Object)arrayName);
                        this.notifyPropertyResolverAwareWithSubObject(arrayValue, valueToSet);
                        String arrayKey = this.isolateKeyString(token, index);
                        currentValue = elResolver.getValue(elContext, arrayValue, (Object)arrayKey);
                        if (i == this.m_tokens.length - 1) {
                            this.m_valueClass = elResolver.getType(elContext, arrayValue, (Object)arrayKey);
                            if (this.m_valueClass == Object.class) {
                                this.m_valueClass = null;
                            }
                        }
                        this.notifyPropertyResolverAwareWithSubObject(currentValue, valueToSet);
                    }
                } else {
                    currentValue = elResolver.getValue(elContext, currentValue, (Object)token);
                    if (i == this.m_tokens.length - 1) {
                        this.m_valueClass = elResolver.getType(elContext, currentValue, (Object)token);
                        if (this.m_valueClass == Object.class) {
                            this.m_valueClass = null;
                        }
                    }
                }
            }
            if (currentValue != null && currentValue instanceof FIXGRIDItem) {
                ((FIXGRIDItem)currentValue).getChangeIndex().indicateChange();
            }
            if (i == this.m_tokens.length - 2) continue;
            this.notifyPropertyResolverAwareWithSubObject(currentValue, valueToSet);
        }
        if (currentValue != null) {
            String token = this.m_tokens[this.m_tokens.length - 1];
            if (token.charAt(token.length() - 1) == ']') {
                Object arrayValue;
                this.notifyPropertyResolverAwareWithSubObject(currentValue, valueToSet);
                boolean useArrayBinding = false;
                if (this.checkIfArrayToken(token)) {
                    useArrayBinding = true;
                }
                if (useArrayBinding) {
                    try {
                        int index = token.indexOf(91);
                        String arrayName = token.substring(0, index);
                        arrayValue = elResolver.getValue(elContext, currentValue, (Object)arrayName);
                        this.notifyPropertyResolverAwareWithSubObject(arrayValue, valueToSet);
                        int arrayIndex = Integer.valueOf(this.isolateArrayIndexString(token, index));
                        elResolver.setValue(elContext, arrayValue, (Object)arrayIndex, valueToSet);
                        this.notifyPropertyResolverAwareWithEndObject(arrayValue, arrayIndex, valueToSet);
                    }
                    catch (NumberFormatException nfe) {
                        useArrayBinding = false;
                    }
                }
                if (!useArrayBinding) {
                    int index = token.indexOf(91);
                    String arrayName = token.substring(0, index);
                    arrayValue = elResolver.getValue(elContext, currentValue, (Object)arrayName);
                    this.notifyPropertyResolverAwareWithSubObject(arrayValue, valueToSet);
                    String arrayKey = this.isolateKeyString(token, index);
                    elResolver.setValue(elContext, arrayValue, (Object)arrayKey, valueToSet);
                    this.notifyPropertyResolverAwareWithEndObject(arrayValue, arrayKey, valueToSet);
                }
            } else {
                elResolver.setValue(elContext, currentValue, (Object)token, valueToSet);
                this.notifyPropertyResolverAwareWithEndObject(currentValue, token, valueToSet);
            }
            CLog.L.log(CLog.LL_INF, "Setting: finished");
        }
        if (clearStack) {
            StackedValueKeeper.getInstance().clearStack();
        }
    }

    private void notifyPropertyResolverAwareWithSubObject(Object currentValue, Object valueToSet) {
        if (currentValue != null && currentValue instanceof IPropertyResolverAware2) {
            IPropertyResolverAware2 pra2 = (IPropertyResolverAware2)currentValue;
            pra2.reactOnSetValueInSubObject(this.getExpressionString(), valueToSet);
        }
    }

    private void notifyPropertyResolverAwareWithEndObject(Object currentValue, String propertyName, Object valueToSet) {
        if (currentValue != null && currentValue instanceof IPropertyResolverAware2) {
            IPropertyResolverAware2 pra2 = (IPropertyResolverAware2)currentValue;
            pra2.reactOnSetValue(this.getExpressionString(), propertyName, valueToSet);
        }
    }

    private void notifyPropertyResolverAwareWithEndObject(Object currentValue, int index, Object valueToSet) {
        if (currentValue != null && currentValue instanceof IPropertyResolverAware2) {
            IPropertyResolverAware2 pra2 = (IPropertyResolverAware2)currentValue;
            pra2.reactOnSetValue(this.getExpressionString(), index, valueToSet);
        }
    }

    private void rebuildTokenIds() {
        if (this.m_tokenIds != null) {
            return;
        }
        this.m_tokenIds = new int[this.m_tokens.length - 1];
        for (int i = 0; i < this.m_tokens.length - 1; ++i) {
            Integer tokenId = StackedValueKeeper.getIdForName(this.m_tokens[i]);
            this.m_tokenIds[i] = tokenId;
            this.m_tokens[i] = StackedValueKeeper.getUniqueNameForId(this.m_tokenIds[i], this.m_tokens[i]);
        }
        Integer tokenId = StackedValueKeeper.getIdForName(this.m_tokens[this.m_tokens.length - 1]);
        this.m_tokens[this.m_tokens.length - 1] = StackedValueKeeper.getUniqueNameForId(tokenId, this.m_tokens[this.m_tokens.length - 1]);
        if (this.m_app == null) {
            this.m_app = HttpSessionAccess.getCurrentFacesContext().getApplication();
        }
    }

    private boolean checkIfArrayToken(String token) {
        int tl = token.length();
        return token.charAt(tl - 2) != '\"' && token.charAt(tl - 2) != '\'' && token.charAt(tl - 2) != ';';
    }

    private String isolateKeyString(String token, int bracketIndex) {
        if (token.charAt(bracketIndex + 1) != '&') {
            return token.substring(bracketIndex + 2, token.length() - 2);
        }
        return token.substring(bracketIndex + 6, token.length() - 6);
    }

    private String isolateArrayIndexString(String token, int bracketIndex) {
        return token.substring(bracketIndex + 1, token.length() - 1);
    }

    private List<String> getBaseExpressions(String expression) {
        ArrayList<String> result = new ArrayList<String>();
        String[] tokens = ExpressionManagerV.buildTokens(expression);
        if (tokens.length > 1) {
            StringBuffer sb = new StringBuffer();
            sb.append("#{");
            for (int i = 0; i < tokens.length - 1; ++i) {
                if (i != 0) {
                    sb.append(".");
                }
                sb.append(tokens[i]);
                result.add(0, sb.toString());
            }
        }
        return result;
    }
}

