/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclnt.jsfserver.elements.BaseComponentTag;
import org.eclnt.jsfserver.managedbean.HotDeployManager;
import org.eclnt.jsfserver.pagebean.component.PageBeanComponentRepository;
import org.eclnt.jsfserver.session.SessionInfo;
import org.eclnt.jsfserver.session.UsageWithoutSessionContext;
import org.eclnt.jsfserver.util.CSSStyleManager;
import org.eclnt.jsfserver.util.ExpressionManagerV;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.ICCServerConstants;
import org.eclnt.jsfserver.util.StyleUtil;
import org.eclnt.jsfserver.util.parse.SAXParserUtil;
import org.eclnt.jsfserver.util.style.StyleFileAccess;
import org.eclnt.util.file.ClassloaderReader;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class StyleManager
implements ICCServerConstants {
    static Object SYNCHER = new Object();
    static Object s_syncherResolveInnerExtensions = new Object();
    static Object s_syncherResolveParentExtensions = new Object();
    static Map<String, Style> s_styles = new Hashtable<String, Style>();
    static Map<String, StyleTagInfo> s_resolvedStyleTagInfos = new Hashtable<String, StyleTagInfo>();
    static Map<String, String> s_bufferedStyleValues = new Hashtable<String, String>();

    public static void reset() {
        s_styles = new Hashtable<String, Style>();
        s_resolvedStyleTagInfos.clear();
        s_bufferedStyleValues.clear();
        try {
            StyleManager.registerStyle("default", false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            StyleManager.registerStyle("defaultfx", false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            StyleManager.registerStyle("defaultrisc", true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String updatePrefix(String tagName) {
        if (ValueManager.isEmpty(tagName)) {
            return null;
        }
        if (tagName.indexOf(58) < 0) {
            return "t:" + tagName;
        }
        return tagName;
    }

    public static StyleTagInfo getTagInfo(String variantName, String tagNameWithPrefix) {
        String styleName = SessionInfo.getSessionInstance().getStyle();
        return StyleManager.getTagInfo(styleName, variantName, tagNameWithPrefix);
    }

    public static String getTagAttributeValue(String variantName, String tagNameWithPrefix, String attributeName) {
        StyleTagInfo tagInfo = StyleManager.getTagInfo(variantName, tagNameWithPrefix);
        if (tagInfo == null) {
            return null;
        }
        StyleAttributeValue av = tagInfo.getAttributes().get(attributeName);
        if (av == null) {
            return null;
        }
        return av.getValue();
    }

    public static String getStyleValue(String valueName) {
        String styleName = SessionInfo.getSessionInstance().getStyle();
        String key = styleName + "/" + valueName;
        String bufferedResult = s_bufferedStyleValues.get(key);
        if (bufferedResult != null) {
            return bufferedResult;
        }
        String result = StyleManager.getStyleValue(styleName, valueName);
        if (result == null && !valueName.startsWith("@") && !valueName.endsWith("@")) {
            result = StyleManager.getStyleValue(styleName, "@" + valueName + "@");
        }
        if (result != null) {
            s_bufferedStyleValues.put(key, result);
        }
        return result;
    }

    public static String getStyleValue(String styleName, String valueName) {
        try {
            StyleManager.registerStyle(styleName);
            Style style = s_styles.get(styleName);
            StyleUtil.ColorUpdateInfo colorUpdateInfo = StyleUtil.findColorUpdateIfColor(valueName);
            valueName = colorUpdateInfo.updatedValue;
            StyleValue sv = style.i_styleValues.get(valueName);
            String result = null;
            result = sv == null ? (style.i_extends != null ? StyleManager.getStyleValue(style.i_extends, valueName) : null) : sv.getValue();
            String currentStyleName = SessionInfo.getSessionInstance().getStyle();
            result = StyleManager.resolveValueWithVariablesInside(currentStyleName, result);
            if (colorUpdateInfo.colorUpdate != 0) {
                result = ValueManager.updateColor(result, colorUpdateInfo.colorUpdate);
            }
            return result;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static Style getStyle(String styleName) {
        try {
            StyleManager.registerStyle(styleName);
            Style result = s_styles.get(styleName);
            return result;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static List<String> getStyleExtensionSequence(String styleName) {
        try {
            ArrayList<String> result = new ArrayList<String>();
            String currentStyleName = styleName;
            while (true) {
                result.add(0, currentStyleName);
                Style style = StyleManager.getStyle(currentStyleName);
                if (style == null) {
                    throw new Error("Could not find style for style name " + currentStyleName);
                }
                if (style.getExtends() == null) break;
                currentStyleName = style.getExtends();
            }
            return result;
        }
        catch (Throwable t) {
            throw new Error("Problem reading style extension sequence for style " + styleName, t);
        }
    }

    private static String resolveValueWithVariablesInside(String styleName, String value) {
        if (value == null) {
            return null;
        }
        int currentIndex = value.indexOf("@");
        if (currentIndex < 0) {
            return value;
        }
        int counter = 0;
        while (true) {
            int nextIndex;
            if (++counter > 100) {
                CLog.L.log(CLog.LL_ERR, "Value resolution in style management aborted after 100 iterations.");
            }
            if ((nextIndex = value.indexOf("@", currentIndex + 1)) < 0) break;
            if (currentIndex < 0) {
                currentIndex = nextIndex;
                continue;
            }
            String variableString = value.substring(currentIndex, nextIndex + 1);
            if (variableString.contains(",") || variableString.contains(";")) {
                currentIndex = nextIndex;
                continue;
            }
            String resolvedValue = StyleManager.getStyleValue(styleName, variableString);
            value = value.substring(0, currentIndex) + resolvedValue + value.substring(nextIndex + 1);
            currentIndex = -1;
        }
        return value;
    }

    public static StyleTagInfo getTagInfo(String styleName, String variantName, String includingPageName, String componentLayoutId, String tagNameWithPrefix) {
        String key = variantName + "_" + includingPageName + "_" + componentLayoutId;
        if (StyleManager.checkIfStyleVariantExists(styleName, key, tagNameWithPrefix)) {
            return StyleManager.getTagInfo(styleName, key, tagNameWithPrefix);
        }
        key = variantName + "_" + includingPageName;
        if (StyleManager.checkIfStyleVariantExists(styleName, key, tagNameWithPrefix)) {
            return StyleManager.getTagInfo(styleName, key, tagNameWithPrefix);
        }
        return StyleManager.getTagInfo(styleName, variantName, tagNameWithPrefix);
    }

    private static boolean checkIfStyleVariantExists(String styleName, String variantName, String tagNameWithPrefix) {
        block3: {
            Style style = StyleManager.getStyle(styleName);
            if (style == null) {
                return false;
            }
            do {
                StyleTagInfo sti;
                StyleVariant sv;
                if ((sv = style.i_variants.get(variantName)) != null && (sti = sv.getStyleTagInfo(tagNameWithPrefix)) != null) {
                    return true;
                }
                if (style.getExtends() == null) break block3;
            } while ((style = StyleManager.getStyle(style.getExtends())) != null);
            return false;
        }
        return false;
    }

    public static StyleTagInfo getTagInfo(String styleName, String variantName, String tagNameWithPrefix) {
        if (variantName == null || !variantName.contains(";")) {
            return StyleManager.getTagInfoNoCSV(styleName, variantName, tagNameWithPrefix);
        }
        String[] variantNames = ValueManager.decodeCSV(variantName);
        StyleTagInfo[] stis = new StyleTagInfo[variantNames.length];
        int counter = 0;
        for (String vn : variantNames) {
            stis[counter] = StyleManager.getTagInfoNoCSV(styleName, vn, tagNameWithPrefix);
            if (stis[counter] == null || stis[counter].getAttributes().size() == 0) {
                stis[counter] = StyleManager.getTagInfoNoCSV(styleName, vn, "t:*");
            }
            ++counter;
        }
        return StyleManager.mergeStyleTagInfos(stis);
    }

    private static StyleTagInfo mergeStyleTagInfos(StyleTagInfo[] stis) {
        StyleTagInfo result = new StyleTagInfo(stis[0].i_style, stis[0].i_variant, stis[0].i_tagName);
        for (StyleTagInfo sti : stis) {
            if (sti == null) continue;
            for (String attribute : sti.getAttributes().keySet()) {
                StyleAttributeValue sav = sti.getAttributes().get(attribute);
                if (sav.i_value != null && sav.i_value.startsWith("(+)")) {
                    StyleAttributeValue savExisting = (StyleAttributeValue)result.getAttributesMap().get(attribute);
                    if (savExisting != null) {
                        savExisting = new StyleAttributeValue(savExisting);
                        if (savExisting.i_value != null) {
                            savExisting.i_value = savExisting.i_value + sav.i_value.substring(3);
                        }
                        result.getAttributesMap().put(attribute, sav);
                        continue;
                    }
                    sav = new StyleAttributeValue(sav);
                    if (sav.i_value != null) {
                        sav.i_value = sav.i_value.substring(3);
                    }
                    result.getAttributesMap().put(attribute, sav);
                    continue;
                }
                result.getAttributesMap().put(attribute, sav);
            }
        }
        return result;
    }

    public static StyleTagInfo getTagInfoNoCSV(String styleName, String variantName, String tagNameWithPrefix) {
        String key;
        StyleTagInfo resolvedResult;
        tagNameWithPrefix = StyleManager.updatePrefix(tagNameWithPrefix);
        if (variantName == null) {
            variantName = "default";
        }
        if ((resolvedResult = s_resolvedStyleTagInfos.get(key = styleName + "/" + variantName + "/" + tagNameWithPrefix)) != null) {
            return resolvedResult;
        }
        try {
            StyleTagInfo result;
            StyleManager.registerStyle(styleName);
            Style style = s_styles.get(styleName);
            StyleVariant styleVariant = style.getVariants().get(variantName);
            if (styleVariant == null) {
                styleVariant = new StyleVariant();
                styleVariant.setVariantName(variantName);
                s_styles.get(styleName).getVariants().put(variantName, styleVariant);
            }
            if ((result = styleVariant.getTagInfos().get(tagNameWithPrefix)) == null) {
                result = new StyleTagInfo(style, styleVariant, tagNameWithPrefix);
                result.setExtendsParentTag(true);
                styleVariant.getTagInfos().put(tagNameWithPrefix, result);
            }
            resolvedResult = new StyleTagInfo(result);
            Map<String, StyleAttributeValue> resultAttributes = result.getAttributes();
            for (String attributeName : resultAttributes.keySet()) {
                StyleAttributeValue sav = resultAttributes.get(attributeName);
                sav = new StyleAttributeValue(sav);
                sav.i_value = StyleManager.resolveValueWithVariablesInside(styleName, sav.i_parsedValue);
                resolvedResult.i_attributes.put(attributeName, sav);
            }
            s_resolvedStyleTagInfos.put(key, resolvedResult);
            return resolvedResult;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static void registerStyle(String styleName) {
        StyleManager.registerStyle(styleName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerStyle(String styleName, boolean withError) {
        if (s_styles.get(styleName) != null) {
            return;
        }
        Object object = SYNCHER;
        synchronized (object) {
            block14: {
                CLog.L.log(CLog.LL_INF, "registerStyle(" + styleName + ") is processed");
                if (s_styles.get(styleName) != null) {
                    return;
                }
                try {
                    CLog.L.log(CLog.LL_INF, "Reading style /eclntjsfserver/styles/" + styleName + "/style.xml");
                    String xml = StyleFileAccess.readStyleUTF8File("/eclntjsfserver/styles/" + styleName + "/style.xml");
                    xml = StyleManager.combineStyleWithAdditionalStyles(xml, styleName, HotDeployManager.currentClassLoader());
                    CLog.L.log(CLog.LL_INF, "Just  reading style file for: " + styleName);
                    if (xml.length() >= 100) {
                        CLog.L.log(CLog.LL_INF, "The first 100 characters are: " + xml.substring(0, 100));
                    } else {
                        CLog.L.log(CLog.LL_INF, "The first 100 characters are: " + xml);
                    }
                    Style style = new Style();
                    style.setStyleName(styleName);
                    SAXParserUtil.parse(xml, (DefaultHandler)new StyleParser(style));
                    try {
                        CLog.L.log(CLog.LL_INF, "Reading CSS style " + styleName);
                        String cssXml = CSSStyleManager.readRiscStyleXML(styleName);
                        if (cssXml != null && cssXml.length() > 0) {
                            SAXParserUtil.parse(cssXml, (DefaultHandler)new CSSStyleParser(style));
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    StyleManager.multiplyOutStyleTagGroupsAfterParsing(style);
                    CLog.L.log(CLog.LL_INF, "Now adding style to map of available styles");
                    s_styles.put(styleName, style);
                }
                catch (Throwable t) {
                    if (withError) {
                        CLog.L.log(CLog.LL_INF, "Could not read style: " + styleName, t);
                        CLog.L.log(CLog.LL_INF, "The style is registered as empty style");
                    }
                    Style style = new Style();
                    style.setStyleName(styleName);
                    s_styles.put(styleName, style);
                    if (UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
                        return;
                    }
                    if (!withError) break block14;
                    throw new Error(t);
                }
            }
        }
    }

    public static List<String> getAvailableRuntimeStyles() {
        return StyleFileAccess.findDirectories("/eclntjsfserver/styles/");
    }

    public static Style readDesignTimeStyle(String styleName, String styleFileName) {
        return StyleManager.readDesignTimeStyle(styleName, styleFileName, null);
    }

    public static Style readDesignTimeStyle(String styleName, String styleFileName, ClassLoader cl) {
        try {
            styleFileName = ValueManager.encodeIntoValidFileName(styleFileName, false);
            String xml = FileManager.readUTF8File(styleFileName, true);
            xml = StyleManager.combineStyleWithAdditionalStyles(xml, styleName, cl);
            Style style = new Style();
            style.setStyleName(styleName);
            SAXParserUtil.parse(xml, (DefaultHandler)new StyleParser(style));
            StyleManager.multiplyOutStyleTagGroupsAfterParsing(style);
            return style;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem when registering style: " + styleName + " / " + styleFileName);
            throw new Error(t);
        }
    }

    public static void addCSSGlobalVariablesToDeignTimeStyle(Style style, String styleFileName) {
        try {
            String cssXmlFileName = StyleManager.findFileNameForCSSStyle(styleFileName);
            if (cssXmlFileName != null) {
                CLog.L.log(CLog.LL_INF, "Reading CSS style " + cssXmlFileName);
                String cssXml = FileManager.readUTF8File(cssXmlFileName, true);
                SAXParserUtil.parse(cssXml, (DefaultHandler)new CSSStyleParser(style));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String combineStyleWithAdditionalStyles(String xml, String styleName, ClassLoader cl) {
        if (xml == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<styles>\n");
        sb.append(xml);
        sb.append("\n");
        if (cl != null) {
            ClassloaderReader clReader = new ClassloaderReader(cl);
            List<String> extensions = clReader.readUTF8FilesWithVariants("/eclntjsfserver/styleextensions/" + styleName + "/style.xml");
            for (String extension : extensions) {
                if (extension == null || extension.length() <= 0) continue;
                sb.append(extension);
                sb.append("\n");
            }
            List<String> addonPackages = PageBeanComponentRepository.readPackageNamesOfStyleExtensions(cl);
            for (String p : addonPackages) {
                try {
                    String resourcePath = "/" + p.replace(".", "/") + "/" + styleName + "/style.xml";
                    String pxml = clReader.readUTF8File(resourcePath, false);
                    if (pxml == null || pxml.length() <= 0) continue;
                    sb.append(pxml);
                    sb.append("\n");
                }
                catch (Throwable t) {
                    CLog.L.log(CLog.LL_ERR, "Problem reading style.xml of package: " + p);
                }
            }
        }
        sb.append("</styles>");
        return sb.toString();
    }

    private static String findPathForCSSStyle(String styleName) {
        try {
            String dir = "/eclntjsfserver/styles/" + styleName + "/";
            List<String> xmlFileNames = StyleFileAccess.findFiles(dir, ".xml");
            if (xmlFileNames.size() == 0) {
                return null;
            }
            for (String xmlFileName : xmlFileNames) {
                if (!xmlFileName.startsWith("riscstyle")) continue;
                return "/eclntjsfserver/styles/" + styleName + "/" + xmlFileName;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static String findFileNameForCSSStyle(String styleXmlFileName) {
        try {
            styleXmlFileName = ValueManager.encodeIntoValidFileName(styleXmlFileName, false);
            int index = styleXmlFileName.lastIndexOf("/");
            String dir = styleXmlFileName.substring(0, index + 1);
            List<String> xmlFileNames = FileManager.getFilesOfDirectoryByPattern(dir, ".xml");
            if (xmlFileNames.size() == 0) {
                return null;
            }
            for (String xmlFileName : xmlFileNames) {
                String endFileName = (xmlFileName = ValueManager.encodeIntoValidFileName(xmlFileName, false)).substring((index = xmlFileName.lastIndexOf("/")) + 1);
                if (!endFileName.startsWith("riscstyle")) continue;
                return xmlFileName;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static void multiplyOutStyleTagGroupsAfterParsing(Style style) {
        try {
            for (StyleTagGroup stg : style.getStyleTagGroups().values()) {
                for (StyleVariant sv : style.getVariants().values()) {
                    StyleTagInfo stiOfGroup = sv.getStyleTagInfo(stg.getName());
                    if (stiOfGroup == null) continue;
                    for (String stgTagName : stg.getTagNames()) {
                        StyleTagInfo stiExisiting = sv.getStyleTagInfo(stgTagName);
                        if (stiExisiting != null) continue;
                        StyleTagInfo stiClone = stiOfGroup.createXMLClone();
                        stiClone.i_tagName = stgTagName;
                        stiClone.i_isGeneratedByStyleTagGroup = true;
                        if (!ValueManager.isEmpty(stiClone.getExtendsVariant()) && (ValueManager.checkIfStringsAreEqual(stiClone.getExtendsTag(), stiOfGroup.getTagName()) || ValueManager.isEmpty(stiClone.getExtendsTag()))) {
                            stiClone.setExtendsTag(stiClone.getTagName());
                        }
                        sv.i_tagInfos.put(stiClone.getTagName(), stiClone);
                    }
                }
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem reading style: " + t, t);
        }
    }

    static {
        CLog.L.log(CLog.LL_INF, "Initialization of Style Manager - registration of stlye default - begin");
        try {
            StyleManager.registerStyle("default", false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            StyleManager.registerStyle("defaultfx", false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            StyleManager.registerStyle("defaultrisc", true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        CLog.L.log(CLog.LL_INF, "Initialization of Style Manager - registration of stlye default - end");
    }

    public static class StyleParser
    extends DefaultHandler {
        Style i_style;
        StyleTagInfo i_currentTagInfo = null;
        StyleTagGroup i_currentStyleTagGroup = null;

        public StyleParser(Style style) {
            this.i_style = style;
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            String n;
            String sExtends;
            super.startElement(uri, localName, name, attributes);
            if (name.equals("style") && (sExtends = attributes.getValue("extends")) != null && this.i_style.getExtends() == null) {
                this.i_style.setExtends(sExtends);
            }
            if (name.equals("tag")) {
                String tagNameWithPrefix = attributes.getValue("name");
                tagNameWithPrefix = StyleManager.updatePrefix(tagNameWithPrefix);
                String tagVariant = attributes.getValue("variant");
                if (tagVariant == null) {
                    tagVariant = "default";
                }
                String tagExtendsParentTag = attributes.getValue("extendsparenttag");
                String tagExtendsTag = attributes.getValue("extendstag");
                tagExtendsTag = StyleManager.updatePrefix(tagExtendsTag);
                String tagExtendsVariant = attributes.getValue("extendsvariant");
                StyleVariant sv = this.i_style.i_variants.get(tagVariant);
                if (sv == null) {
                    sv = new StyleVariant();
                    sv.setVariantName(tagVariant);
                    this.i_style.i_variants.put(tagVariant, sv);
                }
                StyleTagInfo sti = new StyleTagInfo(this.i_style, sv, tagNameWithPrefix);
                sti.setExtendsParentTag(tagExtendsParentTag);
                sti.setExtendsTag(tagExtendsTag);
                sti.setExtendsVariant(tagExtendsVariant);
                sv.getTagInfos().put(tagNameWithPrefix, sti);
                this.i_currentTagInfo = sti;
            } else if (name.equals("set")) {
                String attribute = attributes.getValue("attribute");
                String value = attributes.getValue("value");
                StyleAttributeValue sav = new StyleAttributeValue();
                sav.setAttribute(attribute);
                sav.setValue(value);
                sav.setParsedValue(value);
                this.i_currentTagInfo.addParsedAttributeValue(sav);
            } else if (name.equals("stylevalue")) {
                n = attributes.getValue("name");
                String v = attributes.getValue("value");
                if (n != null && v != null) {
                    StyleValue sv = new StyleValue();
                    sv.setName(n);
                    sv.setValue(v);
                    this.i_style.i_styleValues.put(n, sv);
                }
            } else if (name.equals("styletaggroup")) {
                this.i_currentStyleTagGroup = null;
                n = attributes.getValue("name");
                if (n != null) {
                    StyleTagGroup stg = new StyleTagGroup();
                    stg.setName(n);
                    this.i_style.getStyleTagGroups().put(n, stg);
                    this.i_currentStyleTagGroup = stg;
                }
            } else if (name.equals("styletaggrouptag") && this.i_currentStyleTagGroup != null && (n = attributes.getValue("name")) != null) {
                this.i_currentStyleTagGroup.getTagNames().add(n);
            }
        }
    }

    public static class CSSStyleParser
    extends DefaultHandler {
        Style i_style;
        int i_level = 0;
        int i_styleSheetLevel = -1;

        public CSSStyleParser(Style style) {
            this.i_style = style;
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, name, attributes);
            ++this.i_level;
            if ("stylesheet".equals(name)) {
                this.i_styleSheetLevel = this.i_level;
            }
            if (this.i_level == this.i_styleSheetLevel + 1 && name.equals("var")) {
                String varName = attributes.getValue("n");
                String varValue = attributes.getValue("v");
                String varCategory = attributes.getValue("c");
                if (varName != null && varValue != null) {
                    StyleValue sv = new StyleValue();
                    sv.setName(varName);
                    sv.setValue(varValue);
                    sv.setCategory(varCategory);
                    this.i_style.i_styleValues.put(varName, sv);
                }
            }
        }

        @Override
        public void endElement(String arg0, String arg1, String arg2) throws SAXException {
            super.endElement(arg0, arg1, arg2);
            --this.i_level;
        }
    }

    public static class Style {
        String i_styleName;
        String i_extends = null;
        boolean i_variantsAlreadyExtended = false;
        Map<String, StyleVariant> i_variants = new Hashtable<String, StyleVariant>();
        Map<String, StyleValue> i_styleValues = new HashMap<String, StyleValue>();
        Map<String, StyleTagGroup> i_styleTagGroups = new HashMap<String, StyleTagGroup>();

        public void setStyleName(String value) {
            this.i_styleName = value;
        }

        public String getStyleName() {
            return this.i_styleName;
        }

        public void setExtends(String value) {
            this.i_extends = value;
        }

        public String getExtends() {
            return this.i_extends;
        }

        public Map<String, StyleVariant> getVariants() {
            return this.i_variants;
        }

        public Map<String, StyleValue> getStyleValues() {
            return this.i_styleValues;
        }

        public Map<String, StyleTagGroup> getStyleTagGroups() {
            return this.i_styleTagGroups;
        }

        public void outputXML(StringBuffer sb) {
            Object sv;
            sb.append("<style");
            if (this.getExtends() != null) {
                sb.append(" extends=\"" + ValueManager.encodeIntoValidXMLString(this.getExtends()) + "\"");
            }
            sb.append(">\n");
            ArrayList<String> names = new ArrayList<String>(this.getStyleTagGroups().keySet());
            Collections.sort(names);
            for (String name : names) {
                sv = this.getStyleTagGroups().get(name);
                name = ValueManager.encodeIntoValidXMLString(name);
                sb.append("    <styletaggroup name=\"" + name + "\">\n");
                for (String tagName : ((StyleTagGroup)sv).getTagNames()) {
                    tagName = ValueManager.encodeIntoValidXMLString(tagName);
                    sb.append("        <styletaggrouptag name=\"" + tagName + "\"/>\n");
                }
                sb.append("    </styletaggroup>\n");
            }
            names = new ArrayList<String>(this.getStyleValues().keySet());
            Collections.sort(names);
            for (String name : names) {
                sv = this.getStyleValues().get(name);
                name = ValueManager.encodeIntoValidXMLString(name);
                String value = ValueManager.encodeIntoValidXMLString(((StyleValue)sv).getValue());
                sb.append("    <stylevalue name=\"" + name + "\" value=\"" + value + "\"/>\n");
            }
            ArrayList<String> vNames = new ArrayList<String>(this.getVariants().keySet());
            Collections.sort(vNames);
            for (String vName : vNames) {
                sv = this.getVariants().get(vName);
                ArrayList<String> tNames = new ArrayList<String>(((StyleVariant)sv).getTagInfos().keySet());
                Collections.sort(tNames);
                for (String tName : tNames) {
                    StyleTagInfo sti = ((StyleVariant)sv).getStyleTagInfo(tName);
                    if (sti.i_isGeneratedByStyleTagGroup) continue;
                    sb.append("    <tag name=\"" + tName + "\" variant=\"" + vName + "\"");
                    if (sti.getExtendsParentTag()) {
                        sb.append(" extendsparenttag=\"true\"");
                    }
                    if (sti.getExtendsTag() != null) {
                        sb.append(" extendstag=\"" + ValueManager.encodeIntoValidXMLString(sti.getExtendsTag()) + "\"");
                    }
                    if (sti.getExtendsVariant() != null) {
                        sb.append(" extendsvariant=\"" + ValueManager.encodeIntoValidXMLString(sti.getExtendsVariant()) + "\"");
                    }
                    sb.append(">\n");
                    ArrayList<String> aNames = new ArrayList<String>(sti.getAttributesWithoutInheritance().keySet());
                    Collections.sort(aNames);
                    for (String aName : aNames) {
                        StyleAttributeValue sav = sti.getAttributes().get(aName);
                        if (sav == null) continue;
                        aName = ValueManager.encodeIntoValidXMLString(aName);
                        String aValue = ValueManager.encodeIntoValidXMLString(sav.getValue());
                        sb.append("        <set attribute=\"" + aName + "\" value=\"" + aValue + "\"/>\n");
                    }
                    sb.append("    </tag>\n");
                }
            }
            sb.append("</style>\n");
        }

        public void addStyleValues(Map<String, StyleValue> styleValues) {
            for (String key : this.i_styleValues.keySet()) {
                StyleValue sv = styleValues.get(key);
                if (sv == null) {
                    styleValues.put(key, this.i_styleValues.get(key));
                    continue;
                }
                if (sv.getCategory() != null) continue;
                sv.setCategory(this.i_styleValues.get(key).getCategory());
            }
        }
    }

    public static class StyleVariant {
        String i_variantName;
        Map<String, StyleTagInfo> i_tagInfos = new Hashtable<String, StyleTagInfo>();

        public void setVariantName(String value) {
            this.i_variantName = value;
        }

        public String getVariantName() {
            return this.i_variantName;
        }

        public Map<String, StyleTagInfo> getTagInfos() {
            return this.i_tagInfos;
        }

        public StyleTagInfo getStyleTagInfo(String tagName) {
            StyleTagInfo result = this.i_tagInfos.get(tagName);
            if (result == null) {
                int index = tagName.indexOf(58);
                result = this.i_tagInfos.get(tagName.substring(index + 1));
            }
            return result;
        }
    }

    public static class StyleTagInfo {
        Style i_style;
        StyleVariant i_variant;
        String i_tagName;
        boolean i_extendsParentTag = false;
        boolean i_attributesAlreadyExtendedInnerExtensions = false;
        boolean i_attributesAlreadyExtendedParentExtensions = false;
        String i_extendsTag = null;
        String i_extendsVariant = null;
        boolean i_isGeneratedByStyleTagGroup = false;
        Map<String, StyleAttributeValue> i_attributes = new Hashtable<String, StyleAttributeValue>();
        Map<String, StyleAttributeValue> i_attributesWithoutInheritance = new Hashtable<String, StyleAttributeValue>();
        Map<String, String> i_values = null;

        public StyleTagInfo(Style style, StyleVariant variant, String tagName) {
            this.i_style = style;
            this.i_variant = variant;
            this.i_tagName = tagName;
        }

        public StyleTagInfo(StyleTagInfo sti) {
            this.i_style = sti.i_style;
            this.i_variant = sti.i_variant;
            this.i_tagName = sti.i_tagName;
            this.i_extendsParentTag = sti.i_extendsParentTag;
            this.i_extendsTag = sti.i_extendsTag;
            this.i_extendsVariant = sti.i_extendsVariant;
        }

        public StyleTagInfo createXMLClone() {
            StyleTagInfo result = new StyleTagInfo(this);
            for (StyleAttributeValue sav : this.i_attributes.values()) {
                StyleAttributeValue savClone = new StyleAttributeValue(sav);
                result.addParsedAttributeValue(savClone);
            }
            return result;
        }

        public String getStyleName() {
            return this.i_style.getStyleName();
        }

        public String getStyleVariantName() {
            return this.i_variant.getVariantName();
        }

        public String getTagName() {
            return this.i_tagName;
        }

        public void setExtendsParentTag(String value) {
            this.i_extendsParentTag = ValueManager.decodeBoolean(value, false);
        }

        public void setExtendsParentTag(boolean value) {
            this.i_extendsParentTag = value;
        }

        public void setExtendsTag(String value) {
            this.i_extendsTag = value;
        }

        public void setExtendsVariant(String value) {
            this.i_extendsVariant = value;
        }

        public boolean getExtendsParentTag() {
            return this.i_extendsParentTag;
        }

        public String getExtendsTag() {
            return this.i_extendsTag;
        }

        public String getExtendsVariant() {
            return this.i_extendsVariant;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, StyleAttributeValue> getAttributes() {
            Map<String, StyleAttributeValue> parentAttributes;
            Object object;
            if (!this.i_attributesAlreadyExtendedParentExtensions && this.i_style.getExtends() != null && this.i_extendsParentTag) {
                object = s_syncherResolveParentExtensions;
                synchronized (object) {
                    if (!this.i_attributesAlreadyExtendedParentExtensions) {
                        StyleTagInfo parentTag = StyleManager.getTagInfo(this.i_style.getExtends(), this.i_variant.getVariantName(), this.i_tagName);
                        if (parentTag != null) {
                            parentAttributes = parentTag.getAttributes();
                            for (String attribute : parentAttributes.keySet()) {
                                if (this.i_attributes.containsKey(attribute)) continue;
                                this.i_attributes.put(attribute, new StyleAttributeValue(parentAttributes.get(attribute)));
                            }
                            if (this.i_extendsTag == null) {
                                this.i_extendsTag = parentTag.i_extendsTag;
                                this.i_extendsVariant = parentTag.i_extendsVariant;
                            }
                        }
                        this.removeExplicitNullAttributes();
                        this.i_attributesAlreadyExtendedParentExtensions = true;
                    }
                }
            }
            if (!(this.i_attributesAlreadyExtendedInnerExtensions || this.i_extendsTag == null || ValueManager.checkIfStringsAreEqual(this.i_extendsTag, this.i_tagName) && ValueManager.checkIfStringsAreEqual(this.i_extendsVariant, this.i_variant.getVariantName()))) {
                object = s_syncherResolveInnerExtensions;
                synchronized (object) {
                    if (!this.i_attributesAlreadyExtendedInnerExtensions) {
                        StyleTagInfo referredTag = StyleManager.getTagInfo(this.i_style.getStyleName(), this.i_extendsVariant, this.i_extendsTag);
                        if (referredTag != null) {
                            parentAttributes = referredTag.getAttributes();
                            for (String attribute : parentAttributes.keySet()) {
                                StyleAttributeValue ownSav = this.i_attributes.get(attribute);
                                if (ownSav != null && !ownSav.isValueTakenOverFromExtendsTag()) continue;
                                StyleAttributeValue newSav = new StyleAttributeValue(parentAttributes.get(attribute));
                                newSav.setValueTakenOverFromExtendsTag(true);
                                this.i_attributes.put(attribute, newSav);
                            }
                        }
                        this.removeExplicitNullAttributes();
                        this.i_attributesAlreadyExtendedInnerExtensions = true;
                    }
                }
            }
            return this.i_attributes;
        }

        private void removeExplicitNullAttributes() {
        }

        public Map<String, StyleAttributeValue> getAttributesWithoutInheritance() {
            return this.i_attributesWithoutInheritance;
        }

        private Map<String, StyleAttributeValue> getAttributesMap() {
            return this.i_attributes;
        }

        public void addParsedAttributeValue(StyleAttributeValue attributeValue) {
            if (attributeValue.getAttribute() == null) {
                CLog.L.log(CLog.LL_INF, "Style definition: missing attribute definition in attribute value: " + this.i_style.getStyleName() + ", " + this.i_tagName);
                return;
            }
            this.i_attributes.put(attributeValue.getAttribute(), attributeValue);
            this.i_attributesWithoutInheritance.put(attributeValue.getAttribute(), attributeValue);
        }

        public void updateParsedAttributeValue(StyleAttributeValue attributeValue) {
            if (attributeValue.getAttribute() == null) {
                CLog.L.log(CLog.LL_INF, "Style definition: missing attribute definition in attribute value: " + this.i_style.getStyleName() + ", " + this.i_tagName);
                return;
            }
            this.i_attributes.put(attributeValue.getAttribute(), attributeValue);
            this.i_attributesWithoutInheritance.put(attributeValue.getAttribute(), attributeValue);
        }

        public void removeParsedAttributeValue(String attribute) {
            this.i_attributes.remove(attribute);
            this.i_attributesWithoutInheritance.remove(attribute);
            this.i_attributesAlreadyExtendedInnerExtensions = false;
            this.getAttributes();
        }

        public Map<String, String> getValueMap() {
            Map<String, String> result = null;
            result = this.i_values;
            if (result == null) {
                boolean expressionOccurred = false;
                result = new Hashtable<String, String>(this.getAttributes().size());
                Map<String, StyleAttributeValue> attributeValues = this.getAttributes();
                for (String key : attributeValues.keySet()) {
                    StyleAttributeValue sav = attributeValues.get(key);
                    if (sav == null) continue;
                    String valueStr = sav.getValue();
                    if (sav.getValue() != null && BaseComponentTag.checkIfIsValueReference(key, valueStr)) {
                        Object valueObj = ExpressionManagerV.getValueForExpressionString(HttpSessionAccess.getCurrentFacesContext(), sav.getValue());
                        if (valueObj == null) continue;
                        valueStr = "" + valueObj;
                        expressionOccurred = true;
                    }
                    result.put(key, valueStr);
                }
                if (!expressionOccurred) {
                    this.i_values = result;
                }
            }
            return result;
        }
    }

    public static class StyleAttributeValue {
        String i_attribute;
        String i_value;
        String i_parsedValue;
        boolean i_valueTakenOverFromExtendsTag = false;

        public StyleAttributeValue() {
        }

        public StyleAttributeValue(StyleAttributeValue copyFrom) {
            this.i_attribute = copyFrom.i_attribute;
            this.i_value = copyFrom.i_value;
            this.i_parsedValue = copyFrom.i_parsedValue;
            this.i_valueTakenOverFromExtendsTag = copyFrom.i_valueTakenOverFromExtendsTag;
        }

        public void setAttribute(String value) {
            this.i_attribute = value;
        }

        public String getAttribute() {
            return this.i_attribute;
        }

        public void setValue(String value) {
            this.i_value = value;
        }

        public String getValue() {
            return this.i_value;
        }

        public void setParsedValue(String value) {
            this.i_parsedValue = value;
        }

        public String getParsedValue() {
            return this.i_parsedValue;
        }

        public boolean isValueTakenOverFromExtendsTag() {
            return this.i_valueTakenOverFromExtendsTag;
        }

        public StyleAttributeValue setValueTakenOverFromExtendsTag(boolean valueTakenOverFromExtendsTag) {
            this.i_valueTakenOverFromExtendsTag = valueTakenOverFromExtendsTag;
            return this;
        }
    }

    public static class StyleTagGroup {
        String i_name;
        List<String> i_tagNames = new ArrayList<String>();

        public String getName() {
            return this.i_name;
        }

        public void setName(String name) {
            this.i_name = name;
        }

        public List<String> getTagNames() {
            return this.i_tagNames;
        }

        public void setTagNames(List<String> tagNames) {
            this.i_tagNames = tagNames;
        }
    }

    public static class StyleValue
    implements Comparable<StyleValue> {
        String i_name;
        String i_value;
        String i_category;

        public String getName() {
            return this.i_name;
        }

        public void setName(String name) {
            this.i_name = name;
        }

        public String getValue() {
            return this.i_value;
        }

        public void setValue(String value) {
            this.i_value = value;
        }

        public String getCategory() {
            return this.i_category;
        }

        public void setCategory(String category) {
            this.i_category = category;
        }

        @Override
        public int compareTo(StyleValue o) {
            String c1 = this.i_category;
            String c2 = o.i_category;
            if (c1 == null && c2 != null) {
                return 1;
            }
            if (c1 != null && c2 == null) {
                return -1;
            }
            if (c1 == null && c2 == null) {
                return this.i_name.compareTo(o.getName());
            }
            int result = c1.compareTo(c2);
            if (result != 0) {
                return result;
            }
            return this.i_name.compareTo(o.getName());
        }
    }
}

